// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// CDataHandler: Class to implement IReplObjHandler for serialize/deserialize object

#include "stdafx.h"
#include ".\cldesktop\ListDB.h"
#include <cesync.h>
#include "component.h"

////////////////////////////////////////////////////////////////////////////////
// Construction/Destruction implementation

CDataHandler::CDataHandler()
{
	m_cRef = 1;
}

CDataHandler::~CDataHandler()
{
}

void CDataHandler::SetDatabase(CListDB* pListDB)
{
	m_pListDB = pListDB;
}

////////////////////////////////////////////////////////////////////////////////
// IUnknown implementation

STDMETHODIMP_(ULONG) CDataHandler::AddRef()
{
	InterlockedIncrement(&m_cRef);
	return m_cRef;
}

STDMETHODIMP_(ULONG) CDataHandler::Release()
{
	InterlockedDecrement(&m_cRef);
	return m_cRef;
}

STDMETHODIMP CDataHandler::QueryInterface(REFIID iid, void ** ppvObject)
{
	*ppvObject = NULL;
	return E_NOINTERFACE;		// no other interfaces are supported
}

////////////////////////////////////////////////////////////////////////////////
// IReplObjHandler implementation

// Called to initialize transfer of an object
STDMETHODIMP CDataHandler::Setup(PREPLSETUP pSetup)
{
	// Can be reading and writing at the same time, so need two setups
	if(pSetup->fRead)
		m_pReadSetup = pSetup;
	else
		m_pWriteSetup = pSetup;
	return NOERROR;
}

// Called to allow any resources to be freed after serialization/deserialization
STDMETHODIMP CDataHandler::Reset(PREPLSETUP pSetup)
{
	return NOERROR;	// no resources to be freed
}

// Serializes object into one or more packets. In this case, a single packet is returned
STDMETHODIMP CDataHandler::GetPacket(LPBYTE *lppbData, DWORD *pcbData, DWORD cbRecommend)
{
	NOTE * pNote = new NOTE;
	LPREPLOBJECT lpRepObj = (LPREPLOBJECT)m_pReadSetup->hItem;

	if(m_pReadSetup->hItem == NULL)
		return E_UNEXPECTED;
	// locate the note in the file
	if(!m_pListDB->FindNote(&lpRepObj->ftCreated, pNote))
	{
		MessageBox(NULL, _T("GetPacket: Could not find record"), NULL, MB_OK);
		return RERR_BAD_OBJECT;
	}
	else
	{
		*lppbData = (LPBYTE)pNote;
		*pcbData = sizeof(NOTE);
	}
	return RWRN_LAST_PACKET;
}

// Deserializes object and writes/updates record in database
STDMETHODIMP CDataHandler::SetPacket(LPBYTE lpbData, DWORD cbData)
{
	NOTE* lpNote = (NOTE*)lpbData;
	LPREPLOBJECT lpRepl = new REPLOBJECT;

	if(m_pWriteSetup->hItem != NULL)		// Have a HREPLITEM - must be an existing record
	{
		if(!m_pListDB->FindNote(&lpNote->ftOriginal))
		{
			MessageBox(NULL, _T("Could not find existing note in SetPacket"), NULL, MB_OK);
			return E_UNEXPECTED;
		}
		// update record
		m_pListDB->UpdateNote(&lpNote->ftOriginal, lpNote->szNote);
	}
	else
	{
		// add record
		if(m_pWriteSetup->dwFlags & RSF_CONFLICT_OBJECT)
			memset(&lpNote->ftOriginal, 0, sizeof(FILETIME));
		m_pListDB->AddNote(&lpNote->ftOriginal, 
					&lpNote->ftLastUpdate, lpNote->szNote);
	}
	lpRepl->uType = RT_ITEM;
	lpRepl->ftModified = lpNote->ftLastUpdate;
	lpRepl->ftCreated = lpNote->ftOriginal;
	m_pWriteSetup->hItem = (HREPLITEM)lpRepl;

	return NOERROR;
}

// synchronized object needs to be deleted

STDMETHODIMP CDataHandler::DeleteObj(PREPLSETUP pSetup)
{
	LPREPLOBJECT lpRepObj = (LPREPLOBJECT)pSetup->hItem;
	
	if(!m_pListDB->DeleteNote(&lpRepObj->ftCreated))
		MessageBox(NULL, _T("Could not delete record"), NULL, 0);
	return NOERROR;
}
 