// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// ListDB.h: interface for the CListDB class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LISTDB_H__10A6AB6B_99E3_11D3_983B_00A024A0443A__INCLUDED_)
#define AFX_LISTDB_H__10A6AB6B_99E3_11D3_983B_00A024A0443A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define DB_NAME _T("ActiveSynNotes")		// ActiveSynch notes database
#define CE_DB_IDENT		23929			// database identifier

// tags for the ActiveSync Notes database
#define PROP_DATEADDED			1		// date note was added
#define PROP_NOTE				2		// the note (constrained to 255 bytes by desktop)
#define PROP_MODIFIED			3		// date when note was last modified

class CListDB : public CCeDBDatabase  
{
public:
	BOOL DeleteAll();
	BOOL AddNote(CString& sNote);
	BOOL UpdateNote(CString& sNoteTime, CString& sNote);
	BOOL DeleteNote(CString& sNoteTime);
	BOOL FindNote(CString& sNoteTime);
	BOOL ListNotes(CListCtrl& lstCtrl);
	BOOL OpenCreateDatabase(CWnd* pWnd = NULL);
	CListDB();
	virtual ~CListDB();

};

#endif // !defined(AFX_LISTDB_H__10A6AB6B_99E3_11D3_983B_00A024A0443A__INCLUDED_)
