page	60,132
title	Set a screen mode
name	smode

code	segment
assume	cs:code

	org	100h		;for .com file

begin:
	mov	ax,cs
	mov	ds,ax		;ds = cs

;look for command line parameters
	cld
	xor	ch,ch
	mov	si,80h		;point to command line input
	lodsb			;get string length
	mov	cl,al
	jcxz	noargs		;jump if no command line parameters

getmode:
	lodsb			;get character
	sub	al,'0'		;is it a digit?
	cmp	al,9
	jbe	gotmode		;yes-jump
	loop	getmode
	jmp	short noargs	;couldn't find mode

gotmode:
;al contains the mode. See if IBM or Mindset.
	xor	ah,ah			;ah=0 for set mode
	cmp	byte ptr ds:[si],'i'	;ibm?
	je	ibm			;yes-jump
	cmp	byte ptr ds:[si],'I'	;ibm?
	je	ibm			;yes-jump

	int	0efh		;set minset mode
	jmp	short exit

ibm:	int	10h		;set ibm mode
	jmp	short exit

noargs:
;print out a help message and exit without changing modes
	mov	ah,9		;display string
	mov	dx,offset msg	;ds:dx points to message
	int	21h		;dos call

exit:
	mov	ax,4c00h	;return to dos
	int	21h


msg	label	byte		;help message
	db	13,10
	db	'SMODE  mode  (sets screen mode).',13,10
	db	'mode = 0  => Mindset 320x200x1',13,10
	db	'       1  => Mindset 320x200x2',13,10
	db	'       2  => Mindset 320x200x4',13,10
	db	'       3  => Mindset 640x200x1',13,10
	db	'       4  => Mindset 640x200x2',13,10
	db	'       5  => Mindset 320x400x2',13,10
	db	'       6  => Mindset 640x400x1',13,10
	db	'       0i => IBM 40x25 BW',13,10
	db	'       1i => IBM 40x25 Color',13,10
	db	'       2i => IBM 80x25 BW',13,10
	db	'       3i => IBM 80x25 Color',13,10
	db	'       4i => IBM 320x200 BW',13,10
	db	'       5i => IBM 320x200 Color',13,10
	db	'       6i => IBM 640x200 BW',13,10
	db	'$'
code	ends
end	begin
