title Bios to C interface routines

name callbios


pgroup group prog
prog segment byte public 'prog'
assume cs:pgroup

public callbios, data_seg, code_seg, extra_seg

include macro186.inc

;------------------------------------------------------------------------------
;
;	callbios
;
;	as called from a c program:
;		callbios(int_number, &reg_structure);
;	reg_structure struct {
;		int	ax_reg;
;		int	bx_reg;
;		int	cx_reg;
;		int	dx_reg;
;		int	si_reg;
;		int	di_reg;
;		int	ds_reg;
;		int	es_reg;
;		int	flags;
;	}
;
;	passed:
;		int_number = where to interrupt to
;		&reg_structure = offset of registers to pass, return.
;	returned:
;		bios or dos call done,
;		reg_structure updated.
;		flags format:
;			bit 0 = carry
;			bit 2 = parity
;			bit 4 = aux carry
;			bit 6 = zero flag
;			bit 7 = sign flag
;			bit 8 = single step trap flag
;			bit 9 = interrupt enable
;			bit 10 = direction flag
;			bit 11 = overflow flag
;
;	destroys ax, bx, cx, dx, si, di
;
;------------------------------------------------------------------------------
callbios proc near
	push	bp		;save old bp
	mov	bp, sp
	push	ds
	push	es

; set up the interrupt instructions on the stack
	mov	ax, ss:[bp + 4]	;get interrupt type
	pushw	0cbcbh		;push two return instructions to be safe
	mov	ah, 0cdh	;interrupt instruction
	xchg	ah, al		;make it int nn
	push	ax		;put interrupt on stack

; set up the routine address to call
	mov	ax, sp		;save that address
	push	ss		;segment to call
	push	ax		;offset

; now get the registers set up
	mov	bp, ss:[bp + 6]		;get register structure pointer

	mov	ax, ss:[bp + 0]		;register ax
	mov	bx, ss:[bp + 2]		;register bx
	mov	cx, ss:[bp + 4]		;register cx
	mov	dx, ss:[bp + 6]		;register dx
	mov	si, ss:[bp + 8]		;register si
	mov	di, ss:[bp + 10]	;register di
	mov	ds, ss:[bp + 12]	;register ds
	mov	es, ss:[bp + 14]	;register es

; call the routine, through the stack
	push	bp
	mov	bp, sp			;sp was pointing to pushed routine
	call	dword ptr ss:[bp + 2]
	pop	bp
	push	ax
	pushf
	pop	ax
	mov	ss:[bp + 16], ax	;flags
	pop	ax
	add	sp, 8			;take routine off stack

; put in changed registers.
	mov	ss:[bp + 0], ax		;register ax
	mov	ss:[bp + 2], bx		;register bx
	mov	ss:[bp + 4], cx		;register cx
	mov	ss:[bp + 6], dx		;register dx
	mov	ss:[bp + 8], si		;register si
	mov	ss:[bp + 10], di	;register di
	mov	ss:[bp + 12], ds	;register ds
	mov	ss:[bp + 14], es	;register es

	pop	es
	pop	ds
	pop	bp
	ret

callbios endp

;------------------------------------------------------------------------------
;
;	data_seg
;
;	as called from a c program:
;		int_variable = data_seg();
;		int int_variable;
;
;	passed:
;		nothing
;	returned:
;		function value is current data segment (in AX)
;
;------------------------------------------------------------------------------
data_seg proc near
	mov	ax, ds
	ret
data_seg endp

;------------------------------------------------------------------------------
;	code_seg
;
;	as called from a c program:
;		int_variable = code_seg();
;		int	int_variable;
;
;	passed:
;		nothing
;	returned:
;		function value is current code segment (in AX)
;
;------------------------------------------------------------------------------
code_seg proc near
	mov	ax, cs
	ret
code_seg endp

;------------------------------------------------------------------------------
;
;	extra_seg
;
;	as called from a c program:
;		int_variable = extra_seg();
;		int	int_variable;
;
;	passed:
;		nothing
;	returned:
;		function value is current extra segment (in AX)
;
;------------------------------------------------------------------------------
extra_seg proc near
	mov	ax, es
	ret
extra_seg endp

prog ends
end
