title C to DOS interface routine

name calldos


pgroup group prog
prog segment byte public 'prog'
assume cs:pgroup

public calldos

;------------------------------------------------------------------------------
;
;	calldos
;
;	as called from a c program:
;		calldoss(&reg_structure);
;	reg_structure struct {
;		int	ax_reg;
;		int	bx_reg;
;		int	cx_reg;
;		int	dx_reg;
;		int	si_reg;
;		int	di_reg;
;		int	flags;
;	}
;
;	passed:
;		&reg_structure = offset of registers to pass, return.
;	returned:
;		dos call done,
;		reg_structure updated.
;		flags format:
;			bit 0 = carry
;			bit 2 = parity
;			bit 4 = aux carry
;			bit 6 = zero flag
;			bit 7 = sign flag
;			bit 8 = single step trap flag
;			bit 9 = interrupt enable
;			bit 10 = direction flag
;			bit 11 = overflow flag
;
;	destroys ax, bx, cx, dx, si, di
;
;------------------------------------------------------------------------------
calldos proc near
	push	bp		;save old bp
	mov	bp, sp

;get the registers set up
	mov	bp, ss:[bp + 4]		;get register structure pointer

	mov	ax, ss:[bp + 0]		;register ax
	mov	bx, ss:[bp + 2]		;register bx
	mov	cx, ss:[bp + 4]		;register cx
	mov	dx, ss:[bp + 6]		;register dx
	mov	si, ss:[bp + 8]		;register si
	mov	di, ss:[bp + 10]	;register di

; call the routine
	int	21h
	push	ax
	pushf
	pop	ax
	mov	ss:[bp + 12], ax	;flags
	pop	ax

; put in changed registers.
	mov	ss:[bp + 0], ax		;register ax
	mov	ss:[bp + 2], bx		;register bx
	mov	ss:[bp + 4], cx		;register cx
	mov	ss:[bp + 6], dx		;register dx
	mov	ss:[bp + 8], si		;register si
	mov	ss:[bp + 10], di	;register di

	pop	bp
	ret

calldos endp

prog ends
end
