/*	CURSOR0.C - program to display MINDSET basic palette of 16 colors		*/
/*				Pressing any key with the palette displayed will exit.		*/
#include	<cuser.inc>
										/* define RGB/composite color bits	*/
#define	black		0x0000 + 0000
#define	dkblue		0x1000 + 0500
#define	dkgreen		0x2000 + 0050
#define	dkcyan		0x3000 + 0550
#define	dkred		0x4000 + 0005
#define	dkmagent 	0x5000 + 0505
#define	dkyellow	0x6000 + 0055
#define	dkwhite		0x7000 + 0555
#define	dkgray		0x8000 + 0222
#define	blue 		0x9000 + 0700
#define	green		0xa000 + 0070
#define	cyan 		0xb000 + 0770
#define	red  		0xc000 + 0007
#define	magenta		0xd000 + 0707
#define	yellow		0xe000 + 0077
#define	white		0xf000 + 0777

/***************************** C O L O R 0 . C ******************************/

main()
{

int	dummy, x_org, y_org,ecolor,ocolor;	/* integer variable declarations	*/
											
static int palette[16] = {
 black, dkblue, dkgreen, dkcyan, dkred, dkmagent, dkyellow, dkwhite,        
 dkgray,  blue,   green,   cyan,   red,  magenta,   yellow,   white
	};									/* define palette order for display	*/


static struct xypair square[] = {
		{ 0, 0},	{ 40, 0},	{ 40, 50},	{ 0, 50},
	};									/* define outlines of color boxes	*/

static struct xypair outlines[] = {
		{ 0, 0},	{ 319, 0},		{ 319, 100},		{ 0, 100},
		{ 0, 0},	{   0, 50},		{ 319, 50}
	};									/* define point pairs for outline	*/

	
	setmode(2);							/* MINDSET mode=2  320x200x16 colors*/
	filldest(0);						/* erase displayr with black pixels */

	setpalette(0, 16, 0, &palette);
										/* set up 16 color palette			*/
	
	ecolor = 0;							/* set both dither colors to BLACK	*/
	ocolor = 0;
										/* draw 2 rows of 8 colors each		*/
	for(y_org = 0; y_org < 100; y_org += 50)
		for(x_org = 0; x_org < 320; x_org += 40)
			{
										/* draw 40x50 pixel color block		*/
		   	polygons(0,4,ecolor,ecolor,x_org,y_org,&square);              
							/* id, count, evencolor, oddcolor, x0, y0, data */

			ecolor += 1;				/* increment color index			*/
			}


	x_org = 0;							/* set display origin to (0,0)		*/
	y_org = 0;

	lines(0,7,15,x_org,y_org,&outlines,0);
										/* draw white outline around colors	*/

	getkey(&dummy);						/* wait for user to press any key	*/
	setmode(3);							/* set MINDSET mode 640x200x4 color	*/
	setibmmode(2);						/* set IBM character mode w/ cursor	*/
	exit();
}										/* end of COLOR0.C					*/

							
setibmmode(video_mode) 		/* set IBM video display mode  */ 
int video_mode;				/* argument for BIOS call      */
	{
	struct regs myregs;		/* structure from CUSER.INC    */
	myregs.ax = video_mode;	/* set 80186 register AX = mode*/
	callbios(i_io_int, &myregs);	/* actual call to BIOS */
	return;
	}
	