/* ------------------------------------------

	These are the IBM bios call routines.

------------------------------------------ */

#include <cuser.inc>

/* ---------------------- set_ibm_mode ----------------------------------*/
set_ibm_mode(video_mode) /* set IBM video display mode */
int video_mode;          /* mode argument for BIOS call*/
{
 struct regs myregs;     /* structure from CUSER.INC   */
 myregs.ax = 0x0000 + video_mode;
                         /* set 80186 register AX      */
 callbios(i_io_int, &myregs);
 return;                 /* return after setting mode  */
}

/* ----------------------- set_cursor_position -------------------------*/
set_cursor_position(page, row, column)
char page;					/* page for character to go to */
char row;					/* character row */
char column;				/* character column */
{
	struct regs myregs;
	myregs.ax = 0x200;
	myregs.bx = (page << 8);
	myregs.cx = column;
	myregs.dx = (row << 8) + column;
	callbios(i_io_int, &myregs);
	return;
}

/* ------------------------ get_cursor_position ------------------------*/
get_cursor_position(page, row, column)
char page;					/* page for character to go to */
char *row;					/* character row */
char *column;				/* character column */
{
	struct regs myregs;
	myregs.ax = 0x300;
	myregs.bx = (page << 8);
	callbios(i_io_int, &myregs);
	*row = (myregs.dx & 0xff00) >> 8;
	*column = myregs.dx & 0xff;
	return;
}

/* ------------------------ write_char_only ----------------------------*/
write_char_only(page, chr, color, count)
char page;					/* page for character to go to */
char chr;					/* character to write */
char color;					/* character color */
int	count;					/* number of duplicates */
{
	struct regs myregs;
	myregs.ax = 0x900 + chr;
	myregs.bx = (page << 8) + color;
	myregs.cx = count;
	callbios(i_io_int, &myregs);
	return;
}

/* ----------------------- write_char_cursor --------------------------*/
write_char_cursor(page, chr, color, count)
char page;					/* page for character to go to */
char chr;					/* character to write */
char color;					/* character color */
int	count;					/* number of duplicates */
{
	struct regs myregs;
	myregs.ax = 0xa00 + chr;
	myregs.bx = (page << 8) + color;
	myregs.cx = count;
	callbios(i_io_int, &myregs);
	return;
}

/* ------------------------ write_dot --------------------------------*/
write_dot(row, column, color)
int row;					/* pixel row */
int	column;					/* pixel column */
char color;					/* what color */
{
	struct regs myregs;
	myregs.ax = 0xc00 + color;
	myregs.cx = column;
	myregs.dx = row;
	callbios(i_io_int, &myregs);
	return;
}

/* -------------------------- read_dot --------------------------------*/
char read_dot(row, column, color)
int row;					/* pixel row */
int	column;					/* pixel column */
{
	struct regs myregs;
	myregs.ax = 0xd00;
	myregs.cx = column;
	myregs.dx = row;
	callbios(i_io_int, &myregs);
	return(myregs.ax & 0xf);
}

/* -------------------------- write_teletype --------------------------*/
write_teletype(page, chr, color)
char page;					/* page for character to go to */
char chr;					/* character to write */
char color;					/* character color */
{
	struct regs myregs;
	myregs.ax = 0xe00 + chr;
	myregs.bx = (page << 8) + color;
	callbios(i_io_int, &myregs);
	return;
}

/* ---------------------------- get_kb_char -----------------------------*/
char get_kb_char(scancode)
char *scancode;					/* scan code for character typed */
{
	struct regs myregs;
	myregs.ax = 0;
	callbios(i_kb_int, &myregs);
	*scancode = (myregs.ax & 0xff00) >> 8;
	return(myregs.ax & 0xff);	/* return the ascii of the key */
}

/* --------------------------- test_kb_buffer ---------------------------*/
char test_kb_buffer()
{
	struct regs myregs;
	myregs.ax = 0x100;
	callbios(i_kb_int, &myregs);
	if (myregs.flags & zerofl)
		return(0);				/* return 0 if no char */
	else return(1);				/* return 1 otherwise */
}

/* -------------------------- get_kb_shift_status ----------------------*/
char get_kb_shift_status()
/* return bit:	0 = right shift key
				1 = left shift key
				2 = control key
				3 = alternate key
				4 = scroll lock key
				5 = numeric lock key
				6 = caps lock key
				7 = insert
*/
{
	struct regs myregs;
	myregs.ax = 0x200;
	callbios(i_kb_int, &myregs);
	return(myregs.ax & 0xff);		/* return shift status */
}
