{ COLOR0.PA1  - program to display MINDSET extended palette consisting of	}
{				2-color dithering of the 16 basic palette colors.			}
program color1(input,output);

	const
		COLOR		= 15;				{ 0-15 colors in MINDSET RGB palette}

	type
		COLORS =						{ ascending order of colors by RGB	} 
		 (BLACK, DKBLUE, DKGREEN, DKCYAN, DKRED, DKMAGENTA, DKYELLOW, DKWHITE,
  		  DKGRAY,  BLUE,   GREEN,   CYAN,   RED,   MAGENTA,   YELLOW,   WHITE);

		POINTS = array [0..1] of word;   
										{ definition of (x,y) point			}
		{$include:'bios.typ'}
										{ MINDSET register definitions		}

	var
		kb_scan:		byte;			{ variable used to get keyboard scan}
		kb_char:		char;			{ variable used to get keyboard char}
		data_offset:	word;			{ BX for variable in get_word_addr	}
		data_segment:	word;			{ ES for variable in get_word_addr	}
		ptr_palette:	ADS OF word;  	{ basic color palette for MINDSET	}
		palette:		array [0..COLOR] of word;   
										{ MINDSET basic COLORS palette		}
		even_color:		byte;			{ even numbered pixel color  		}
		odd_color:		byte;			{ odd numbered pixel color			}
		x,y:			integer;		{ loop variables for x_ & y_org		}
		x_org:			integer;		{ x-coordinate of point to display	}
		y_org:			integer;		{ y-coordinate of point to display	}
		ptr_square:		ADS OF word;	{ pointer to square definition		}
		square:			array [0..4] of POINTS;
										{ definition of square POINTS array	}
		{$include:'bios.ext'}
										{ MINDSET BIOS procedure definitions}

{*************************** C O L O R 1 . P A S ***************************}
	begin								{ start of main COLOR1.PAS program	}

		ptr_square		:= ADS square;	{ set pointer to square				}
										{ store corner points of square		}
		square[0][0]	:= 00;			{ square point [0] at (00,00)		}
		square[0][1]	:= 00;			{ square point [0] at (00,00)		}

		square[1][0]	:= 19;			{ square point [1] at (19,00)		}
		square[1][1]	:= 00;			{ square point [1] at (19,00)		}

		square[2][0]	:= 19;			{ square point [2] at (19,12)		}
		square[2][1]	:= 12;			{ square point [2] at (19,12)		}

		square[3][0]	:= 00;			{ square point [3] at (00,12)		}
		square[3][1]	:= 12;			{ square point [3] at (00,12)		}
		

		ptr_palette			:= ADS palette;
										{ set up pointer to palette			}
										{ store MINDSET RGB palette values	}
		palette[ord(BLACK)]		:= 16#0000;
		palette[ord(DKBLUE)]	:= 16#1000;
		palette[ord(DKGREEN)]	:= 16#2000;
		palette[ord(DKCYAN)]	:= 16#3000;
		palette[ord(DKRED)]		:= 16#4000;
		palette[ord(DKMAGENTA)]	:= 16#5000;
		palette[ord(DKYELLOW)]	:= 16#6000;
		palette[ord(DKWHITE)]	:= 16#7000;
		palette[ord(DKGRAY)]	:= 16#8000;
		palette[ord(BLUE)]		:= 16#9000;
		palette[ord(GREEN)]		:= 16#A000;
		palette[ord(CYAN)]		:= 16#B000;
		palette[ord(RED)]		:= 16#C000;
		palette[ord(MAGENTA)]	:= 16#D000;
		palette[ord(YELLOW)]	:= 16#E000;
		palette[ord(WHITE)]		:= 16#F000;

		set_screen_mode(2);				{ MINDSET mode 320x200x16 color mode}

		fill_dest_buffer(ord(BLACK));	{ erase screen by writing all BLACK	}


		get_word_addr(ptr_palette^,data_offset,data_segment);
										{ get ES:BX for palette				}
		set_palette(ord(BLACK),ord(BLACK),COLOR,data_offset,data_segment);
										{ set MINDSET palette on machine	}


		get_word_addr(ptr_square^,data_offset,data_segment);
										{ get ES:BX for square     			}

		even_color	:= ord(BLACK);		{ even numbered pixels initially	}
		odd_color	:= ord(BLACK);		{ odd numbered pixels initially		}

		x_org		:= 18;				{ draw 16 color palette bar at top	}
		x			:= 18;				{ x increment for color bar			}
		y_org		:= 00;				{ starting at (x,y) = (18,00)      	}

		for even_color := 0 to 15 do
				blt_polygon(0,4,even_color,even_color,
							x_org+(x*ord(even_color)),y_org,
							data_offset,data_segment);


		x_org		:= 00;				{ draw 16 color palette bar at left	}
		y_org		:= 11;				{ starting at (x,y) = (00,11)      	}
		y			:= 11;				{ y increment for color bar			}

		for odd_color := 0 to 15 do
				blt_polygon(0,4,odd_color,odd_color,
							x_org,y_org+(y*ord(odd_color)),
							data_offset,data_segment);

	
		
		x_org		:= 18;				{ draw 2-color dithered colors  	}
		y_org		:= 11;
		x			:= 18;				{ size of each color block is		}
		y			:= 11;				{ 18x11 pixels						}
										{ draw 16 colors in boxes on display}
		for even_color := 0 to 15 do	{ make columns/rows same even/odd	}
			for odd_color := 0 to 15 do
				blt_polygon(0,4,even_color,odd_color,
							x_org+(x*ord(even_color)),
							y_org+(y*ord(odd_color)),
							data_offset,data_segment);
										{ data_offset & segment for square	}


										{ store corner points of outline	}
		square[0][0]	:= 18;			{ square point [0] at (18,11)		}
		square[0][1]	:= 11;			{ square point [0] at (18,11)		}

		square[1][0]	:= 307;			{ square point [1] at (307,11)		}
		square[1][1]	:= 11;			{ square point [1] at (307,11)		}

		square[2][0]	:= 307;			{ square point [2] at (307,188)		}
		square[2][1]	:= 188;			{ square point [2] at (307,188)		}

		square[3][0]	:= 18;			{ square point [3] at (18,188)		}
		square[3][1]	:= 188;			{ square point [3] at (18,188)		}

		square[4][0]	:= 18;			{ square point [4] at (18,11)		}
		square[4][1]	:= 11;			{ square point [4] at (18,11)		}

		blt_polyline(0,5,ord(WHITE),chained,0,0,data_offset,data_segment);
										{ data_offset & segment for outline	}

		
		get_kb_char(kb_char,kb_scan);	{ wait for user to press any key	}

		set_screen_mode(3);				{ MINDSET mode 640x200 for 80 column}

		set_ibm_mode(2);				{ set IBM character mode with cursor}

	end.								{ end of COLOR1.PAS program			}

