TITLE (ASM86 ROUTINES TO INTERFACE BIOS TO MS-DOS PASCAL)


;         *********************************************************
;         *     Copyright 1983 Mindset Corp. This program         *
;         *     is an unpublished work of authorship protected    *
;         *     by the copyright laws of the United States.       *
;         *     This program is also the confidential,            *
;         *     proprietary information of Mindset Corp. and      *
;         *     is not to be copied, used or altered in any       *
;         *     way without the express permission of Mindset     *
;         *     Corp.                                             *
;         *********************************************************

;         *********************************************************
;         *  This program is designated a Mindset Utility as      *
;         *  defined in the Mindset Corp. Development Software    *
;         *  License Agreement.                                   *
;         *********************************************************



NAME ASM86_BIOS_PASCAL_INTERFACE

PUBLIC	BIOS_INTERRUPT
PUBLIC	GET_EXTERNAL_PROCEDURE_ADDR
PUBLIC	SAVE_DS_REGISTER
PUBLIC	DISPLAY_INT_ENTRY
PUBLIC	COLL_CLIP_INT_ENTRY

;THESE EXTERNALS MUST BE DECLARED OUTSIDE OF A SEGMENT BLOCK
EXTRN	DISPLAY_INT_HANDLER:FAR
EXTRN	COLL_CLIP_INT_HANDLER:FAR



ASSUME	CS:ASM86_CODE
ASM86_CODE	SEGMENT	PUBLIC	'CODE'

BIOS_INTERRUPT	PROC	FAR

;-------------------- BIOS_INTERRUPT ------------------------------------------
;
; BIOS_INTERRUPT IS AN ASM86 ROUTINE WHICH MAY BE CALLED FROM PASCAL
;		 USING THE FOLLOWING DECLARATION:
;
;		 PROCEDURE BIOS_INTERRUPT (INT_VECTOR: INTEGER;
;					   VAR REGISTERS: REG_BLOCK);
;
;		 WHERE REG_BLOCK DEFINES A BLOCK OF 8 WORDS REPRESENTING
;		 THE REGISTERS AX, BX, CX, DX, SI, DI, ES, AND FLAGS,
;		 AND INT_VECTOR IS THE SOFTWARE INTERRUPT NUMBER.
;
;		 THIS ROUTINE LOADS THE VALUES FOUND IN REG_BLOCK INTO
;		 THE REAL REGISTERS, EXECUTES THE SOFTWARE INTERRUPT,
;		 LOADS THE RETURNED VALUES OF THE REAL REGISTERS BACK
;		 INTO REG_BLOCK AND RETURNS TO THE CALLER.
;
;------------------------------------------------------------------------------

STACK_DEF	STRUC	;DEFINES STACK CONFIGURATION
OLD_BP		DW	?	;SAVE CALLER'S BP REGISTER
OLD_DS		DW	?	;SAVE CALLER'S DS REGISTER
RETURN		DD	?	;RETURN ADDRESS
REG_BLOCK_OFF	DW	?	;ADDRESS OFFSET TO REG_BLOCK
REG_BLOCK_SEG	DW	?	;ADDRESS SEGMENT FOR REG_BLOCK
INT_VECTOR	DW	?	;IMMEDIATE DATA CONTAINING INTERRUPT NUMBER
STACK_DEF	ENDS

;DEFINE POINTERS TO USER'S REG_BLOCK AREA
REG_AX		EQU	WORD PTR DS:[DI+ 0]
REG_BX		EQU	WORD PTR DS:[DI+ 2]
REG_CX		EQU	WORD PTR DS:[DI+ 4]
REG_DX		EQU	WORD PTR DS:[DI+ 6]
REG_SI		EQU	WORD PTR DS:[DI+ 8]
REG_DI		EQU	WORD PTR DS:[DI+10]
REG_ES		EQU	WORD PTR DS:[DI+12]
REG_FLAGS		EQU	WORD PTR DS:[DI+14]

;SAVE CALLER'S REGISTERS
	PUSH	DS
	PUSH	BP
	MOV	BP,SP

;PATCH THE CODE TO GET THE PROPER INTERRUPT NUMBER BELOW
	MOV	AL,BYTE PTR [BP].INT_VECTOR
	MOV	CS:[INTERRUPT_NUMBER],AL

;POINT TO REG_BLOCK
	MOV	DS,[BP].REG_BLOCK_SEG
	MOV	DI,[BP].REG_BLOCK_OFF

;LOAD REG_BLOCK VALUES INTO REGISTERS
;  WE WILL NOT LOAD FLAGS FROM THE REGISTER BLOCK
	MOV	ES,REG_ES
	MOV	AX,REG_AX
	MOV	BX,REG_BX
	MOV	CX,REG_CX
	MOV	DX,REG_DX
	MOV	SI,REG_SI
	MOV	DI,REG_DI

;EXECUTE THE APPROPRIATE SOFTWARE INTERRUPT
INTERRUPT_NUMBER	EQU	($ + 1)	;ADDRESS OF BYTE TO MODIFY
	INT	0       ;0 MODIFIED BY ABOVE MOV

;PUT RETURN VALUES OF REGISTERS BACK INTO REG_BLOCK
LOAD_REG_BLOCK:
	PUSHF				;SAVE THE FLAGS
	PUSH	DI			;SAVE DI SO WE CAN USE IT AS POINTER
	MOV	DI,[BP].REG_BLOCK_OFF	;USE DI AS POINTER TO REG_BLOCK
	POP	REG_DI			;PUT SAVED (DI) INTO REG_BLOCK
	POP	REG_FLAGS		;PUT SAVED FLAGS INTO REG_BLOCK
	MOV	REG_ES,ES		;NOW MOVE IN THE REST OF THE REGS
	MOV	REG_AX,AX
	MOV	REG_BX,BX
	MOV	REG_CX,CX
	MOV	REG_DX,DX
	MOV	REG_SI,SI

EOJ:
	POP	BP
	POP	DS
	RET	6			;RETURN AND POP STACK ARGS
BIOS_INTERRUPT	ENDP
PAGE
GET_EXTERNAL_PROCEDURE_ADDR	PROC	FAR
;-------------------- GET_EXTERNAL_PROCEDURE_ADDR --------------------------------------
;
; GET_EXTERNAL_PROCEDURE_ADDR IS AN ASM86 ROUTINE WHICH MAY BE CALLED
;                   FROM PASCAL USING THE FOLLOWING DECLARATION:
;
;	PROCEDURE GET_EXTERNAL_PROCEDURE_ADDR(PROCEDURE PROC [EXTERNAL];
;				     VAR ADDRESS_OFFSET: PINTEGER;
;				     VAR ADDRESS_SEGMENT: PINTEGER);
;
;		GET_EXTERNAL_PROCEDURE_ADDR RETURNS THE POSITIVE INTEGER
;			OFFSET/SEGMENT ADDRESS OF THE PROCEDURE.
;
;------------------------------------------------------------------------------

STACK_DEF3	STRUC	;DEFINES STACK CONFIGURATION
;VALID FOR MSDOS PASCAL
OLD_BP3		DW	?	;SAVE CALLER'S BP REGISTER
RETURN3		DD	?	;RETURN ADDRESS
ADDR_SEG_OFF3	DW	?	;OFFSET OF ADDRESS_SEGMENT
ADDR_OFF_OFF3	DW	?	;OFFSET OF ADDRESS_OFFSET
PROC_FRAME	DW	?	;OFFSET OF ADDRESS OF PROC FRAME
PROC_ADDR	DW	?	;OFFSET OF ADDRESS OF PROCEDURE ADDRESS
STACK_DEF3	ENDS

;SAVE CALLER'S REGISTERS
	PUSH	BP
	MOV	BP,SP

;MOVE IN OFFSET ADDRESS
	PUSH	SI
        MOV	SI,[BP].PROC_ADDR	;SI POINTS TO OFFSET
	MOV	AX,DS:[SI]		;AX CONTAINS OFFSET ITSELF
	MOV	BX,[BP].ADDR_OFF_OFF3
	MOV	DS:[BX],AX

;MOVE IN SEGMENT ADDRESS
        MOV	AX,DS:[SI+2]		;AX CONTAINS SEGMENT ITSELF
	MOV	BX,[BP].ADDR_SEG_OFF3
	MOV	DS:[BX],AX
        POP	SI

	POP	BP
	RET	8			;RETURN AND POP STACK ARGS
GET_EXTERNAL_PROCEDURE_ADDR	ENDP
PAGE
SAVE_DS_REGISTER	PROC	FAR
;----------------- SAVE_DS_REGISTER -----------------------------------
; THIS ROUTINE SAVES PASCAL'S DEFAULT DS REGISTER, SO THAT IT CAN BE
; LOADED BY THE INTERRUPT ENTRY ROUTINES BELOW BEFORE CALLING THE
; USER'S PASCAL INTERRUPT HANDLER.
; THIS ROUTINE IS CALLED WITHOUT PARAMETERS FROM PASCAL.
;----------------------------------------------------------------------
	MOV	CS:SAVE_DS,DS
	RET
	EVEN
SAVE_DS	DW	0
SAVE_DS_REGISTER	ENDP
PAGE
DISPLAY_INT_ENTRY	PROC	FAR
;--------------- DISPLAY_INT_ENTRY ------------------------------
; THIS ROUTINE IS TO BE USED AS THE ENTRY PROCEDURE TO BE
; PASSED TO SET_DISPLAY_INT_ADDR. ALL IT DOES IS SAVE THE
; REGISTERS, LOAD DS WITH THE VALUE PREVIOUSLY STORED BY
; CALLING SAVE_DS_REGISTER ABOVE, AND CALL THE PASCAL PROCEDURE
; NAMED DISPLAY_INT_HANDLER.
;----------------------------------------------------------------
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES

	MOV	DS,CS:SAVE_DS
	CALL	DISPLAY_INT_HANDLER

	POP	ES
	POP	DS
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
DISPLAY_INT_ENTRY	ENDP
PAGE
COLL_CLIP_INT_ENTRY	PROC	FAR
;--------------- COLL_CLIP_INT_ENTRY ------------------------------
; THIS ROUTINE IS TO BE USED AS THE ENTRY PROCEDURE TO BE
; PASSED TO SET_COLLCLIP_DETECT. ALL IT DOES IS SAVE THE
; REGISTERS, LOAD DS WITH THE VALUE PREVIOUSLY STORED BY
; CALLING SAVE_DS_REGISTER ABOVE, AND CALL THE PASCAL PROCEDURE
; NAMED COLL_CLIP_INT_HANDLER.
;----------------------------------------------------------------
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES

;THIS CALL IS INCOMPLETE. WE NEED TO PUSH (IN PASCAL ORDER)
;THE PARAMETERS BLT_ID, N, AND CC_FLAGS SO THE USER CAN
;KNOW WHAT HAPPENED.
	MOV	DS,CS:SAVE_DS
	CALL	COLL_CLIP_INT_HANDLER

	POP	ES
	POP	DS
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
COLL_CLIP_INT_ENTRY	ENDP
ASM86_CODE	ENDS

END
