{ POINT.PAS   - program to display a single white point at screen coords	}
{				(100,100).  The program may be terminated by pressing any	}
{				key after the point has been displayed.						}
program point(input,output);

	type
		POINTS = array[0 .. 1] of word;
										{ data descriptor for blt_polypoint	}
		{$include:'bios.typ'}
										{ MINDSET register definitions		}

	var
		kb_scan:		byte;			{ variable used to get keyboard scan}
		kb_char:		char;			{ variable used to get keyboard char}
		data_offset:	word;			{ BX for variable in get_word_addr	}
		data_segment:	word;			{ ES for variable in get_word_addr	}
		color_index:	byte;			{ defines color palette index		}
		x_org:			integer;		{ x-coordinate of point to display	}
		y_org:			integer;		{ y-coordinate of point to display	}
		point:			POINTS;			{ variable array for display point	}
		ptr_point:		ADS OF word; 	{ get PASCAL pointer to array point	}

		{$include:'bios.ext'}
										{ MINDSET BIOS procedure definitions}

{**************************** P O I N T . P A S ****************************}
	begin								{ start of main POINT.PAS program	}

		ptr_point := ADS point;			{ get pointer to array point		}
		point[0] := 0;					{ value of 0,0 in data descriptor	}
		point[1] := 0;					{ means end of data (only one point)}

		color_index := 1;				{ palette index = 1 --> white point	}
		x_org := 100;					{ x-coord = 100 pixels from top-left}
		y_org := 100;					{ y-coord = 100 pixels from top-left}

		set_screen_mode(2);				{ MINDSET mode 320x200x16 color mode}

		get_word_addr(ptr_point^,data_offset,data_segment);
										{ get ES:BX for point array			}

		blt_polypoint(0,1,color_index,x_org,y_org,data_offset,data_segment);
										{ MINDSET BIOS call to display point}

		get_kb_char(kb_char,kb_scan);	{ wait for user to press any key	}

		set_screen_mode(3);				{ MINDSET mode 640x200 for 80 column}

		set_ibm_mode(2);				{ set IBM character mode with cursor}

	end.								{ end of POINT.PAS program			}

