	PAGE	,132
	TITLE	Disassembler Module

;**********************************************************************
;
;                       ---------------------
;----------------------- Disassembler Module --------------------------
;                       ---------------------
;
;	Copyright (C) 1983, by Zenith Data Systems Corporation
;
;**********************************************************************

ROM_DATA SEGMENT WORD AT (40H)
ROM_DATA ENDS

MONITOR_SEGMENT SEGMENT WORD PUBLIC

ASSUME CS:MONITOR_SEGMENT, DS:ROM_DATA, SS:NOTHING, ES: NOTHING

	INCLUDE	../ROM/ROM.LIT
	INCLUDE	DASM.LIT


	EXTRN	DISP_HEX_BYTE:NEAR, DISP_HEX_WORD:NEAR, DISP_HEX_POINTER:NEAR
	EXTRN	DISP_STRING:NEAR, CRLF:NEAR, SPACE:NEAR
	EXTRN	opc_tbl_:WORD, sp_tbl_:WORD, seg_:WORD, loc_:WORD
	EXTRN	name_:WORD, src_:WORD, dest_:WORD, class_:WORD
	EXTRN	opcode_:WORD, modval_:WORD, type_:WORD, reg_ofs_:WORD
	EXTRN	typed_:BYTE, ins_buff_:BYTE, operand_:BYTE, imm_buff_:BYTE
	EXTRN	reg_name_:WORD, ins_type_name_:WORD, rm_name_:WORD
	EXTRN	prefix_tbl_:BYTE



;**********************************************************************
;     M I S C E L L A N E O U S   S T R I N G   C O N S T A N T S
;**********************************************************************
	PUBLIC	hex_
hex_	DB '0123456789ABCDEF',0		;Hexadecimal constants
__70	DB 0
__76	DB ',',0
__77	DB '1',0
__80	DB '[',0
__81	DB '-',0
__82	DB '+',0
__86	DB ']',0
__87	DB 'H',0
__90	DB ':',0



;**********************************************************************
; DISASM: (SEGMENT, ADDRESS, LENGTH)
;
;	Disasm is called to disassemble a region of memory.  It will
; display both the source and object forms of the disassembled region
; of memory, as well of the address of the instructions being decoded.
;
; Input:
;    ES:DI: Pointer to memory to be disassembled
;	CX: Number of bytes to disassemble
;
; Output:
;    ES:DI: Pointing to the next byte to be disassembled
;**********************************************************************
DISASM PROC NEAR
	PUBLIC	DISASM
	PUSHREG	<AX,BX,CX,DX,SI,BP>
_L1:	CALL	DISP_HEX_POINTER	;Display the address of this line
	MOV	AH,2			;Display a couple of spaces
	CALL	SPACE
	MOV	seg_,ES
	MOV	loc_,DI
	PUSH	ES
	PUSH	DI
	PUSH	CX
	CALL	dis_ins_
	POP	CX
	POP	DI
	POP	ES
	MOV	SI,AX
	MOV	AX,loc_
	SUB	AX,DI
	MOV	DX,AX
	MOV	BX,AX
	MOV	BP,ES: [DI]		;Get the opcode of the instruction
_L4:	MOV	AL,ES: [DI]		;Read the byte from memory
	CALL	DISP_HEX_BYTE		;Display it in hex on the console
	INC	DI
	DEC	BX
	JNZ	_L4
	MOV	BX,DX
_L7:	CMP	BX,7
	JGE	_L8
	MOV	AH,2
	CALL	SPACE
	INC	BX
	JMP	_L7
_L8:	CALL	DISP_STRING		;Display the instruction source code
	CALL	CRLF
_L2:	SUB	CX,DX
	JA	_L1
	PUSH	DI			;Save location counter
	PUSH	ES			;...and the current segment
	MOV	AX,CS			;Point ES to the code segment
	MOV	ES,AX
	MOV	DI,OFFSET prefix_tbl_	;Point to the prefix table
	MOV	CX,7			;Number of prefix bytes
	MOV	AX,BP			;Get the current opcode
	REPNE	SCASB			;See if this is an instruction prefix
	POP	ES			;[Restore the disassembly segment]
	POP	DI			;[Restore the disassembly address]
	MOV	CX,1			;[Set one-instruction byte count]
	JE	_L1			;Prefix byte - continue disassembling
_L3:	POPREG	<BP,SI,DX,CX,BX,AX>
	RET
DISASM ENDP



;**********************************************************************
; DIS_INS_:
;
;	Dis_Ins_ is called to disassemble a single instruction.  It
; returns the complete source specification for the instruction,
; including the instruction name, and all operands, as a string.
;
; Output:
;	AX: Pointer to disassembled instruction text.
;**********************************************************************
dis_ins_ PROC NEAR
	PUBLIC	dis_ins_
	PUSH	BP
	MOV	BP,SP
	SUB	SP,2
	MOV	ins_buff_,0
	MOV	dest_,OFFSET __70
	MOV	src_,OFFSET __70
	MOV	SI,loc_			;Get offset of byte to be read
	INC	loc_
	MOV	ES,seg_			;Get segment to be peeked
	MOV	AL,ES: [SI]		;Read the byte from memory
	MOV	AH,0			;Extend it to a word
	MOV	opcode_,AX
	MOV	AX,opcode_
	SHL	AX,1
	SHL	AX,1
	MOV	SI,AX
	ADD	SI,OFFSET opc_tbl_
	MOV	SI,WORD PTR CS:[SI]
	MOV	name_,SI
	MOV	AX,opcode_
	SHL	AX,1
	SHL	AX,1
	ADD	AX,OFFSET opc_tbl_
	MOV	SI,AX
	MOV	SI,WORD PTR CS:[SI+2]
	MOV	class_,SI
	CALL	settype_
	CALL	setreg_
	CALL	decode_
	CALL	immediate_
	MOV	WORD PTR [BP-2],0
	MOV	SI,name_
	MOV	DI,OFFSET ins_buff_
_L9:	TEST	BYTE PTR CS: [SI], 128
	JNZ	_L10
	MOV	AL,BYTE PTR CS:[SI]
	MOV	CS:[DI],AL
_L11:	INC	SI
	INC	DI
	JMP	_L9
_L10:	MOV	AL,BYTE PTR CS:[SI]
	AND	AL,127
	MOV	CS:[DI],AL
	INC	DI
	MOV	BYTE PTR CS:[DI],TAB
	INC	DI
	MOV	BYTE PTR CS:[DI],0
	MOV	SI,dest_
	CMP	BYTE PTR CS:[SI],0
	JZ	_L12
	CMP	typed_,0
	JNZ	_L13
	TEST	class_,-32768
	JZ	_L13
	CALL	get_type_
_L13:	PUSH	dest_
	MOV	AX,OFFSET ins_buff_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
_L12:	MOV	SI,src_
	CMP	BYTE PTR CS: [SI],0
	JZ	_L14
	MOV	AX,OFFSET __76
	PUSH	AX
	MOV	AX,OFFSET ins_buff_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
	CMP	typed_,0
	JNZ	_L15
	TEST	class_,-32768
	JNZ	_L15
	CALL	get_type_
_L15:	PUSH	src_
	MOV	AX,OFFSET ins_buff_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
_L14:	MOV	AX,OFFSET ins_buff_
	MOV	SP,BP
	POP	BP
	RET
dis_ins_ ENDP



;**********************************************************************
; SETTYPE_:
;
;	SetType_ is called to determine if an instruction is BYTE/WORD/
; DWORD, etc.  It also handles the special case '1' operand used
; in shift instructions, and sets up the global variable 'reg_ofs_'
; (used in register name determination).
;**********************************************************************
settype_ PROC NEAR
	PUBLIC	settype_
	PUSH	BP
	MOV	BP,SP
	MOV	typed_,0
	MOV	type_,1
	MOV	reg_ofs_,0
	MOV	AX,class_
	AND	AX,448
	CMP	AX,448
	JE	_L16
	CMP	AX,384
	JE	_L17
	CMP	AX,128
	JE	_L18
	CMP	AX,192
	JE	_L19
	CMP	AX,256
	JE	_L20
	CMP	AX,320
	JE	_L21
	JMP	SHORT _L22
_L16:	MOV	type_,2
_L17:	MOV	src_,OFFSET __77
	JMP	SHORT _L22
_L18:	MOV	type_,2
	JMP	SHORT _L22
_L19:	MOV	type_,3
	JMP	SHORT _L22
_L20:	MOV	type_,4
	JMP	SHORT _L22
_L21:	MOV	type_,5
	JMP	SHORT _L22
_L22:	CMP	type_,2
	JZ	_L25
	CMP	type_,3
	JZ	_L25
	CMP	type_,5
	JNZ	_L24
_L25:	MOV	reg_ofs_,8
_L24:	POP	BP
	RET
settype_ ENDP



;**********************************************************************
; SETREG_:
;
;	SetReg_ is called to determine and parse any registers 
; implicitly encoded in an instruction's definition.  It will
; return the register text in 'src', or 'dest', as appropriate.
;**********************************************************************
setreg_ PROC NEAR
	PUBLIC	setreg_
	PUSH	BP
	MOV	BP,SP
	TEST	class_,8192
	JZ	_L26
	MOV	typed_,1
	TEST	class_,-32768
	JZ	_L27
	MOV	AX,reg_ofs_
	SHL	AX,1
	MOV	SI,AX
	ADD	SI,OFFSET reg_name_
	MOV	SI,WORD PTR CS:[SI]
	MOV	dest_,SI
	JMP	SHORT _L28
_L27:	MOV	AX,reg_ofs_
	SHL	AX,1
	MOV	SI,AX
	ADD	SI,OFFSET reg_name_
	MOV	SI,WORD PTR CS:[SI]
	MOV	src_,SI
_L28:
_L26:	MOV	AX,class_
	AND	AX,31
	JZ	_L29
	MOV	typed_,1
	MOV	SI,dest_
	CMP	BYTE PTR CS: [SI],0
	JNZ	_L31
	CMP	opcode_,210
	JZ	_L32
	CMP	opcode_,211
	JNZ	_L30
_L32:
_L31:	MOV	AX,class_
	AND	AX,31
	SUB	AX,1
	SHL	AX,1
	MOV	SI,AX
	ADD	SI,OFFSET reg_name_
	MOV	SI,WORD PTR CS:[SI]
	MOV	src_,SI
	JMP	SHORT _L33
_L30:	MOV	AX,class_
	AND	AX,31
	SUB	AX,1
	SHL	AX,1
	MOV	SI,AX
	ADD	SI,OFFSET reg_name_
	MOV	SI,WORD PTR CS:[SI]
	MOV	dest_,SI
_L33:
_L29:	POP	BP
	RET
setreg_ ENDP



;**********************************************************************
; DECODE_:
;
;	Decode_ is called to decipher the instruction decoding.  It
; handles Mod/R/M, Mod/REG/R/M, and SPECIAL_ decoding, as necessary.
; It interprets the ModRM byte and the instruction class to determine
; what operations are to be performed.
;**********************************************************************
decode_	PROC NEAR
	PUBLIC	decode_
	PUSH	BP
	MOV	BP,SP
	SUB	SP,2
	TEST	class_,6144
	JZ	_L34
	MOV	SI,loc_			;Get offset of byte to be read
	INC	loc_
	MOV	ES,seg_			;Get segment to be peeked
	MOV	AL,ES: [SI]		;Read the byte from memory
	MOV	AH,0			;Extend it to a word
	MOV	modval_,AX
	MOV	CL,3
	SHR	AX,CL
	AND	AX,7
	MOV	BX,AX			;Save the REG field in BX
	ADD	AX,reg_ofs_
	MOV	WORD PTR [BP-2],AX
	MOV	AX,opcode_		;Get the current opcode byte
	AND	AL,0FEH			;Mask out L.S. bit
	CMP	AL,0FEH			;Is this a 'Group 2' instruction?
	JNE	_L34			;No, continue
	CMP	BX,3			;Is this instruction a FAR JMP?
	JE	_L34A			;Yes - set type to DWORD
	CMP	BX,5			;Is this a FAR CALL?
	JNE	_L34			;No, continue
_L34A:	MOV	type_,3			;Yes - set type to DWORD
_L34:	MOV	AX,class_
	AND	AX,6144
	MOV	CL,11
	SHR	AX,CL
	MOV	BX,AX
	CMP	BX,0
	JL	_L35
	CMP	BX,3
	JG	_L35
	SHL	BX,1
	JMP	WORD PTR CS:_L40[BX]
_L40:	DW	_L35
	DW	_L36
	DW	_L37
	DW	_L38
_L35:	JMP	_L39
_L36:	MOV	SI,dest_
	CMP	BYTE PTR CS: [SI],0
	JZ	_L41
	CALL	ModRM_
	MOV	src_,AX
	JMP	SHORT _L42
_L41:	CALL	ModRM_
	MOV	dest_,AX
_L42:	JMP	_L39
_L37:	MOV	typed_,1
	TEST	class_,32
	JZ	_L43
	MOV	AX,WORD PTR [BP-2]
	AND	AX,3
	ADD	AX,16
	MOV	WORD PTR [BP-2],AX
_L43:	TEST	class_,-32768
	JZ	_L44
	CALL	ModRM_
	MOV	src_,AX
	MOV	AX,WORD PTR [BP-2]
	SHL	AX,1
	MOV	SI,AX
	ADD	SI,OFFSET reg_name_
	MOV	SI,WORD PTR CS:[SI]
	MOV	dest_,SI
	JMP	SHORT _L45
_L44:	MOV	AX,WORD PTR [BP-2]
	SHL	AX,1
	MOV	SI,AX
	ADD	SI,OFFSET reg_name_
	MOV	SI,WORD PTR CS:[SI]
	MOV	src_,SI
	CALL	ModRM_
	MOV	dest_,AX
_L45:	JMP	SHORT _L39
_L38:	MOV	AX,opcode_
	AND	AX,248
	CMP	AX,216
	JNZ	_L46
	CALL	ModRM_
	MOV	src_,AX
	JMP	SHORT _L47
_L46:	MOV	AX,WORD PTR [BP-2]
	AND	AX,7
	MOV	CL,3
	MOV	DX,name_
	SHL	DX,CL
	ADD	AX,DX
	SHL	AX,1
	MOV	SI,AX
	ADD	SI,OFFSET sp_tbl_
	MOV	SI,WORD PTR CS:[SI]
	MOV	name_,SI
	MOV	SI,dest_
	CMP	BYTE PTR CS: [SI],0
	JZ	_L48
	CALL	ModRM_
	MOV	src_,AX
	JMP	SHORT _L49
_L48:	CALL	ModRM_
	MOV	dest_,AX
_L49:	MOV	AX,opcode_
	AND	AX,254
	CMP	AX,246
	JNZ	_L50
	MOV	AX,WORD PTR [BP-2]
	AND	AX,7
	JNZ	_L50
	OR	class_,1024
_L50:
_L47:
_L39:	MOV	SP,BP
	POP	BP
	RET
decode_ ENDP



;**********************************************************************
; MODRM_:
;
;	ModRM_ is called to handle Mod/R/M decoding for all instructions
; using this form.  It parses all base/index addressing modes, as well
; as register sources/destinations not implicitly encoded in the
; instruction being disassembled.
;
; Output:
;	AX: Pointer to string representing Mod/R/M operand.
;**********************************************************************
ModRM_	PROC NEAR
	PUBLIC	ModRM_
	PUSH	BP
	MOV	BP,SP
	SUB	SP,8
	MOV	WORD PTR [BP-6],1
	MOV	WORD PTR [BP-4],1
	MOV	WORD PTR [BP-8],0
	MOV	operand_,0
	MOV	AX,modval_
	AND	AX,192
	MOV	CL,6
	SHR	AX,CL
	MOV	BX,AX
	CMP	BX,0
	JL	_L55
	CMP	BX,3
	JG	_L55
	SHL	BX,1
	JMP	WORD PTR CS:_L56[BX]
_L56:	DW	_L51
	DW	_L52
	DW	_L53
	DW	_L54
_L51:	MOV	AX,modval_
	AND	AX,7
	CMP	AX,6
	JNZ	_L57
	CALL	getw_
	MOV	WORD PTR [BP-2],AX
	MOV	WORD PTR [BP-6],0
	JMP	SHORT _L55
_L57:	MOV	WORD PTR [BP-4],0
_L58:	JMP	SHORT _L55
_L52:	MOV	WORD PTR [BP-8],1
	CALL	getb_
	MOV	WORD PTR [BP-2],AX
	JMP	SHORT _L55
_L53:	CALL	getw_
	MOV	WORD PTR [BP-2],AX
	JMP	SHORT _L55
_L54:	MOV	typed_,1
	MOV	AX,modval_
	AND	AX,7
	MOV	CX,reg_ofs_
	ADD	CX,AX
	MOV	AL,2
	MOV	AH,0
	IMUL	CX
	MOV	SI,AX
	MOV	AX,reg_name_[SI]
	MOV	SP,BP
	POP	BP
	RET
_L55:	CMP	WORD PTR [BP-6],0
	JZ	_L59
	MOV	AX,modval_
	AND	AX,7
	SHL	AX,1
	MOV	SI,AX
	ADD	SI,OFFSET rm_name_
	MOV	AX,WORD PTR CS:[SI]
	JMP	SHORT _L60
_L59:	MOV	AX,OFFSET __80
_L60:	PUSH	AX
	MOV	AX,OFFSET operand_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
	CMP	WORD PTR [BP-4],0
	JZ	_L61
	CMP	WORD PTR [BP-8],0
	JZ	_L62
	CMP	WORD PTR [BP-2],0
	JGE	_L63
	MOV	AX,OFFSET __81
	PUSH	AX
	MOV	AX,OFFSET operand_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
	MOV	AX,256
	SUB	AX,WORD PTR [BP-2]
	MOV	WORD PTR [BP-2],AX
	JMP	SHORT _L64
_L63:	MOV	AX,OFFSET __82
	PUSH	AX
	MOV	AX,OFFSET operand_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
_L64:	PUSH	WORD PTR [BP-2]
	MOV	AX,OFFSET operand_
	PUSH	AX
	CALL	hexcat_
	ADD	SP,4
	JMP	SHORT _L65
_L62:	CMP	WORD PTR [BP-6],0
	JZ	_L66
	MOV	AX,OFFSET __82
	PUSH	AX
	MOV	AX,OFFSET operand_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
_L66:	PUSH	WORD PTR [BP-2]
	MOV	AX,OFFSET operand_
	PUSH	AX
	CALL	wordcat_
	ADD	SP,4
_L65:
_L61:	MOV	AX,OFFSET __86
	PUSH	AX
	MOV	AX,OFFSET operand_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
	MOV	AX,OFFSET operand_
	MOV	SP,BP
	POP	BP
	RET
ModRM_ ENDP



;**********************************************************************
; IMMEDIATE_:
;
;	Immediate_ is called to retrieve immediate values from
; the instruction field.  It handles not only immediate data operands,
; but also direct memory references, and the ESCape instruction.
;**********************************************************************
immediate_ PROC NEAR
	PUBLIC	immediate_
	PUSH	BP
	MOV	BP,SP
	SUB	SP,4
	MOV	AX,2
	TEST	class_,512
	JNZ	_L68
	MOV	AX,type_
_L68:	MOV	WORD PTR [BP-2],AX
	MOV	imm_buff_,0
	MOV	AX,opcode_
	AND	AX,248
	CMP	AX,216
	JNZ	_L69
	MOV	AX,opcode_
	AND	AX,7
	MOV	CL,3
	SHL	AX,CL
	MOV	CX,modval_
	AND	CX,56
	MOV	DI,CX
	SHR	DI,CL
	ADD	AX,DI
	MOV	WORD PTR [BP-4],AX
	PUSH	WORD PTR [BP-4]
	MOV	AX,OFFSET imm_buff_
	PUSH	AX
	CALL	hexcat_
	ADD	SP,4
	MOV	AX,OFFSET __87
	PUSH	AX
	MOV	AX,OFFSET imm_buff_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
	MOV	dest_,OFFSET imm_buff_
_L69:	TEST	class_,1024+512
	JNZ	_L69A
	JMP	_L70
_L69A:	MOV	BX,WORD PTR [BP-2]
	CMP	BX,1
	JL	_L70A
	CMP	BX,5
	JG	_L70A
	SUB	BX,1
	SHL	BX,1
	JMP	WORD PTR CS:_L76[BX]
_L70A:	JMP	_L75
_L76:	DW	_L71
	DW	_L72
	DW	_L73
	DW	_L75
	DW	_L74
_L71:	CALL	getb_
	PUSH	AX
	MOV	AX,OFFSET imm_buff_
	PUSH	AX
	CALL	hexcat_
	ADD	SP,4
	JMP	_L75
_L72:	TEST	class_,512
	JZ	_L77
	MOV	AX,OFFSET __80
	PUSH	AX
	MOV	AX,OFFSET imm_buff_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
_L77:	CALL	getw_
	PUSH	AX
	MOV	AX,OFFSET imm_buff_
	PUSH	AX
	CALL	wordcat_
	ADD	SP,4
	TEST	class_,512
	JZ	_L78
	MOV	AX,OFFSET __86
	PUSH	AX
	MOV	AX,OFFSET imm_buff_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
_L78:	JMP	SHORT _L75
_L73:	CALL	getw_
	MOV	WORD PTR [BP-4],AX
	CALL	getw_
	PUSH	AX
	MOV	AX,OFFSET imm_buff_
	PUSH	AX
	CALL	wordcat_
	ADD	SP,4
	MOV	AX,OFFSET __90
	PUSH	AX
	MOV	AX,OFFSET imm_buff_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
	PUSH	WORD PTR [BP-4]
	MOV	AX,OFFSET imm_buff_
	PUSH	AX
	CALL	wordcat_
	ADD	SP,4
	JMP	SHORT _L75
_L74:	TEST	class_,16384
	JZ	_L79
	CALL	getb_
	PUSH	AX
	MOV	AX,OFFSET imm_buff_
	PUSH	AX
	CALL	wordcat_
	ADD	SP,4
	JMP	SHORT _L80
_L79:	CALL	getb_
	MOV	WORD PTR [BP-4],AX
	CMP	AX,0
	MOV	AX,OFFSET __81
	JL	_L82
	MOV	AX,OFFSET __82
_L82:	PUSH	AX
	MOV	AX,OFFSET imm_buff_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
	PUSH	WORD PTR [BP-4]
	MOV	AX,OFFSET imm_buff_
	PUSH	AX
	CALL	hexcat_
	ADD	SP,4
_L80:
_L75:	MOV	SI,dest_
	CMP	BYTE PTR CS: [SI],0
	JZ	_L83
	MOV	src_,OFFSET imm_buff_
	JMP	SHORT _L84
_L83:	MOV	dest_,OFFSET imm_buff_
_L84:
_L70:	MOV	SP,BP
	POP	BP
	RET
immediate_ ENDP



;**********************************************************************
; GET_TYPE_:
;
;	Get_Type is called to append a type override string (when
; one is necessary), to the current ins_buff string.
;**********************************************************************
get_type_ PROC NEAR
	PUBLIC	get_type_
	MOV	SI,type_
	SHL	SI,1
	PUSH	CS:ins_type_name_[SI]
	MOV	AX,OFFSET ins_buff_
	PUSH	AX
	CALL	strcat_
	ADD	SP,4
	RET
get_type_ ENDP



;**********************************************************************
; GETB_:
;
;	Getb reads a byte at the current contents of the location
; counter, sign-extends it, and advances the location counter.  If
; the byte is PC-relative, it is added to the location counter
; after sign-extension has been performed.
;
; Output:
;	AX: Word value for byte
;**********************************************************************
getb_ PROC NEAR
	PUBLIC	getb_
	MOV	SI,loc_			;Get offset of byte to be read
	MOV	ES,seg_			;Get segment to be peeked
	MOV	AL,ES: [SI]		;Read the byte from memory
	INC	loc_			;Advance location counter
	TEST	AL,80H
	JZ	_L85
	OR	AX,-256
_L85:	TEST	class_,16384
	JZ	_L87
	ADD	AX,loc_
_L87:	RET
getb_ ENDP



;**********************************************************************
; GETW_:
;
;	Getw_ is called to retrieve a word at the current location
; counter.  If the word being read is PC-relative, the contents of
; the instruction pointer will be added automatically.
;
; Output:
;	AX: Contains word read
;**********************************************************************
getw_	PROC NEAR
	PUBLIC	getw_
	MOV	SI,loc_			;Get offset of word to be read
	MOV	ES,seg_			;Get segment to be peeked
	MOV	AX,ES: [SI]		;Read the wordfrom memory
	ADD	loc_,2
	TEST	class_,16384
	JZ	_L88
	ADD	AX,loc_
_L88:	RET
getw_ ENDP



;**********************************************************************
; WORDCAT_: (STR, WORDVALUE)
;
;	Wordcat_ turns a word value into hexadecimal, and concatenates
; it to the string 'str' in the code segment.
;
; Input:
;	Stack Parm 1: String to be added to
;	Stack Parm 2: Word value to be converted into hex
;**********************************************************************
wordcat_ PROC NEAR
	PUBLIC	wordcat_
	PUSH	BP
	MOV	BP,SP
	MOV	AL,BYTE PTR [BP+7]
	PUSH	AX
	PUSH	WORD PTR [BP+4]
	CALL	hexcat_
	MOV	SP,BP
	MOV	AL,BYTE PTR [BP+6]
	PUSH	AX
	PUSH	WORD PTR [BP+4]
	CALL	hexcat_
	MOV	SP,BP
	POP	BP
	RET
wordcat_ ENDP



;**********************************************************************
; HEXCAT_: (STR, BYTEVALUE)
;
;	Hexcat_ turns a byte value into hexadecimal, and concatenates
; it to the string 'str' in the code segment.
;
; Input:
;	Stack Parm 1: String to be added to
;	Stack Parm 2: Byte value to be converted into hex
;**********************************************************************
hexcat_	PROC NEAR
	PUBLIC	hexcat_
	PUSH	BP
	MOV	BP,SP
	PUSH	WORD PTR [BP+4]
	CALL	strlen_
	ADD	SP,2
	MOV	DI,AX
	ADD	DI,WORD PTR [BP+4]
	MOV	CL,4
	MOV	AL,BYTE PTR [BP+6]
	SHR	AL,CL
	AND	AX,15
	MOV	SI,AX
	MOV	AL,hex_[SI]
	MOV	BYTE PTR CS:[DI],AL
	INC	DI
	MOV	AL,BYTE PTR [BP+6]
	AND	AX,15
	MOV	SI,AX
	MOV	AL,hex_[SI]
	MOV	BYTE PTR CS:[DI],AL
	INC	DI
	MOV	BYTE PTR CS:[DI],0
	POP	BP
	RET
hexcat_ ENDP



;**********************************************************************
; STRCAT_: (DEST, SOURCE)
;
;	Strcat_ copies the source string to the end of the destination
; string.  The 'end' of the string is defined as the first null byte
; in the string.  During the copy, strcat leaves a trailing null at
; the end of the destination string.
;
; Input:
;	Stack Parm 1: Pointer to destination string
;	Stack Parm 2: Pointer to source string
;**********************************************************************
strcat_	PROC NEAR
	PUBLIC	strcat_
	PUSH	BP
	MOV	BP,SP
	PUSH	WORD PTR [BP+6]
	PUSH	WORD PTR [BP+4]
	CALL	strlen_
	ADD	SP,2
	MOV	SI,AX
	ADD	SI,WORD PTR [BP+4]
	PUSH	SI
	CALL	strcpy_
	MOV	SP,BP
	POP	BP
	RET
strcat_ ENDP



;**********************************************************************
; STRLEN_: (STRING)
;
;	Strlen_ determines the length of a specified null-terminated
; string.
;
; Input:
;	Stack Parm 1: Pointer to string to be checked.
;**********************************************************************
strlen_ PROC NEAR
	PUBLIC	strlen_
	PUSH	BP
	MOV	BP,SP
	MOV	CX,0
	MOV	SI,WORD PTR [BP+4]
_L101:	LODS	CS: BYTE PTR [SI]
	TEST	AL,AL
	JZ	_L102
	INC	CX
	JMP	_L101
_L102:	MOV	AX,CX
	POP	BP
	RET
strlen_ ENDP



;**********************************************************************
; STRCPY_: (DEST, SOURCE)
;
;	Strcpy copies a string to a specified destination.  After the
; copy, the destination string is left null-terminated.
;
; Input:
;	Stack Parm 1: Offset of destination string
;	Stack Parm 2: Offset of source string
;**********************************************************************
strcpy_ PROC NEAR
	PUBLIC	strcpy_
	PUSH	BP
	MOV	BP,SP
	MOV	SI,WORD PTR [BP+6]
	MOV	DI,WORD PTR [BP+4]
_L104:	LODS	CS: BYTE PTR [SI]
	MOV	BYTE PTR CS:[DI],AL
	INC	DI
	TEST	AL,AL
	JNZ	_L104
_L105:	POP	BP
	RET
strcpy_ ENDP



MONITOR_SEGMENT ENDS

	END
