	PAGE	,132
	TITLE	Z-150 Alphanumeric Print Screen

;**********************************************************************
;
;                             --------------
;----------------------------- Print Screen ---------------------------
;                             --------------
;
;		Copyright (C) 1983, by Zenith Data Systems
;
;**********************************************************************

PRINT_SCREEN_SEG SEGMENT WORD AT (50H)
	EXTRN	PRINT_SCREEN_STATUS:BYTE
PRINT_SCREEN_SEG ENDS

MONITOR_SEGMENT SEGMENT WORD PUBLIC

	ASSUME	CS:MONITOR_SEGMENT, DS:ROM_DATA, ES:PRINT_SCREEN_SEG

	INCLUDE ../ROM/ROM.LIT
	INCLUDE ../ROM/INTR.LIT
	INCLUDE ../VIDEO/VIDEO.LIT
	INCLUDE ../VIDEO/VIDEO.EXT

	EXTRN	GET_CURSOR_POSITION:NEAR, SET_CURSOR_POSITION:NEAR
	EXTRN	READ_CHAR:NEAR, DATA_SEGMENT:WORD


;**********************************************************************
; PRINT_SCREEN_INTERRUPT:			     Interrupt #05H (5)
;
;	Print_Screen_Interrupt is executed when a user requests a
; screen dump from the keyboard.  It is a general purpose routine
; which performs an alphanumeric screen dump - graphics on the
; screen which do not correspond to alphanumeric characters are
; ignored, due to the wide variety of formats used by graphics-
; capable printers.
;**********************************************************************
PRINT_SCREEN_INTERRUPT PROC FAR
	PUBLIC	PRINT_SCREEN_INTERRUPT
	PUSHREG	<AX,BX,CX,DX,DS,ES>
	MOV	DS,DATA_SEGMENT		;Point to the current data segment
	MOV	AX,PRINT_SCREEN_SEG	;Now, point ES to the print-screen
	MOV	ES,AX			;...status byte's segment
	MOV	AL,1			;Set AL to print-screen-in-progress
	XCHG	AL,ES:PRINT_SCREEN_STATUS ;Test-and-set the print screen flag
	CMP	AL,1			;Is a print-screen in progress?
	JE	PSI5			;Yes - ignore this request
	MOV	BH,DISPLAYED_PAGE	;Pick up the currently displayed page
	CALL	GET_CURSOR_POSITION	;Read the current screen position
	PUSH	DX			;Save it for later
	MOV	DX,0			;Point to the home screen position
PSI1:	CALL	SET_CURSOR_POSITION	;Point to the next character to read
	CALL	READ_CHAR		;Read a character from the screen
	TEST	AL,AL			;Was a valid character read?
	JNE	PSI2			;Yes - print the character read
	MOV	AL,' '			;No, print a space instead
PSI2:	CALL	PRINT_CHAR		;Print the character to the printer
	JC	PSI3			;ERROR - abort screen dump
	INC	DL			;Advance to the next char position
	CMP	DL,BYTE PTR NUMBER_OF_COLUMNS	;Done with this line yet?
	JB	PSI1			;No, continue with this line
	MOV	AL,CR			;Yes - print a carriage return
	CALL	PRINT_CHAR
	JC	PSI3			;ERROR - abort screen dump
	MOV	AL,LF			;Next, print a line feed
	CALL	PRINT_CHAR
	JC	PSI3			;ERROR - printer not responding
	MOV	DL,0			;Set column number to 0
	INC	DH			;Increment number of rows
	CMP	DH,LAST_ROW		;Finished with the whole screen yet?
	JBE	PSI1			;No, go do another line
	MOV	PRINT_SCREEN_STATUS,0	;Clear print-screen-in-progress flag
	JMP	SHORT PSI4		;Return
PSI3:	MOV	PRINT_SCREEN_STATUS,0FFH;Flag that a printer error occurred
PSI4:	POP	DX			;Restore initial cursor position
	CALL	SET_CURSOR_POSITION	;...to that before print-screen
PSI5:	POPREG	<ES,DS,DX,CX,BX,AX>
	IRET
PRINT_SCREEN_INTERRUPT ENDP



;**********************************************************************
; PRINT_CHAR: (CHAR)
;
;	Print_Char prints out a single character to the device currently
; assigned as printer 0.
;
; Input:
;	AL: Character to be printed.
;
; Output:
;	CY: Set if an error occurred while the character was being
;	    printed - otherwise, the carry flag will be reset.
;**********************************************************************
PRINT_CHAR PROC NEAR
	PUBLIC	PRINT_CHAR
	PUSHREG	<AX,DX>
	MOV	AH,0			;Set function code to print-char
	MOV	DX,0			;Print on printer number 0
	INT	PRINTER_IO_INTR		;Print the requested character
	TEST	AH,00100101B		;Did a printer error occur?
	JZ	PC1			;No, return OK status
	STC				;ERROR - printer error (set err flag)
PC1:	POPREG	<DX,AX>
	RET
PRINT_CHAR ENDP



MONITOR_SEGMENT ENDS

	END
