/************************************************************************
Copyright 1990 by Network Computing Devices, Inc.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of NCD not be used in advertising or
publicity pertaining to distribution of the software without specific
prior written permission.  NCD makes no representation about the
suitability of this software for any purpose. It is provided "as is"
without any express or implied warranty.

NCD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.  IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

************************************************************************/

#ident "@(#)ncdsie.h	15.2	91/01/07"

#ifndef _NCDSIE_H_
#define _NCDSIE_H_

#define X_SieQueryVersion		0
#define X_SieCreateImage		1
#define X_SieSendImage			2
#define X_SieCopyImage			3
#define X_SieFetchImage			4

#define SieCompressGroup31d		0
#define SieCompressGroup42d		1
#define SieCompressGroup32d		2

#define SieRotation0			0
#define SieRotation90			1
#define SieRotation180			2
#define SieRotation270			3

#define SieNumberEvents			0
#define SieNumberErrors			0

#ifndef _NCDSIE_SERVER_

extern Bool		XSieQueryExtension ();
extern Status		XSieQueryVersion ();
extern Pixmap		XSieCreateImage();
extern void		XSieSendImage();
extern void		XSieCopyImage();
extern unsigned char*	XSieFetchImage();

#else /* _NCDSIE_SERVER_ */

#define SieMaxRequest			X_SieFetchImage
#define SieMaxCompression		SieCompressGroup42d
#define SieMaxRotation			SieRotation270

#define VALIDATE_SIE_COMPRESSION(compression)\
    if (compression > SieMaxCompression)\
    {\
	client->errorValue = compression;\
	return (BadValue);\
    }

#define VALIDATE_SIE_ROTATION(rotation)\
    if (rotation > SieMaxRotation)\
    {\
	client->errorValue = rotation;\
	return (BadValue);\
    }

#endif /* _NCDSIE_SERVER_ */

#endif /* _NCDSIE_H_ */
