#
#ident "@(#)config.example	14.3	90/12/06"
#
# configuration file for hassel-X1
# modify by emb 050795 
#

# Include file (commented out)
#include-file = 			# {<file>}

# Define name service first so we can use host names in this file
name-server-type = domain		# {default, domain, ien116}
name-servers = 129.177.16.3             # eik.ii.uib.no
default-domain = ii.uib.no


# Boot Monitor parameters
boot-at-reset = yes			# {default, [yes | no]}
					#  default is "yes"
# Set boot related parameters
server-code = tcp-ip			# {default, ncdnet, prom, tcp-ip}
determine-ip = from-network		# {default, from-network, from-nvram}
boot-server = 129.177.18.24             # hassel

# Make sure we'll do remote configuration in the future
remote-config-enabled = yes		# {default, no, yes}
remote-config-access = nfs		# {default, ncdnet, nfs, tftp}
remote-config-server = 129.177.16.7	# {default, apal}

# Set IP basics
subnet-mask = 0xffffff00		# {<hex-constant>}
broadcast-address = 129.177.18.255	# 18-nett
ip-routing-method = default-gateway	# {default, default-gateway, proxy-arp}
default-gateway = 129.177.18.5          # cluster-gw
hostname = hasseL-X1
tftp-max-retries = default		# {default, <number>}
tftp-timeout = default			# {default, <seconds>}
tftp-filename-format = default		# {[unix | vms]}
					#  default is "unix".

# Set to use XDM
virtual-terminal-at-reset = xdm		# {default, cterm, dw-login,
					# lat-manager, local-serial, serial,
					# telnet, xdm, none}
xdm-access = direct			# {broadcast, direct, indirect}
xdm-death-timeout = default		# {<integer>}
xdm-detect-death = default		# {default, off, on}
xdm-fail-action = default		# {default, persist, stop}
xdm-hibernation-time = default	 	# {<integer>}
xdm-server = 129.177.18.24		# {default, <pinje>}
xdm-wait-for-last-client = default	# {default, on, off}

# DECwindows compatability features
dw-compatibility = default		# {default, no, yes}
dw-login-name = default			# {default, <account name>}
dw-login-password = default		# {default, <password>}

# NCDnet parameters
# NFS parameters
nfs-gid = default			# {<integer>}
nfs-uid = default			# {<integer>}
nfs-file-systems =
   apal:/net.sol/X11R5/lib/X11/ncd      /usr/lib/X11/ncd (
					mount-retries = 10
					nfs-errors = soft
					read-cache = on
					read-size = 8192
					retransmissions = 3
					retry-mounting-in = background
					timeout = 7
					write-size = 8192
					)
   eik:/net.txt/publisher/Xfonts/sun4-mit /net/src/publisher/Xfonts/sun4-mit (
                                        mount-retries = 10
                                        nfs-errors = soft
                                        read-cache = on
                                        read-size = 8192
                                        retransmissions = 3
                                        retry-mounting-in = background
                                        timeout = 7
                                        write-size = 8192
                                        )
   apal:/net/sol/X11R5/openwin/lib/fonts  /local/openwin/lib/fonts (
                                        mount-retries = 10
                                        nfs-errors = soft
                                        read-cache = on
                                        read-size = 8192
                                        retransmissions = 3
                                        retry-mounting-in = background
                                        timeout = 7
                                        write-size = 8192
                                        )
  apal:/nume/lotus/123.v11/fonts/X11_NeWS /local/nume/lotus/123.v11/fonts/X11_NeWS
                                        mount-retries = 10
                                        nfs-errors = soft
                                        read-cache = on
                                        read-size = 8192
                                        retransmissions = 3
                                        retry-mounting-in = background
                                        timeout = 7
                                        write-size = 8192
                                        )

# Font related parameters
font-access = nfs			# {default, ncdnet, nfs, tftp}
font-servers = 129.177.16.7		# {<apal> - 0.0.0.0}
font-path = default			# {<font path>, default}
font-diagnostics = default		# {default, no, yes}
font-cache-size = default		# {default, <bytes>}
rgb-file = default			# {<file name>, default}

# Access control
xhosts = hassel
tcp-ip-access-control = on		# {off, on}
ncdnet-access-control = default		# {default, off, on}
rshd-hosts = hauk tuja hassel		# {default, <list of hosts>}
					#  default is null string.
rshd-access-control = default		# {[on | off]}
					#  default is "off".
seriald-hosts = default			# {default, <list of hosts>}
					#  default is null string.
seriald-access-control = default	# {default, [on | off]}
					#  default is "off".

# Diagnostic control
diagnostics-log-file = default		# {default, <file name>}
diagnostics-logging = default	  	# {default, no, yes}
disable-error-popup = default	  	# {default, no, yes}
low-memory-level = default		# {default, <integer>}

# Miscellaneous parameters
overscan = white
screen-saver = default			# {default, off, on}
backing-store = default
arc-cache-size = default		# {default, <size>}
					#  default is 512K.
retain-x-settings = yes
permit-old-x-bugs = default		# {default, no, yes}

keyboard-type = N-101			# {<keyboard type>}
led-1 = network-activity		# {default, caps-lock, num-lock,
					#  warning, network-activity, x-led-1}
led-2 = default				# {default, caps-lock, num-lock,
					#  warning, network-activity, x-led-2}
led-3 = default				# {default, caps-lock, num-lock,
					#  warning, network-activity, x-led-3}

# Serial port parameters
use-serial-port-1 = default		# {debug, default, network-interface,
					# {printer-daemon, terminal}
baud-1 = default			# {50, 75, 110, 134, 150, 200, 300,
					# 600, 1050, 1200, 1800, 2000, 2400,
					# 4800, 7200, 9600, 19200, 38400,
					# default}
data-bits-1 = default			# {default, 7, 8}
stop-bits-1 = default		  	# {default, 1, 2}
parity-1 = default			# {default, even, mark, none, odd,
					# space}
handshake-1 = default		  	# {default, dtr-dsr, none, rts-cts,
					# xon/xoff}
hangup-method = default			# {none, use-break, use-dtr}



# SNMP parameters
#snmp-managers = pepper			# {<ipaddr | hostname>}
#snmp-monitors = default			# {default, <ipaddr | hostname>}
#snmp-trap-monitors = default		# {default,
					# <hostname | IP address> <string>}
#snmp-read-only-community = public	# {<string>}
#snmp-read-write-community = manager	# {<string>}
#snmp-reset-enabled = default		# {[yes | no]}
                                        #  default is "no".

# Setup menu access control
setup-enabled-menus = default		# {default, all-menus, only-user-menus,
					# only-diagnostic-menus}
setup-last-menu-key = default		# {default, setup, shift-setup,
					# ctrl-setup, alt-setup,
					# shift-alt-setup, nothing}
setup-main-menu-key = default		# {default, setup, shift-setup,
					# ctrl-setup, alt-setup,
					# shift-alt-setup, nothing}

# local client parameters
disable-local-clients = default		# {default, [none | terminals]}
					#  default is "none".

answer-back-message = default
					# {default, <character string>}
					#  default is null string.
function-key-mapping = default		# {default, [vms | ultrix]}
					#  default value is "ultrix".

# start local window manager
#window-manager-at-reset = yes		# star local window manager
#initial-x-resources = ()		# {<character string>}
enable-local-launcher = no		# start local launcher

# Write these values into NVRAM
write-to-nvram  = yes			# {default, no, yes}
