#include <stdio.h>
#include "dm.h"
#include "hosts.h"

static struct Host session_hosts[MAXSESSIONHOSTS];
static int session_host = 0;

/*
void Debug () {};
void LogError () {};
main () {
	HostList hosts;
	int i;
	void ReadSessionHosts ();

	ReadSessionHosts ("config/test-hosts");

	hosts = GetSessionHosts ();
	for (i=0; hosts[i].address[0]; ++i)
		printf ("\"%s\", \"%s\", \"%s\"\n",
			hosts[i].name,
			hosts[i].descrip,
			hosts[i].address);
}
*/

void
ReadSessionHosts (filename)
char *filename;
{
   static char default_name[] = "Whoops - no host list!";
   static char default_address[] = "localhost";
   FILE *hostfile;
   char buffer[300];
   int i;
   char *sep1, *sep2;
   int h;

   if (!(hostfile = fopen (filename, "r"))) {
	LogError ("Can't open %s\n", filename);
	Debug ("Can't open %s\n", filename);
	/*
	SessionExit (UNMANAGE_DISPLAY);
	*/
	strcpy (session_hosts[0].name, default_name);
	strcpy (session_hosts[0].address, default_address);
	session_hosts[1].address[0] = (char) 0;
	return;
   }

   Debug ("Host file:\n");
   for (h = 0; h < MAXSESSIONHOSTS - 1; ++h) {
	int nch;
	/* Break at EOF. */
	if (!fgets (buffer, sizeof (buffer) - 1, hostfile)) break;
	buffer[sizeof (buffer) - 1] = (char) 0;

	/* Get rid of newlines. */
	for (i = 0; i < sizeof (buffer); ++i)
		if (buffer[i] == '\n') {
			buffer[i] = (char) 0;
			buffer[++i] = (char) 0;
			break;
		}

	/* Leading white space. */
	for (i = 0; (buffer[i] == ' ') || (buffer[i] == '\t'); ++i);

	/* !Comment. */
	if (buffer[0] == '!') continue;
	for (i = 0; (buffer[i] == ' ') || (buffer[i] == '\t'); ++i);

	/* Find end of name.  If there's a ':', that's after the name.
	   If not, the name's going to be the same as the address. */
	if (sep1 = index (&buffer[i], ':')) {
		*sep1 = (char) 0;
		++sep1;
	}
	else sep1 = &buffer[i];

	for (; (*sep1 == ' ') || (*sep1 == '\t'); ++sep1);
	for (sep2 = sep1;
		(*sep2 != (char) 0) && (*sep2 != ' ') && (*sep2 != '\t');
		++sep2);
	if (*sep2) {
		*sep2 = (char) 0;
		++sep2;
	}
	if (*sep1) {
		strcpy (session_hosts[h].name, &buffer[i],
			sizeof (session_hosts[h].name));
		strncpy (session_hosts[h].address, sep1,
			sizeof (session_hosts[h].address));
	}
	else {
		LogError ("improperly formatted host entry: \"%s\"\n", buffer);
		--h;
		continue;
	}

	for (; (*sep2 == ' ') || (*sep2 == '\t'); ++sep2);
	if (*sep2 != (char) 0 && *sep2 != '!') {
		strncpy (session_hosts[h].descrip, sep2,
			sizeof (session_hosts[h].descrip));
	}
	else session_hosts[h].descrip[0] = (char) 0;
   }
   session_hosts[h].address[0] = (char) 0;
   fclose (hostfile);
}

char *
GetSessionHost () {
	return session_hosts[session_host].address;
}

HostList
GetSessionHosts () {
	return &session_hosts[0];
}

void
SetSessionHost (n) int n; {
	session_host = n;
}
