# Copyright 1993 Network Computing Devices, Inc. All rights reserved.
#
# $NCDId: @(#)ncd3.1cfg.sed,v 1.1 1993/07/09 22:06:49 djc Exp $
#
# sed script to convert NCDware 3.0 configuration files 
# to NCDware 3.1 configuration files.
#
# Modifications are:
#
# Add the name of the serial port to the entries in 
# the serial-interfaces table. This is a read-only parameter.
#
# Place the serial daemon parameters into a table format
# since there can now be multiple serial daemons if an NCD unit 
# is equipped with an option card that supports additional serial ports.
#

# Match a row set of the serial-interfaces-table
# and add the name of the first serial port, i.e. "1"
s/{ terminal/{ 1 terminal/
s/{ printer/{ 1 printer/
s/{ serial-daemon/{ 1 serial-daemon/
s/{ console/{ 1 console/
s/{ input-device/{ 1 input-device/

# Match the serial daemon parameters 
# and convert to the appropriate tables
s/serial-lat-service-password/serial-daemons-lat-service-passwords[1]password/
s/serial-action-on-disconnect/serial-daemons-table[1]action-on-disconnect/
s/serial-advertise-lat-service/serial-daemons-table[1]advertise-lat-service/
s/serial-lat-service-name/serial-daemons-table[1]lat-service-name/
s/serial-lat-service-rating/serial-daemons-table[1]lat-service-rating/
s/serial-ncdnet-object-name/serial-daemons-table[1]ncdnet-object-name/
s/serial-tcp-port/serial-daemons-table[1]tcp-port/
s/serial-use-serial-protocol/serial-daemons-table[1]use-serial-protocol/

