# Copyright 1993 Network Computing Devices, Inc. All rights reserved.
#
# $NCDId: @(#)ncd3.2cfg.sed,v 14.2 1993/12/16 17:38:06 dct Exp $
#
# sed script to convert NCDware 3.1 configuration files 
# to NCDware 3.2 configuration files.
#
# Modifications are:
#
# Add the current port mode field to each row of the
# serial-interfaces-table
#
# Add the hangup field to each row of the serial-interfaces-table
#
# Remove the action on disconnect field from each row of the
# serial-daemons-table
#
# Remove the IP and NCDnet interface parameters which no longer exist

# Match a row of the serial-interfaces-table and add
# the current-mode field (set to whatever the mode is)
s/{ [123] terminal/& terminal/
s/{ [123] printer/& printer/
s/{ [123] serial-daemon/& serial-daemon/
s/{ [123] console/& console/
s/{ [123] input-device/& input-device/
s/{ [123] slip/& slip/
s/{ [123] ppp/& ppp/
s/{ [123] xremote/& xremote/

# Match a row of the serial-interfaces-table and add
# the hangup field (initialized to none)
/{ [123] terminal/s/}/none }/
/{ [123] printer/s/}/none }/
/{ [123] serial-daemon/s/}/none }/
/{ [123] console/s/}/none }/
/{ [123] input-device/s/}/none }/
/{ [123] slip/s/}/none }/
/{ [123] ppp/s/}/none }/
/{ [123] xremote/s/}/none }/

# Match a row of the serial-daemons-table and remove the
# action-on-disconnect field.
# Also place a serial-interfaces-table[]hangup setting into
# the hold space for later retrieval
/{ [123].*SERIALD.*none/s/ none//
/{ [123].*SERIALD.*drop-dtr/{ s/ drop-dtr//; p; s/.*{ \([123]\).*/serial-interfaces-table[\1]hangup = drop-dtr/; H; d; }
/{ [123].*SERIALD.*send-break/{ s/ send-break//; p; s/.*{ \([123]\).*/serial-interfaces-table[\1]hangup = send-break/; H; d; }

# Change action-on-disconnect in serial-daemons-table to hangup
# in serial-interfaces-table
/action-on-disconnect/{ s/serial-daemons/serial-interfaces/; s/action-on-disconnect/hangup/; }

# Remove the IP and NCDnet interface parameters
/ip-interface/d
/ncdnet-interface/d

$G
