/* COMMOVL.C		Command (and a few auxiliary) routines for overlays

	Copyright (c) 1982 Perfect Software

This file contains those overlay functions for which source code is
provided to the user.  These are mostly command routines, but a few
miscellaneous auxiliary routines are in here too.  */


#include "pf.gbl"

/*---------------- From COMMANDS.C ----------------*/


/* taken from SCommand() */
DoFoot()				/* process a footnote (not an endnote) */
{
	int CloseFoots();

	if (sty.footstyle=='i') {
		EPush();
		env.closeproc= &CloseFoots;
		env.name="footnote";
		PutOneCh('[');
		return;
		}
	if (sty.footpush) {
		PutInit();
		PutOneCh(SUPERON);
		PutNum(NULL,++footnum,NULL);
		PutOneCh(SUPEROFF);
		PutFini();
		}
	else PutNum("[",++footnum,"]");
	IPushBuf();
	PFootnote();

	NormalEnv("footnote",FALSE,TRUE,sty.prefjust);
	env.closeproc= &CloseFoots;
	env.preveleft=env.eleft=env.cureleft=pag.pleft;
	env.eright=pag.pright;

	if (nofootnotes) {
		nofootnotes=FALSE;
		PPutVert(LINEHEIGHT);
		LPutToken(SCToS("----------"));
		BreakLine();
		}
	PPutVert(LINEHEIGHT);
	PutNum(NULL,footnum,".  ");
	if (!GetOpen()) {
		PNoFootnote();
		IPopBuf();
		}
	}


/* taken from SCommand() */
DoNote()				/* process an endnote */
{
	NOTELIST *nptr;

	if (sty.footpush) {
		PutInit();
		PutOneCh(SUPERON);
		PutNum(NULL,++footnum,NULL);
		PutOneCh(SUPEROFF);
		PutFini();
		}
	else PutNum("[",++footnum,"]");
	MemSpace(EndSpace);
	nptr=MemGet(sizeof(*nptr));
	if (!notehead) notetail=notehead=nptr;
	else notetail->notenextptr=nptr;
	notetail=nptr;
	nptr->notenum=footnum;
	nptr->noteptr=GetOneArg(RETURN);
	nptr->notenextptr=NULL;
	MemSpace(PageSpace);
	}


/* taken from SCommand() */
DoIndex()				/* make an index entry */
{
	STRING *token;
	INDLIST *iptr, *iptr2, *iptrold;

	MemSpace(EndSpace);
	iptr2=MemGet(sizeof(*iptr));
	iptr2->indpage=(pagenum==0)? 1 : pagenum;
	token=GetOneArg(RETURN);

	if (!indhead) {
		indhead=iptr2;
		iptr2->indnextptr=NULL;
		}
	else {
		iptr=iptrold=indhead;
		while (iptr && SCompGT(token,iptr->indname)) {
			iptrold=iptr;
			iptr=iptr->indnextptr;
			}
		if (iptr && SComp(token,iptr->indname)) {
			SFree(token);
			token=NULL;
			do {
				iptrold=iptr;
				iptr=iptr->indnextptr;
				} while (iptr && !iptr->indname);
			}
		if (iptr==indhead) {
			iptr2->indnextptr=indhead;
			indhead=iptr2;
			}
		else {
			iptr2->indnextptr=iptrold->indnextptr;
			iptrold->indnextptr=iptr2;
			}
		}
	iptr2->indname=token;
	MemSpace(PageSpace);
	}


/* taken from CheckVar() */
DoString()				/* set a string variable */
{
	STRING *token, *token2, *sptr;
	char *SSToC();
	VALLIST *vptr;

	token=NULL;
	if (!ArgOn("@String") || !(token=GetArg(RETURN)) ||
		 !(token2=GetArg(RETURN))) {
		if (token) SFree(token);
		TError("@String requires two arguments.",NULL,NULL);
		return(TRUE);
		}
	if (argquoted) sptr=token2;
	else {
		if (!(vptr=FindVar(token2))) {
			TError("@String: Variable not found '",SSToC(token2),"'.");
			sptr=token2;
			}
		else {
			SFree(token2);
			if (vptr->valtype=='s') sptr=SCToS(SSToC(vptr->value));
			else sptr=SNToS(vptr->value);
			}
		}
	SetVar(SSToC(token),'s',sptr);
	SFree(token);
	ArgOff("@String");
	}


DoStrInput()
{
	STRING *token, *token2, *sptr;
	char *SSToC();
	VALLIST *vptr;

	TNL();
	ArgOn ("@StringInput");
	if (!(token = GetArg (RETURN))) {
		TError ("@StringInput requires at least one argument.",
			   NULL, NULL);
		return;
		}
	if (token2 = GetArg (RETURN)) {
		TPuts (SSToC (token));
		SFree (token);
		token = token2;
		}
	ArgOff ("@StringInput");
	IPushBuf();
	IInclude ("CON:");
	while (IGetType() != EOFT) {
		IAppTok();
		INextTok();
		}
	token2 = IGetBuf();
	IPopBuf();
	SetVar (SSToC (token), 's', token2);
	SFree (token);
	}

DoSet()					/* set a numeric variable */
{
	STRING *token, *token2, *sptr;
	char which, *SSToC();
	int oldval, val;

	token=NULL;
	if (!ArgOn("@Set") || !(token=GetArg(RETURN)) ||
		 !(token2=GetArg(RETURN))) {
		if (token) SFree(token);
		TError("@Set requires two arguments.",NULL,NULL);
		return(TRUE);
		}
	which= *SSToC(token2);
	if (which=='+' || which=='-') {
		sptr=SCToS(SSToC(token2)+1);
		SFree(token2);
		token2=sptr;
		oldval=GetNumVal(token);
		}
	
	if (IsNum(token2)) val=SSToN(token2);
	else val=GetNumVal(token2);
	SFree(token2);
	
	if (which=='+') oldval+=val;
	else if (which=='-') oldval-=val;
	else oldval=val;
	SetVar(SSToC(token),'n',oldval);
	SFree(token);
	ArgOff("@Set");
	}



/*---------------- From COMMTOO.C ----------------*/


/* taken from CheckEnv() */
DoLevel()				/* open a Level environment */
{
	int *indx;
	int ParaLevel(), CloseLevel();

	for (indx= &level[0]; *indx; ++indx);
	if (sty.levindent && indx> &level[0]) {
		if (!sty.levhang) env.cureleft+=HALFINCH;
		env.preveleft=env.eleft=env.cureleft;
		}
	env.justifytype=sty.prefjust;
	*indx=1;
	*(indx+1)=NULL;
	env.paraproc=ParaLevel;
	env.closeproc=CloseLevel;
	StartEnv();
	}


DoCase()				/* process the @Case command */
{
	STRING *token;
	VALLIST *vptr;
	char dlm;
	int CloseCase();

	if (!ArgOn("@Case")) return;
	vptr=FindVar(token=GetArg(RETURN));
	if (!vptr || vptr->valtype!='s') {
		TError("Undefined or non-string switch variable for @Case '",
			SSToC(token),"'.");
		SFree(token);
		ArgOff("@Case");
		return;
		}
	SFree(token);
	while (token=GetArg(RETURN)) {
		if ((SCompToC(vptr->value,"") && SCompToC(token,"null")) ||
			 SComp(token,vptr->value) || SCompToC(token,"else")) {
			SFree(token);
			if (dlm=GetArg(SAMPLE)) {
				PushArg();
				EPush();
				env.name="case";
				env.howclose=MatchOpen(dlm);
				env.closeproc=CloseCase;
				return;
				}
			else {
				if (!(token=GetArg(RETURN))) {
					TError("Unexpected end of @Case argument",NULL,NULL);
					return;
					}
				while (GetArg(ARGFLUSH));
				IUse(SSToC(token),"case");
				PF();
				SFree(token);
				return;
				}
			}
		else if (!GetArg(ARGFLUSH)) return;
		SFree(token);
		}
	}


DoStyle()				/* process the @Style command */
{
	MICA GetDimArg();
	STRING *token, *token2;

	ArgOn("@Style");
	while (token=GetArg(RETURN)) {
		switch (Index(token,"above below bottommargin chapters \
footerspacing footpush headerspacing indent indentation justification \
leftmargin levelhang levelindent linewidth notes paperlength paperwidth \
rightmargin scriptpush spacing spread topmargin ")) {

		case 0:					/* above */
			sty.above=GetDimArg();
			break;
		case 1:					/* below */
			sty.below=GetDimArg();
			break;
		case 2:					/* bottom margin */
			pag.pbottom=dev.dheight-(sty.sbottom=GetDimArg());
			break;
		case 3:					/* chapter */
			sty.ischapter=GetFlagArg();
			break;
		case 4:					/* footer spacing */
			sty.footerspace=GetDimArg();
			break;
		case 5:					/* foot push */
			sty.footpush=GetFlagArg();
			break;
		case 6:					/* header spacing */
			sty.headerspace=GetDimArg();
			break;
		case 7:	case 8:			/* indent */
			sty.indent=GetDimArg() / dev.stdhoriz;
			break;
		case 9:					/* justification */
			env.justifytype=sty.prefjust=(GetFlagArg() ? 'b' : 'l');
			break;
		case 10:					/* left margin */
			env.preveleft=env.eleft=env.cureleft=pag.pleft=GetDimArg();
			break;
		case 11:					/* level hang */
			sty.levhang=GetFlagArg();
			break;
		case 12:					/* level indent */
			sty.levindent=GetFlagArg();
			break;
		case 13:					/* line width */
			env.eright=pag.pright=pag.pleft+GetDimArg();
			break;
		case 14:					/* notes */
			if (!(token2=GetArg(RETURN))) {
				TError ("Missing Note value in @Style", NULL, NULL);
				break;
				}
			switch (Index(token2,"endnote bottom inline ")) {

			case 0:
				sty.footstyle='e';
				break;
			case 1:
				sty.footstyle='b';
				break;
			case 2:
				sty.footstyle='i';
				break;
			default:
				TError("Unknown value for Note clause of @Style '",
					SSToC(token2),"'.");
				break;
				}
			SFree(token2);
			break;
		case 15:					/* paper length */
			pag.pbottom=(dev.dheight=GetDimArg())-sty.sbottom;
			break;
		case 16:					/* paper width */
			env.eright=pag.pright=(dev.dwidth=GetDimArg())-sty.sright;
			break;
		case 17:					/* right margin */
			env.eright=pag.pright=dev.dwidth-(sty.sright=GetDimArg());
			break;
		case 18:					/* script push */
			sty.scriptpush=GetFlagArg();
			break;
		case 19:					/* spacing */
			env.linespacing=sty.spacing=GetDimArg();
			break;
		case 20:					/* spread */
			sty.spread=GetDimArg();
			break;
		case 21:					/* top margin */
			pag.ptop=GetDimArg();
			break;
		default:
			TError("Unknown argument to @Style '",SSToC(token),"'.");
			ArgOff("@Style");
			break;
			}
		SFree(token);
		}
	}


DoHeading(which)		/* process a page heading command */
	char which;
{
	STRING *token, *lhead, *chead, *rhead, *nhead, *ptrs;
	char where, *ptr;

	where='b';
	lhead=SCToS("");
	rhead=SCToS("");
	chead=SCToS("");
	nhead=SCToS("");
	ArgOn(which==1 ? "@PageHeading" : "@PageFooting");

	while (token=GetArg(RETURN)) {
		switch (Index(token,"left line right center even odd ")) {

		case 0:
			SFree(lhead);
			lhead=GetArg(RETURN);
			break;
		case 1:
			SFree(nhead);
			nhead=GetArg(RETURN);
			break;
		case 2:
			SFree(rhead);
			rhead=GetArg(RETURN);
			break;
		case 3:
			SFree(chead);
			chead=GetArg(RETURN);
			break;
		case 4:
			where='e';
			break;
		case 5:
			where='o';
			break;
		default:
			TError("Unknown argument to @PageHeading or @PageFooting '",
				SSToC(token),"'.");
			SFree(token);
			ArgOff(which==1 ? "@PageHeading" : "@PageFooting");
			break;
			}
		SFree(token);
		}

	ptr=MemGet(SLength(lhead)+SLength(chead)+SLength(rhead)+SLength(nhead)+
		(3+1));
	strcpy(ptr,SSToC(lhead));
	strcat(ptr,"\203");
	strcat(ptr,SSToC(chead));
	strcat(ptr,"\222");
	strcat(ptr,SSToC(rhead));
	strcat(ptr,"\214");
	strcat(ptr,SSToC(nhead));

	SFree(lhead);
	SFree(chead);
	SFree(rhead);
	SFree(nhead);

	if (which==1) {
		if (where=='b' || where=='e') {
			SFree(headeven);
			headeven=SCToS(ptr);
			}
		if (where=='b' || where=='o') {
			SFree(headodd);
			headodd=SCToS(ptr);
			}
		}
	else {
		if (where=='b' || where=='e') {
			SFree(footeven);
			footeven=SCToS(ptr);
			}
		if (where=='b' || where=='o') {
			SFree(footodd);
			footodd=SCToS(ptr);
			}
		}
	MemFree(ptr);
	return;
	}


/*---------------- From AUXIL.C ----------------*/


EnvInit()					/* initialize environment */
{
	int ParaStan(), CloseStan();

	env.name="text";
	env.howclose=NUL;
	env.preveleft=pag.pleft;
	env.eleft=env.cureleft=pag.pleft;
	env.eright=pag.pright;
	env.linespacing=sty.spacing;
	env.isfill=TRUE;
	env.iswrap=TRUE;
	env.justifytype=sty.prefjust;
	env.iswhiteintact=FALSE;
	env.paraproc=ParaStan;
	env.closeproc=CloseStan;
	env.enumcount=1;
	env.itemlevel=0;
	env.closechar=NUL;
	if (!txtontop) {	/* verbatim is not usually top level environment */
		env.name="verbatim";
		DoVerbatim();
		}
	}


MICA
GetDimArg()			/* process a dimensioned, numeric argument */
{
	unsigned n, GetNumArg();
	MICA m;
	STRING *token;

	n=GetNumArg();
	if (!(token=GetArg(RETURN))) {
		TError("Missing dimension.",NULL,NULL);
		return(0);
		}
	switch (Index(token,"in inch inches cm mm point points pica picas em ems char chars character characters line lines micas ")) {

	case 0:	case 1:	case 2:
		m=INCH;
		break;
	case 3:
		m=CENTIMETER;
		break;
	case 4:
		m=CENTIMETER/10;
		break;
	case 5:	case 6:
		m=POINT;
		break;
	case 7:	case 8:
		m=PICA;
		break;
	case 9:	case 10:
		m=Width('m');
		break;
	case 11:	case 12:	case 13:	case 14:
		m=CHARWIDTH;
		break;
	case 15:	case 16:
		m=LINEHEIGHT;
		break;
	case 17:
		m=1;
		break;
	default:
		TError("Unknown unit of measure '",SSToC(token),"'.");
		m=0;
		}
	m*=n;
	SFree(token);
	return(m);
	}


FLAG
GetFlagArg()				/* process an "Yes" or "No" argument */
{
	STRING *token;
	FLAG arg;

	token=GetArg(RETURN);
	arg = FALSE;
	if (token && SCompToC(token,"yes")) arg=TRUE;
	else if (token && SCompToC(token,"no")) arg=FALSE;
	else if (!token) TError ("Missing 'Yes' or 'No' argument.", NULL, NULL);
	else TError("'Yes' or 'No' argument required. '",SSToC(token),
			"' was given.");
	if (token) SFree(token);
	return(arg);
	}


unsigned
GetNumArg()				/* process a number in the argument */
{
	unsigned n;
	STRING *token;

	if (token=GetArg(RETURN)) {
		n=SSToN(token);
		SFree(token);
		return(n);
		}
	else {
		TError("Missing numeric argument.",NULL,NULL);
		return(0);
		}
	}


/*---------------- From AUXILTOO.C ----------------*/


PrintNotes()				/* print any trailing footnotes */
{
	int ParaStan();

	if (!notehead) return;

	NormalEnv("notes",FALSE,TRUE,sty.prefjust);
	env.preveleft=env.eleft=env.cureleft=pag.pleft;
	env.eright=pag.pright;

	BreakLine();
	PPutVert(LINEHEIGHT);
	LPutToken(SCToS("----------"));
	BreakLine();

	while (notehead) {
		PPutVert(LINEHEIGHT);
		PutNum(NULL,notehead->notenum,".  ");
		IUse(SSToC(notehead->noteptr),"endnotes");
		PF();
		BreakLine();
		notehead=notehead->notenextptr;
		}
	BreakLine();
	EPop();
	}


PrintIndex()				/* print the index */
{
	int ParaStan();

	if (!indhead) return;

	TPuts("\n\nIndex\n\n     ");

	PNewPage();
	PPutVert(4*LINEHEIGHT);

	NormalEnv("index",TRUE,FALSE,'c');
	env.preveleft=env.cureleft=env.eleft=pag.pleft;
	env.eright=pag.pright;
	PutStr("Index");
	BreakLine();

	PPutVert(2*LINEHEIGHT);
	env.justifytype='l';

	while (indhead) {
		if (indhead->indname) {
			BreakLine();
			PutInit();
			PutStr(SSToC(indhead->indname));
			PutOneCh(SP);
			}
		else {
			PutInit();
			PutOneCh(',');
			}
		PutNum(" ",indhead->indpage,NULL);
		PutFini();
		indhead=indhead->indnextptr;
		}
	BreakLine();
	EPop();
	}


TableOfContents()			/* generate the table of contents */
{
	char type, oldtype;
	MICA LGetCol();

	if (!titlehead) return;

	TPuts("\n\nTable of Contents\n\n     ");

	PNewPage();
	PPutVert(4*LINEHEIGHT);

	NormalEnv("contents",FALSE,FALSE,'c');
	env.preveleft=env.eleft=pag.pleft;
	env.cureleft=env.preveleft+3*INCH/2;
	env.eright=pag.pright-INCH;
	PutStr("Table of Contents");
	BreakLine();

	PPutVert(2*LINEHEIGHT);
	env.justifytype='l';

	oldtype='c';
	while (titlehead) {
		type=titlehead->enttype;
		if (oldtype!=type || type=='c' || type=='a') {
			BreakLine();
			PPutVert(LINEHEIGHT);
			}
		oldtype=type;
		env.eleft=env.preveleft;
		switch(type) {

		case 'c':
			PutStr("Chapter ");
			chapter->value=titlehead->entnum;
			break;
		case 's':
			LPutWhite(3*CHARWIDTH);
			section->value=titlehead->entnum;
			break;
		case 'b':
			LPutWhite(6*CHARWIDTH);
			subsection->value=titlehead->entnum;
			break;
		case 'p':
			LPutWhite(9*CHARWIDTH);
			paragraph->value=titlehead->entnum;
			break;
		case 'a':
			PutStr("Appendix ");
			appendix->value=titlehead->entnum;
			break;
		case 'n':
			LPutWhite(3*CHARWIDTH);
			asection->value=titlehead->entnum;
			}
		SecStart(type);
		Template(type);
		BreakTok();
		PutStr(SSToC(titlehead->entname));
		BreakTok();
		if (LGetCol()>env.eright-HALFINCH) BreakLine();
		LPutWhite(env.eright+HALFINCH-LGetCol());
		env.iswrap=FALSE;
		PutNum(NULL,titlehead->entpage,NULL);
		BreakLine();
		env.iswrap=TRUE;
		titlehead=titlehead->entnextptr;
		}
	EPop();
	}


HeaderInit()				/* initialize pageheadings  */
{
	headeven=SCToS("\203\222\214");
	headodd=SCToS("\203\222\214");
#ifndef CPM
	if ( typewriter ) {
		footeven=SCToS("\203\222\214");
		footodd=SCToS("\203\222\214");
	}
	else {
		footeven=SCToS("\203- @Value(Page) -\222\214");
		footodd=SCToS("\203- @Value(Page) -\222\214");
	}
#else
	footeven=SCToS("\203- @Value(Page) -\222\214");
	footodd=SCToS("\203- @Value(Page) -\222\214");
#endif
	}


/* End of COMMOVL.C */
                                                         