/* DISPLAY.C - Display utility for use with the config program

	(C) 1982, 1983 Perfect Software, Inc.

	01/26/82	Version 1.00 by Barry A. Dobyns

	This is a general utility package used to display messages
and ask questions. */

#include "pfconfig.h"

FLAG DGetNum(), IsHexDig();
char TGetChar();

FLAG
DMenu(arg)			/* Display a menu and aceept a selection */
#ifdef LATTICE
	char *arg;
#else
	int arg;
#endif
{
#ifdef LATTICE
	char **argp;
#else
	int *argp;
#endif
	int select, range;
	int (*mfuncts[20])();

/*	for (range=15000; range>0; --range);	*/
	range=0;
	TNL();
	TNL();
	TNL();
	TNL();
	argp = &arg;
	while (*((int *) argp)==TITLE) {
		++argp;
		TPuts(*argp++);
		TNL();
		}
	while (*argp && range<20) {
		printf(" %2d - %s",range+1,*argp++);
#ifdef LATTICE
		fflush(stdout);
#endif
		TNL();
		mfuncts[range++] = *argp++;
		}
	TPuts("Enter the number of your selection, followed by a CR --> ");
	if (!DGetNum(1,range,&select) && mfuncts[select-1]) {
		(*mfuncts[select-1])();
		return(FALSE);
		}
	return(TRUE);
	}

FLAG
DEnter(arg)			/* Accept several fields with checks */
	int arg;
{
	int *argp, tval;
	char *bptr;

	for (argp = &arg; *argp; ++argp) {
		switch (*argp) {

		case FLAGTYPE:
			if (DGetFlag(*++argp)) return(TRUE);
			break;
		case HEXBYTE:
			if (DGetHex(*++argp)) return(TRUE);
			break;
		case MICATYPE:
			if (DGetNum(0,MAXMICA,*++argp)) return(TRUE);
			break;
		case RANGE:
			++argp;
			if (DGetNum(*argp,*(argp+1),*(argp+2))) return(TRUE);
			argp += 2;
			break;
		case BRANGE:
			++argp;
			if (DGetNum(*argp,*(argp+1),&tval)) return(TRUE);
			argp += 2;
			bptr = *argp;
			*bptr=tval;
			break;
		case STRING:
			++argp;
			if (DGetStr(*(argp+1),*argp)) return(TRUE);
			++argp;
			break;
		default:
			TNL();
			TPuts(*argp);
			break;
			}
		}
	return(FALSE);
	}

int
DSummary(arg)			/* Display a summary screen */
	int arg;
{
	int *argp, *iptr, field;
	char *cptr;
	FLAG neednum;

	neednum=TRUE;
	field=0;
	for (argp = &arg; *argp; ++argp) {
		switch (*argp) {

		case SETNUM:
			field = *++argp;
			break;
		case TITLE:
			TNL();
			TPuts(*++argp);
			break;
		case FLAGTYPE:
			neednum=TRUE;
			cptr = *++argp;
			if (*cptr) TPuts("Yes");
			else TPuts("No");
			break;
		case HEXBYTE:
			neednum=TRUE;
			cptr = *++argp;
			printf("%xH",*cptr);
#ifdef LATTICE
			fflush(stdout);
#endif
			break;
		case MICATYPE:
			neednum=TRUE;
			iptr = *++argp;
			printf("%u micas",*iptr);
#ifdef LATTICE
			fflush(stdout);
#endif
			break;
		case RANGE:
			neednum=TRUE;
			iptr = *++argp;
			printf("%u",*iptr);
#ifdef LATTICE
			fflush(stdout);
#endif
			break;
		case BRANGE:
			neednum=TRUE;
			cptr = *++argp;
			printf("%d",*cptr);
#ifdef LATTICE
			fflush(stdout);
#endif
			break;
		case STRING:
			neednum=TRUE;
			TPuts(*++argp);
			break;
		case NONLNEXT:
			if (neednum) {
				printf("     %2d - ",++field);
#ifdef LATTICE
				fflush(stdout);
#endif
				neednum=FALSE;
				}
			else TPuts("      ");
			TPuts(*++argp);
			break;
		default:
			TNL();
			if (neednum) {
				printf(" %2d - ",++field);
#ifdef LATTICE
				fflush(stdout);
#endif
				neednum=FALSE;
				}
			else TPuts("      ");
			TPuts(*argp);
			}
		}
	return(field);
	}

FLAG
DYesNo()				/* Get a Yes or No answer */
{
	char tchar;

	while (DGetFlag(&tchar));
	return(tchar);
	}

DGetFlag(tptr)			/* Accept a Yes or No value */
	char *tptr;
{
	char c;

	repeat {
		c=TGetChar();
		c = toupper(c);
		switch (c) {

		case CANCEL:
			return(TRUE);
		case 'Y':
			TPuts("Yes");
			TNL();
			*tptr=TRUE;
			return(FALSE);
		case 'N':
			TPuts("No");
			TNL();
			*tptr=FALSE;
			return(FALSE);
		default:
			TNL();
			TPuts("Enter 'Y' or 'N' --> ");
			break;
			}
		}
	}

FLAG
DGetHex(valptr)		/* Accept a hex byte */
	char *valptr;
{
	char ans[3];
	unsigned CToH();

	repeat {
		if (DGetStr(ans,3)) return(TRUE);
		if (IsHex(ans)) {
			*valptr=CToH(ans);
			return(FALSE);
			}
		TPuts("Enter a hex byte --> ");
		}
	}

FLAG
DGetNum(low,high,valptr)	/* Accept a number */
	unsigned low, high, *valptr;
{
	char ans[10];
	unsigned CToN();

	repeat {
		if (DGetStr(ans,10)) return(TRUE);
		if (IsDec(ans)) *valptr=CToN(ans);
		if (IsDec(ans) && (*valptr>=low && *valptr<=high)) return(FALSE);
		printf("Enter a number between %u and %u --> ", low, high);
#ifdef LATTICE
		fflush(stdout);
#endif
		}
	}

FLAG
DGetStr(string,len)		/* Accept a string */
	char *string;
	int len;
{
	int orgcol;
	char stemp[80], inpt, *sptr, *RubOut();

	orgcol=TGetCol();
	if (len>80) len=80;
	sptr=stemp;
	while ((inpt=TGetChar())!=CR) {
		if (sptr-stemp>=len-1 && inpt!=DEL && inpt!=BS && inpt!=CANCEL) {
			sptr=RubOut(orgcol,stemp,sptr);
			TBell();
			}
		switch (inpt) {

		case CANCEL:
			TNL();
			return(TRUE);
		case BS:
		case DEL:
			if (sptr>stemp) sptr=RubOut(orgcol,stemp,sptr);
			break;
		case QUOTE:
			inpt=TGetChar();
		default:
			TPrntChar(inpt);
			*sptr++=inpt;
			break;
			}
		}
	*sptr='\0';
	strcpy(string,stemp);
	TNL();
	return(FALSE);
	}

char *
RubOut(orgcol,ostr,str)		/* delete a character for getarg */
	int orgcol;
	char *str, *ostr;
{
	int twid;

	for (twid=orgcol; ostr<str-1; twid+=TWidth(twid,*ostr++));
	for (twid=TGetCol()-twid; twid>0; --twid) {
		TPutChar(BS);
		TPutChar(' ');
		TPutChar(BS);
		--pcol;
		}
	*--str='\0';
	return(str);
	}

unsigned
CToN(a)				/* Decimal string to number */
	char *a;
{
	unsigned val;

	for (val=0; *a; ++a) {
		if (*a<'0' || *a>'9') {
			Error("Invalid decimal number.");
			return(val);
			}
		val=val*10 + *a-'0';
		}
	return(val);
	}

unsigned
CToH(cptr)				/* Hexadecimal string to number */
	char *cptr;
{
	int cnt;

	cnt=0;
	while (*cptr) {
		if (!IsHexDig(*cptr)) {
			Error("Invalid hexadecimal number.");
			return(cnt);
			}
		cnt=(cnt<<4)+(isdigit(*cptr)? *cptr-'0' : tolower(*cptr)-'a'+10);
		++cptr;
		}
	return(cnt);
	}

FLAG
IsHex(string)			/* Check if a string is hexadecimal numeric */
	char *string;
{
	char *cptr;

	cptr=string;
	while (*cptr && IsHexDig(*cptr)) ++cptr;
	return(*cptr ? FALSE:TRUE);
	}

FLAG
IsHexDig(tchar)		/* Is a characrter a valid hex digit */
	char tchar;
{
	return(isdigit(tchar) || (tolower(tchar)>='a' && tolower(tchar)<='f'));
	}

FLAG
IsDec(string)			/* Check if a string is decimal numeric */
	char *string;
{
	while (*string && isdigit(*string)) string++;
	return(*string ? FALSE:TRUE);
	}

putchar(tchar)			/* Display a character */
	char tchar;
{
	TPrntChar(tchar);
	}

TInit()				/* Initialize the terminal */
{
#ifdef UNIX
	struct {
		char isp, osp;
		char era, kill;
		int mode;
		} sarg;
 
	gtty(0,&sarg);			/* Put the terminal in raw mode */
	sarg.mode &= ~8;
	sarg.mode |= 32;
	stty(0,&sarg);
#endif
	}

TFini()				/* Finialize the terminal */
{
#ifdef UNIX
	struct {
		char isp, osp;
		char era, kill;
		int mode;
		} sarg;

	gtty(0,&sarg);			/* Out of raw mode */
	sarg.mode |= 8;
	sarg.mode &= ~32;
	stty(0,&sarg);
#endif
	}

TPrntChar(tchar)		/* Print a character */
	char tchar;
{
	int tcol;

	if (tchar>=' ' && tchar<='~') {
		++pcol;
		TPutChar(tchar);
		}
	else switch(tchar) {
	case TAB:
		tcol=TABINCR-(pcol%TABINCR);
		while (tcol) {
			TPrntChar(' ');
			--tcol;
			}
		break;
	default:
		if (tchar&128) {
			TPrntChar('~');
			TPrntChar(tchar&127);
			}
		else {
			TPrntChar('^');
			TPrntChar(tchar^'@');
			}
		break;
		}
	}

TNL()				/* Go to a new line */
{
	TPutChar(CR);
	TPutChar(LF);
	pcol=0;
	}

TWidth(colcnt,tchar)	/* determine width of tchar */
	int colcnt;
	char tchar;
{
	int wid, delta;

	if (tchar>=' ' && tchar<='~') return(1);
	switch(tchar) {

	case TAB:
		wid=TABINCR-(colcnt%TABINCR);
		break;
	default:
		if (tchar&128) wid = TWidth(colcnt+1,tchar&127)+1;
		else wid=2;
		break;
		}
	return(wid);
	}

TBell()				/* Ring the terminal bell */
{
	TPutChar(BELL);
	}

TPuts(str)			/* Write out a string */
	char *str;
{
	while (*str) TPrntChar(*str++);
	}

TPutChar(tchar)		/* Print character on terminal directly */
	char tchar;
{
#ifdef CPM
	bios(4,tchar);
#endif
#ifdef	LATTICE
	putch(tchar);
#endif
#ifdef UNIX
	write(1,&tchar,1);
#endif
	}

char
TGetChar()			/* Get a character from the keyboeard */
{
#ifdef CPM
	return(bios(3));
#endif
#ifdef LATTICE
	return(getch());
#endif
#ifdef UNIX
	char tchar;

	read(0,&tchar,1);
	return(tchar);
#endif
	}

int
TGetCol()				/* Return the current column possition */
{
	return(pcol);
	}

#ifdef UNIX
movmem(from,to,len)		/* copy a block of memory */
	register char *from, *to;
	register int len;
{
	if (from>to)
		while (len--) *to++ = *from++;
	else {
		from += len;
		to += len;
		while (len--) *--to = *--from;
		}
	}
#endif

/* END OF DISPLAY.C - display utility functions */
                                                                                              