/******************************************************************************
   Perfect Formatter.C -- Perfect Formatter Text Formatter, Main Section

	(C) 1982 Perfect Software, Inc.

	01/26/82	Version 1.00 by Barry A. Dobyns

******************************************************************************/

#include "pf.gbl"

DFini()					/* clean up */
{
	}

LFini()					/* clean up */
{
	LBreakLine();
	}

OFini()					/* closes output file or clears terminal */
{
	if (whereto=='f') {
		WPut(EOF);
		WFlush();
		close(outfd);
		}
#ifdef LATTICE
	else if (whereto=='p') fclose(prn);
#endif
	}

EInit()					/* initialize the abstraction */
{
	env.envprev=NULL;
	}

LInit()					/* initialize the line abstraction */
{
	lin.numtoks=0;
	lin.column=MAXMICA+1;	/* will cause the first token to trip
							a new page */
	issub=issuper=FALSE;
	}

NumInit()					/* initialize pf numbers */
{
	titletail=titlehead=NULL;
	valtail=valhead=NULL;
	notetail=notehead=NULL;
	indhead=NULL;

	headermode=FALSE;
	openneeded=FALSE;
	getarginited=FALSE;
	saveclose=NUL;
	curscript=NUL;

	put.plevel=0;

	level[LEVELMAX-1]=level[0]=NULL;

	nofootnotes=TRUE;
	footnum=0;
	blankpages=0;
	pagenum=0;
	pagevar=SetVar("page",'n',0);
	VarsIni();
	}

EFini()					/* exit the abstraction */
{
	if (env.envprev) TError("Exiting but in a '",env.name,"' environment.");
	}

/*****
MICA
GetDimArg()			/* process a dimensioned, numeric argument */
{
	unsigned n, GetNumArg();
	MICA m;
	STRING *token;

	n=GetNumArg();
	if (!(token=GetArg(RETURN))) {
		TError("Missing dimension.",NULL,NULL);
		return(0);
		}
	switch (Index(token,"in inch inches cm mm point points pica picas em ems char chars character characters line lines micas ")) {

	case 0:	case 1:	case 2:
		m=INCH;
		break;
	case 3:
		m=CENTIMETER;
		break;
	case 4:
		m=CENTIMETER/10;
		break;
	case 5:	case 6:
		m=POINT;
		break;
	case 7:	case 8:
		m=PICA;
		break;
	case 9:	case 10:
		m=Width('m');
		break;
	case 11:	case 12:	case 13:	case 14:
		m=CHARWIDTH;
		break;
	case 15:	case 16:
		m=LINEHEIGHT;
		break;
	case 17:
		m=1;
		break;
	default:
		TError("Unknown unit of measure '",SSToC(token),"'.");
		m=0;
		}
	m*=n;
	SFree(token);
	return(m);
	}

FLAG
GetFlagArg()				/* process an "Yes" or "No" argument */
{
	STRING *token;
	FLAG arg;

	token=GetArg(RETURN);
	if (token && SCompToC(token,"yes")) arg=TRUE;
	else if (token && SCompToC(token,"no")) arg=FALSE;
	else {
		TError("'Yes' or 'No' argument required. '",SSToC(token),
			"' was given.");
		arg=FALSE;
		}
	if (token) SFree(token);
	return(arg);
	}

unsigned
GetNumArg()				/* process a number in the argument */
{
	unsigned n;
	STRING *token;

	if (token=GetArg(RETURN)) {
		n=SSToN(token);
		SFree(token);
		return(n);
		}
	else {
		TError("Missing numeric argument.",NULL,NULL);
		return(0);
		}
	}
*****/

IFini()					/* clean up */
{
	INBUFFER *tmp;

	if (file.fd>=0) close(file.fd);
	if (file.fileprev) {
		TIntError("Exiting from include file or string.");
		for (tmp=file.fileprev; tmp; tmp=tmp->fileprev)
			if (tmp->fd>=0) close(tmp->fd);
		}
	}

IInit(fname)
	char *fname;
{
	IClearBuf();
	tok.tbuflen=0;
	tok.tbuffer[0]=NUL;
	inpnum=0;

	Isettype(0,31,FLUSH);
	Isettype(SP,255,TOKENBREAK);
	Isettype('a','z',TOKEN);
	Isettype('A','Z',TOKEN);
	Isettype('0','9',TOKEN);
	typearray[NUL]=typearray[EOF]=EOFT;
	typearray[NL]=NEWLINE;
	typearray[TAB]=typearray[SP]=WHITESPACE;
	typearray['"']=typearray['\'']=typearray['`']=DELIM;
	typearray['(']=typearray[')']=DELIM;
	typearray['<']=typearray['>']=DELIM;
	typearray['@']=COMMAND;
	typearray['[']=typearray[']']=DELIM;
	typearray['{']=typearray['}']=DELIM;

	typearray[HEADERCENTER]=HEADERCENTER;
	typearray[HEADERRIGHT]=HEADERRIGHT;
	typearray[HEADERLINE]=HEADERLINE;

	unget=FALSE;

	file.fileprev=NOTINITED;
	IInclude(fname);
	}

Isettype(from,to,type)
	int from, to, type;
{
	int i;

	for (i=to; i>=from; i--) typearray[i]=type;
	}

DInit(dv,dvname)			/* initialize the device parameters */
	char dv, *dvname;
{
	devinited=NUL;
	DSetType(dv,dvname);
	devinited=dv;
	}

DSetType(dv,name)			/* declare the device type */
	char dv, *name;
{
	struct {
				/* Input/output port descriptions */
		int fport;			/* the first port record */
		int coninp;			/* console input port */
		int conoutp;			/* console output port */
		int prtinp;			/* Printer input(??) port */
		int prtoutp;			/* printer output port */
		int modinp;			/* modem input port */
		int modoutp;			/* modem output port */
				/* Terminal type descriptions */
		int fterm;			/* first terminal record */
		int ourterm;			/* the default terminal type */
		int simterm;			/* terminal type to simulate */
				/* Printer descriptions */
		int fprint;			/* first printer record */
		int ourprint;			/* the default printer type */
		int conprint;			/* the printer type of the console */
				/* Character width tables */
		int fmicro;			/* the first micro-spacing table record */
		int maxmicro;			/* the number of micro spacing records */
				/* Character translation tables */
		int ftran;			/* the first translation record */
				/* The size of the data file */
		int hmax;				/* number of records including header */

		int cpuspeed;			/* cpu speed in 100KHz */
		char filler[128];
		} hdr;

	int fd, rec, cnt;
	char stybuf[128];

	if (devinited) return;

							/* read in header */
#ifdef UNIX
	if ((fd=open("/etc/pf.dat",0))<0) {
		Fatal("Can't find the config file '/etc/pf.dat'.\n");
#endif
#ifdef CPM
	if ((fd=open("PF.DAT",0))<0 && (fd=open("A:PF.DAT",0))<0) {
		Fatal("Can't find the configuration file, PF.DAT\n");
#endif
#ifdef LATTICE
	if ((fd=open("PF.DAT",0x8000))<0 && (fd=open("A:PF.DAT",0x8000))<0) {
		Fatal("Can't find the configuration file, PF.DAT\n");
#endif
		}
	DRead(fd,&hdr,0,1,"header record");
#ifdef CPM
	if(strcmp(hdr.filler,VERSION) )
		Fatal("Wrong configuration file PF.DAT version");
#endif
							/* read in device table */

	if (!dv || dv=='p') rec=hdr.ourprint;
	else if (dv=='c') rec=hdr.conprint;
	else	{
		for (rec=hdr.fprint; rec<hdr.fmicro; ++rec) {
			DRead(fd,&dev,rec,1,"device descriptions");
			if (SCComp(name,dev.dname)) break;
			}
		if (rec>=hdr.fmicro) {
			TPuts("\nDevice '");
			TPuts(name);
			TPuts("' not found, using default\n");
			rec=hdr.ourprint;
			}
		}
	if (rec) {
		DRead(fd,&dev,rec,1,"device description");
		TPuts("Formatting for device ");
		TPuts(dev.dname);
		TPuts(".\n");
		}
	else {
		Fatal("Default or console device not defined.\n");
		}

						/* read in proportional spacing table */
	if (dev.isprop) DRead(fd,widthtable,hdr.fmicro+2*dev.fontnum,2,
		"spacing table");

						/* read in style defaults */
	DRead(fd,stybuf,2,1,"Style parameters");
	movmem(&stybuf,&sty,sizeof(sty));

	sty.spacing=(sty.spacing*LINEHEIGHT)/10;
#ifndef CPM
	if ( resettabs ) {			/* reset tab spacing for user */
		sty.tabcolumns[0] = tabspace;
		for (cnt = 1; cnt < MAXTABS; ++cnt)
			sty.tabcolumns[cnt] = sty.tabcolumns[cnt-1] + 
				sty.tabcolumns[0];
	}
#endif
	for (cnt=MAXTABS-1; cnt>=0; --cnt) sty.tabcolumns[cnt]*=CHARWIDTH;
	if (dev.stdvert<=dev.micavert) sty.scriptpush=TRUE;

	close(fd);
	}

PInit()					/* initialize */
{
	pag.ptop=sty.stop;
	pag.pleft=sty.sleft /* 2032 */;
	pag.pright=dev.dwidth-sty.sright;
	pag.pbottom=dev.dheight-sty.sbottom;
	pag.numlines=0;
	pag.cumvert=MAXMICA;		/* cause the first page to trip */
	pag.footerline=MAXLINES;
	pag.footerplace=pag.pbottom;
	pag.endline=MAXLINES;
	pag.isfootnote=FALSE;
	pag.lastline=NULL;
	minpage=32767;
	}

PFini()					/* finish up */
{
	minpage=min(minpage,ASpace(PageSpace));

	if (pag.numlines>0) {
		OPutPage();
		PFree();
		}
#ifndef UNIX
	TPuts("\nLargest page used ");
	TPutn(pagesize-minpage);
	TPuts(" out of ");
	TPutn(pagesize);
	TPuts(" bytes.\nEnd space used ");
	TPutn(sty.endsize-(unsigned)ASpace(EndSpace));
	TPuts(" out of ");
	TPutn(sty.endsize);
	TPuts(" bytes.");
#endif
	}

OInit(where,filename)		/* opens file for output */
	char where;
	char *filename;
{
	char fname[LENFILENAME];
#ifdef LATTICE
	int mode;
#endif

	outnotinitied=TRUE;
#ifdef LATTICE
	if (where=='c') whereto=where;
	else if (where=='p') {
		whereto=where;
		strcpy(fname,PRINTER);
		mode = _fmode;
		if ((prn=fopen(fname,"w"))==NULL) {
			TPuts("Unable to open printer device.\n");
			menu();
			}
		_fmode = mode;
		}
#else
	if (where=='c' || where=='p') whereto=where;
#endif
	else {
		whereto='f';
		strcpy(&fname,filename);
		ProcessSuffix(&fname,".fin",!where);
#ifdef CPM
		if ((outfd=creat(fname))<0) {
#endif
#ifdef LATTICE
		if ((outfd=creat(fname,0x8000))<0) {
#endif
#ifdef UNIX
		if ((outfd=creat(fname,0640))<0) {
#endif
			TPuts("Unable to open output file.\n");
			menu();
			}
		outchar=outputbuffer;
		}
	}

VarsIni()
{
	chapter=SetVar("chapter",'n',0);
	section=SetVar("section",'n',0);
	subsection=SetVar("subsection",'n',0);
	paragraph=SetVar("paragraph",'n',0);
	appendix=SetVar("appendix",'n',0);
	asection=SetVar("appendixsection",'n',0);

	chaptitle=SetVar("chaptertitle",'s',SCToS(""));
	sectitle=SetVar("sectiontitle",'s',SCToS(""));
	subtitle=SetVar("subsectiontitle",'s',SCToS(""));
	paratitle=SetVar("paragraphtitle",'s',SCToS(""));
	apptitle=SetVar("appendixtitle",'s',SCToS(""));
	asectitle=SetVar("appendixsectiontitle",'s',SCToS(""));
	SetVar("version",'s',SCToS(VERSION));
	SetVar("devicename",'s',SCToS(dev.dname));
	SetVar("filename",'s',SCToS(&file.filedesc[5]));
	SetVar("badob",'s',SCToS("Program created by Barry A. Dobyns"));
	}

/* end of intovl.c */
                                                                                                                        