/* ALLOC.C - The memory allocator package *************************************

	(C) 1982 Perfect Software, Inc.

	01/26/82	Version 1.00 by Barry A. Dobyns

	This is a general purpose memory allocator

*****************************************************************************/

#include "pf.gbl"

#ifdef CPM
#define SPACE struct aspace

SPACE {
	int Astr[4];
	};
#endif

SPACE *
AInit(room)			/* Initialize storage management routines */
	unsigned room;				/* no. bytes to leave for stack */
#ifdef CPM
{
	SPACE *Acur;
	unsigned topofmem(), endext();

	Abegin=Acap=endext()+sizeof(*Acur);
	Asize=(topofmem()-endext()-(sizeof(*Acur)+2)-room)/2;
	Aend=Abegin+Asize;
	*Aend = 1;					/* Store marker at end */
	*Acap = -Asize;
	movmem(&Acap,endext(),sizeof(*Acur));
	return(endext());
	}
#else
{
	SPACE *Acur;
	char *getmem();
	unsigned size;
	unsigned sizmem();

	allmem();
	Acur = (SPACE *) getmem(sizeof(*Acur));
	size = (sizmem() * 2) - room;
	*Acur = size;
	return(Acur);
	}
#endif

SPACE *
ASubSpace(spc,size)			/* Create a sub space in 'spc' */
	SPACE *spc;
#ifdef CPM
	int size;
#else
	unsigned size;
#endif
{
	char *AAlloc();
	SPACE *Acur;

#ifdef CPM
	if ((Acur=AAlloc(spc,size+sizeof(*spc)+2))==NULL) return(NULL);
	Asize=size/2;
	Abegin=Acap=Acur+1;
	Aend=Abegin+Asize;
	*Aend = 1;					/* Store marker at end */
	*Acap = -Asize;
	movmem(&Acap,Acur,sizeof(*Acur));
	return(Acur);
#else
	Acur  = (SPACE *) AAlloc(spc, sizeof(*spc));
	*Acur = size;
	return(Acur);
#endif	
	}

char *
AAlloc(spc,size)			/* Allocate an object of size bytes */
	SPACE *spc;
	unsigned size;
{
#ifdef CPM
	int *tcap;

	movmem(spc,&Acap,sizeof(*spc));
	if (Acap==NULL) return(NULL); /* no space to alloc from */
	if (*Acap>=0) _AError("Corrupt Space");
	tcap=Acap;				/* save current alloc point */
	size=(size+3)/2;			/* size in words, inc. header */
	while (-*Acap<size) if (!_ACoalesce() && !_AFindNext(tcap)) {
		movmem(&Acap,spc,sizeof(*spc));
		return(NULL);
		}
	tcap=Acap;				/* Chomp the required amount */
	if (-*tcap != size) *(Acap+=size) = size + *tcap;
	else if (!_AFindNext(tcap)) Acap=NULL;
	*tcap=size;
	movmem(&Acap,spc,sizeof(*spc));
	return(tcap+1);
#else
	char *getmem();
	unsigned *obj;

	if (size > *spc) return(NULL);	/* out of memory in space */
	obj = (unsigned *) getmem(size = size + sizeof(unsigned *));

	if (!obj) return(NULL);		/* out of memory */
	*spc = *spc - size;		/* reduce the default space size */
	*obj = size;			/* store the size of the object */
	return(++obj);			/* return pointer to beg. of object */
#endif
	}

AFree(spc,obj)			/* Free an allocated object */
	SPACE *spc;
#ifdef CPM
	int *obj;
#else
	unsigned *obj;
#endif
{
#ifdef CPM
	movmem(spc,&Acap,sizeof(*spc));
	if (obj<Abegin || obj>Aend) {
		_AError("Bad ptr freed");
		return;
		}
	--obj;					/* point to header */
	*obj = -*obj;
	if (Acap==NULL) {
		Acap=obj;
		movmem(&Acap,spc,sizeof(*spc));
		}
#else
	int rlsmem();
	unsigned size;

	if ( rlsmem(--obj, size = *obj) ) {  /* remember obj has its size */
		_AError("Bad ptr freed");
		return;
		}
	*spc = *spc + size;		/* increase space by size amount */
#endif
	}

#ifdef CPM
FLAG
_ACoalesce()			/* Coalesce the object at Acap with any freed
						objects after it */
{
	int olen, tlen;

	olen = *Acap;
	while ((tlen = *(Acap - *Acap)) < 0) {
		*Acap += tlen;
		if (!_AChk()) break;
		}
	return(*Acap!=olen);
	}

	/* Note that this can't assume it's on a freed object. */
FLAG
_AFindNext(wend)		/* Find the next freed object */
	int *wend;
{
	int *tend;

	tend=Acap;
	Acap+=abs(*Acap);
	if (Acap==Aend) Acap=Abegin;
	while (*Acap>0 && (Acap>wend ||
		 Acap + *Acap <= wend)) {
		Acap += *Acap;
		if (Acap==Aend) Acap=Abegin;
		if (!_AChk()) {
			Acap=tend;
			return(FALSE);
			}
		}
	if (*Acap<0 && (Acap>wend || Acap - *Acap<=wend))
		return(TRUE);
	Acap=tend;
	return(FALSE);
	}

#endif
	/* length of object, in bytes, not counting overhead word */
unsigned
ALen(spc,obj)
	SPACE *spc;
#ifdef CPM
	int *obj;
{
	return((*(obj-1)-1)*2);
	}
#else
	unsigned *obj;
{
	return(*(--obj) - sizeof(unsigned *));
	}
#endif

	/* total amount of space still available, in bytes */
unsigned
ASpace(spc)
	SPACE *spc;
{
#ifdef CPM
	int sum, *temp;

	movmem(spc,&Acap,sizeof(*spc));
	sum=0;
	for (temp=Abegin; temp!=Aend; temp+=abs(*temp))
		if (temp>Aend || *temp==0) _AError("Memory munged");
		else if (*temp<0) sum += -*temp;
	return(sum*2);
#else
	return(*spc);
#endif
	}

	/* Print the globals and the size of every object */
#ifdef CPM
APrtWrld(spc)
	SPACE *spc;
{
	movmem(spc,&Acap,sizeof(*spc));
	_APrnt();
	}

_APrnt()			/* The internal print routine */
{
	int al, fre, *temp;

	printf("Abegin = %u., Aend = %u., Acap = %u.\n",
		Abegin,Aend,Acap);
	TPuts("Abegin = ");
	TPutn(Abegin);
	TPuts(", Aend = ");
	TPutn(Aend);
	TPuts(", Acap = ");
	TPutn(Acap);
	TNL();

	al=fre=0;
	for (temp=Abegin; temp<Aend; temp+=abs(*temp)) {
		printf("  at %u., %u.  %c\n",temp,abs(*temp)*2,
			(*temp<0) ? 'f' : 'a');
		TPuts("  at ");
		TPutn(temp);
		TPuts(", ");
		TPutn(abs(*temp)*2);
		TPuts(",   ");
		TPut((*temp<0) ? 'f' : 'a');
		TNL();

		if (*temp>0) al += *temp;
		else if (*temp<0) fre += -*temp;
		else break;
		}
	if (temp!=Aend) {
		printf("** Last obj ends on Aend + %d. **\n",temp-Aend);
		TPuts("** Last obj ends on Aend + ");
		TPutn(temp-Aend);
		TNL();
		}
	printf("-- %u. allocated, %u. free\n",al*2,fre*2);
	TPuts("-- ");
	TPutn(al*2);
	TPuts(" allocated, ");
	TPutn(fre*2);
	TPuts(" free\n");

	if (al+fre!=Asize) {
		printf ("-- ** total = Asize + %u. **\n",(al+fre-Asize)*2);
		TPuts("-- ** total = Asize + ");
		TPutn((al+fre-Asize)*2);
		TNL();
		}
	}

FLAG
_AChk()				/* Check for a valid allocation point */
{
	if (Acap<Abegin || Acap>Aend ||
		 Acap+abs(*Acap)>Aend || !*Acap) {
		_AError("Memory Bashed");
		return(FALSE);
		}
	return(TRUE);
	}
#endif

_AError(msg)			/* Print an error */
	char *msg;
{
	TIntError(msg);
#ifdef CPM
	_APrnt();
#endif
	}

/* THIS IS THE END OF ALLOC.C */
                   