#include "date.h"

/* compilation flags */

/*	#define BADOB	*/		/* Barry A. Dobyns only */
/*	#define CPM	*/		/* CP/M only */
#define LATTICE	
/*	#define UNIX		*/	/* UNIX only */

#ifdef	CPM
#define OVERLAID	1		/* CP/M only has overlay's */
#else
#define	OVERLAID	0
#endif

#define LARGE	

/* -------------------------------------------------- */

/* program constants */

#define MAXLINES	100		/* max # of lines/page */
#define MAXTOKENS	50		/* max # of tokens/line */
#define MAXMESSAGE	150		/* max # of chars in error message */
#define STACKSIZE	2048		/* amount of stack space to reserve */
#ifdef CPM
#define BUFFRECS 	8		/* i/o buffer size in records */
#define BUFFSIZE 	(128*8)	/* i/o buffer size in bytes */
#define RECSIZE 	128		/* i/o record size in bytes */
#define LENFILENAME	20		/* length of a file name */
#endif
#ifdef UNIX
#define BUFFRECS	1024		/* I/O buffer size in bytes */
#define BUFFSIZE	1024		/* I/O buffer size in bytes */
#define RECSIZE	1		/* I/O record size */
#define LENFILENAME	30		/* length of a file name */
#endif
#ifdef LATTICE
#define BUFFRECS 	8		/* i/o buffer size in records */
#define BUFFSIZE 	(128*8)	/* i/o buffer size in bytes */
#define RECSIZE 	128		/* i/o record size in bytes */
#define LENFILENAME	20		/* length of a file name */
#endif

/* -------------------------------------------------- */

/* programming conventions */

#define repeat		while (TRUE)
#define TRUE		1
#define FALSE		0
#define NULL		0
#define MICA		unsigned
#define FLAG		char
#define STRING		char
#define LINEHEIGHT	dev.stdvert
#define CHARRES	dev.micahoriz
#define CHARWIDTH	dev.stdhoriz

/* ASCII characters */

#define NUL	0
#define BELL	'\7'
#define BS	'\8'
#define TAB	'\t'
#define LF	'\12'
#define FF	'\14'
#define CR	'\15'
#define SP	' '
#define DEL	'\177'
#define NL	'\n'
#define EOF	'\32'

/* -------------------------------------------------- */

/* output file description */

#define SENTENCEBREAK	0177		/* ^? */

#define BOLDON			0302		/* ~B */
#define BOLDOFF		0342		/* ~b */
#define ROMANON		0322		/* ~R */
#define ROMANOFF		0362		/* ~r */
#define UNNBON			0325		/* ~U underscore tokens */
#define UNNBOFF		0365		/* ~u */
#define UNALLON		0301		/* ~A underscore everything */
#define UNALLOFF		0341		/* ~a */
#define UNANON			0316		/* ~N underscore alphanumeric */
#define UNANOFF		0356		/* ~n */
#define ITALON			0311		/* ~I italics */
#define ITALOFF		0351		/* ~i */
#define BITALON		0320		/* ~P bold italics */
#define BITALOFF		0360		/* ~p */
#define SUPERON		0323		/* ~S superscripts */
#define SUPEROFF		0363		/* ~s */
#define SUBON			0324		/* ~T subscripts (why not?) */
#define SUBOFF			0364		/* ~t */
#define EXITON			0330		/* ~X eXit unusual attributes */
#define EXITOFF		0370		/* ~x */
#define F1ON			0260		/* ~0 Font 1 */
#define F1OFF			0261		/* ~1 */
#define F2ON			0262		/* ~2 Font 2 */
#define F2OFF			0263		/* ~3 */
#define F3ON			0264		/* ~4 Font 3 */
#define F3OFF			0265		/* ~5 */

#define JUSTIFY		0212		/* ~^J */
#define HORIZSPACE		0210		/* ~^H */
#define VERTSPACE		0226		/* ~^V */
#define TOKBREAK		0240		/* ~SP */

/* -------------------------------------------------- */

/* token types */

#define EOFT			'\32'
#define WHITESPACE		' '
#define NEWLINE		'\n'
#define TOKEN			'A'
#define TOKENBREAK		'B'
#define FLUSH			'F'
#define DELIM			'('
#define COMMAND		'@'
#define HEADERCENTER	0203		/* ~^C */
#define HEADERRIGHT		0222		/* ~^R */
#define HEADERLINE		0214		/* ~^L */

/* options for argument routines */

#define ARGFLUSH		'f'
#define RETURN			'r'
#define PRINT			'p'
#define HOLD			'h'
#define SAMPLE			'd'

/* measurement */

#define INCH		2540		/* 2540 mica/inch (2540 = 2 x 2 x 5 x 127) */
#define HALFINCH	1270		/* 1/2" */
#define CENTIMETER	1000		/* 1000 mica/cm */
#define PICA		423 /* 1/3 */	/* 1/6" */
#define POINT		35 /* 5/18 */	/* 1/12 pica or 1/72" */

#ifdef CPM
#define MAXMICA	48000	/* largest possible mica measurement */
#else
#define MAXMICA ((unsigned)48000)	/* largest legal mica mesurment */
#endif

/* structure and array constants */

#define LINEDATA struct linestruct

