/****************** the initial version of the menu for Perfect Writer

	(C) 1982, 1983 Perfect Software, Inc.

***********************************************************************/

#include "menu.gbl"

main(argc, argv)
int	argc;
char	*argv[];
{
	int rdsp;

	setup(argc, argv);		/* get the terminal parameters */
	while(1){			/* do forever */
		TClrWind();		/* clear window */
		maindsp();		/* display main menu */
		rdsp=0;			/* redisplay not needed */
		dskreset();		/* reset all disk drives */
		while(!rdsp){		/* do until wee need redisplay */
			TDisStr((TMaxRow()-4),0,
			"Type one character to indicate your selection now: ");
#ifdef YINYANG
			TDisStr((TMaxRow()-3),0,
			"Your Choice: ");
#endif
			now = nxtstr = nxtarg = 0;
			for (cnt = 0; cnt < LINMAX; ++cnt) {
				linebuf[cnt] = '\0';
				execstr[cnt] = '\0';
			}
			for (cnt = 0; cnt < MAXARGS; ++cnt) {
				arglist[cnt]=0;
				for (tmp = 0; tmp < ARGLEN; ++tmp)
					strargs[cnt][tmp] = '\0';
			}
			TCLEOW();
			TForce();
			tmp = TGetKb();
			tmp = ToUpper(tmp);
			if ( tmp >= ' ') TPrntChar(tmp);
			TCLEOW();
			switch (tmp) {

			case 'Q':	/* eXit */
			case '\003':	/* C-C */
				rdsp = Quit();
				break;

			case '\014':	/* redisplay ^L */
				rdsp = 1;
				break;

			case '*':	/* identify version, like in PW */
				rdsp = Verse();
				break;

#ifdef YINYANG
			case 'C':	/* send command string to DOS */
				rdsp = ComStr();
				break;
#endif

			case 'E':	/* erase a file */
				rdsp = DelFile();
				break;

#ifdef YINYANG
			case 'R':	/* rename file */
				rdsp = RenFile();
				break;
#endif YINYANG

			case 'D': 	/* get a directory */
				rdsp = Dir();
				break;

			case 'C':	/* create a file */
				rdsp = EdtFile(0);
				break;

			case 'R':	/* revise a file */
				rdsp = EdtFile(1);
				break;
			case 'F':	/* format a file */
				rdsp = FmtFile();
				break;

			case 'P':	/* print a file */
				rdsp = PrtFile();
				break;

			case 'S':	/* spell a file */
				rdsp = SplFile();
				break;

			} /* end of switch(tmp) */
		} /* end of while(!rdsp) */
	} /* end of while(1) */
} /* end of main() */

RenFile()
{
	char	tmp;

	TDisStr((TMaxRow()-2),0,
	"What is the current name of the file you wish to rename:");
	TCLEOW();
	if(!GetArg(">",CR,linebuf,LINMAX)) return(0);
	TDisStr((TMaxRow()-2),0,
	"What new name do you wish to rename '");
	TPrntStr(linebuf);
	TPrntStr("' to:");
	TCLEOW();
	strcpy(execstr,"     ");
	if(!GetArg(">",CR,execstr,LINMAX)) return(0);
	TDisStr((TMaxRow()-2),0,
	"Do you really wish to rename '");
	TPrntStr(linebuf);
	TPrntStr("' to '");
	TPrntStr(execstr);
	TPrntStr("' ? ");
	TCLEOW();
	TForce();
	tmp = TGetKb();
	if (toupper(tmp) != 'Y'){
		TDisStr((TMaxRow()-1),0,"Not Renamed.");
		sleep(5);
		return(0);
	}
	rename(linebuf,execstr);
	TDisStr((TMaxRow()-1),0,"File Renamed.");
	sleep(5);
	return(0);
}	/* end of RenFile()	*/

FmtFile()
{
	char	prompt[80];
	char	fname[32];

	now = 0;
	strcpy(linebuf,SCRIBBLE);
	if(cur_doc != NULL){
		strcpy(fname, cur_doc);
		dfltext(fname, "MSS");
		sprintf(prompt,
		"Name of document you wish to format [%s]: ",
		fname);
		strcpy(execstr, fname);
	} else {
		strcpy(execstr,"     ");
		strcpy(prompt, "Name of document you wish to format: ");
	}
	if (!GetArg(prompt, CR,execstr,LINMAX)) return(0);
	strcat(linebuf,execstr);
	nxtarg = GetLineArg();
	if(nxtarg > 2){
		GoToIt(arglist);
		return(1);
	}
	for (cnt = 2; cnt < MAXARGS; ++cnt) {
		arglist[cnt]=0;
		for (tmp = 0; tmp < ARGLEN; ++tmp)
			strargs[cnt][tmp] = '\0';
	}
	filename = arglist[1];
	nxtarg = 0;	/* next available arg -1 */
	nxtstr = 0;	/* next available strarg -1*/
	pfdsp();
floop:
	now = 0;
	dspargs(TMaxRow()-4);
	TCLEOW();
	TDisStr((TMaxRow()-3),0,"Your Choice: ");
	tmp = TGetKb();
	tmp = ToUpper(tmp);
	if ( tmp >= ' ') TPrntChar(tmp);
	TCLEOW();
	switch(tmp){
	case 'Q': 			/* Quit */
		return(1);
	case 'G':			/* go */
		now = 1;
		arglist[++nxtarg]=filename;
		arglist[++nxtarg]=0;
		break;
	case 'S': 			/* Select different device type */
		if(ArgExists("-dev")) break;
		arglist[++nxtarg]=Dev();
		TDisStr((TMaxRow()-2),0,
		"What printer do you wish to format this for? ");
		scanf("%s", strargs[++nxtstr]);
		arglist[++nxtarg]=strargs[nxtstr];
		break;
	case 'C':			/* send to console */
		if(ArgExists("-c")) break;
		if(ArgChk("-o")) break;
		if(ArgChk("-p")) break;
		arglist[++nxtarg]=Alph('c');
		break;
	case 'P': 			/* pause for manual insertion */
		if(ArgExists("-pause")) break;
		arglist[++nxtarg]=Pause();
		break;
	case 'N':			/* no formatting, type as entered */
		if(ArgExists("-typewriter")) break;
		arglist[++nxtarg]=Typewriter();
	case 'D':			/* direct print from formatter */
		if(ArgExists("-print")) break;
		if(ArgChk("-o")) break;
		if(ArgChk("-c")) break;
		arglist[++nxtarg] = "-print";
		break;
#ifdef YINYANG
	case 'O': 			/* send output to to ... */
		if(ArgChk("-p")) break;
		if(ArgChk("-c")) break;
		if(ArgExists("-o")) break;
		arglist[++nxtarg]=Alph('o');
		TDisStr((TMaxRow()-2),0,
		"What do you wish to name the output file? ");
		scanf("%s",strargs[++nxtstr]);
		arglist[++nxtarg]=strargs[nxtstr];
#endif
	default:	
		break;
	} /* end of switch(tmp) */
	if (!now){
		arglist[nxtarg + 1] = filename;
		goto floop;
	}
	else GoToIt(arglist);
	return(1);
}		/* end of FmtFile() */

PrtFile()
{
	char	prompt[80];
	char	fname[32];
	char	*chrptr;
	int	digit;

	digit = 0;
	now = 0;
	strcpy(linebuf,CRAYON);
	if(cur_doc != NULL){
		strcpy(fname, cur_doc);
		chrptr = fname;
		while(*chrptr && *chrptr != '.')
			chrptr++;
		if(*chrptr && *++chrptr){
			if(match(chrptr, "MSS"))
				*--chrptr = NULL;
		}
		dfltext(fname, "FIN");
		sprintf(prompt,
		"Name of document you wish to print [%s]: ",
		fname);
		strcpy(execstr, fname);
	} else {
		strcpy(execstr,"     ");
		strcpy(prompt, "Name of document you wish to print: ");
	}
	if (!GetArg(prompt, CR,execstr,LINMAX)) return(0);
	strcat(linebuf,execstr);
	nxtarg = GetLineArg();
	if(nxtarg > 2){
		GoToIt(arglist);
		return(1);
	}
	for (cnt = 2; cnt < MAXARGS; ++cnt) {
		arglist[cnt]=0;
		for (tmp = 0; tmp < ARGLEN; ++tmp)
			strargs[cnt][tmp] = '\0';
	}
	filename = arglist[1];
	nxtarg = 0;	/* next available arg -1 */
	nxtstr = 0;	/* next available strarg -1*/
	ppdsp();
ploop:
	now = 0;
	dspargs(TMaxRow()-4);
	TCLEOW();
	TDisStr((TMaxRow()-3),0,"Your Choice: ");
	tmp = TGetKb();
	tmp = ToUpper(tmp);
	if ( tmp >= ' ') TPrntChar(tmp);
	TCLEOW();
	switch(tmp){
	case 'Q': 			/* eXit */
		return(1);

	case 'G':			/* go */
		now = 1;
		arglist[++nxtarg]=filename;
		arglist[++nxtarg]=0;
		break;

	case 'B':				/* print at page */
		if(ArgExists("-page")) break;
		arglist[++nxtarg]=Page();
		TDisStr((TMaxRow()-2),0,
		"What page do you wish to begin printing with? ");
		scanf("%s", strargs[++nxtstr]);
		if(!ArgDgtChk(strargs[nxtstr])) arglist[nxtarg--]=0;
		else arglist[++nxtarg]=strargs[nxtstr];
		break;

	case 'M': 			/* Multiple copies desired */
		if (digit) {
			ArgBotch();
			break;
		}
		strcpy(strargs[++nxtstr],"-");
		arglist[++nxtarg]=strargs[nxtstr];
		TDisStr((TMaxRow()-2),0,
		"How many copies do you want to print? ");
		scanf("%s", strargs[++nxtstr]);
		if(!ArgDgtChk(strargs[nxtstr])) arglist[nxtarg--]=0;
		else strcat(arglist[nxtarg],strargs[nxtstr]);
		digit=1;
		break;

	case 'P':			/* pause for manual insertion */
		if(ArgExists("-pause")) break;
		arglist[++nxtarg]=Pause();
		break;

#ifdef YINYANG
	case 'O': 				/* output port */
		if(ArgExists("-port")) break;
		arglist[++nxtarg]=Port();
		TDisStr((TMaxRow()-2),0,
		"To which PortName should the output be sent? ");
		scanf("%s",strargs[++nxtstr]);
		arglist[++nxtarg]=strargs[nxtstr];
#endif
	default:	
		break;
	} /* end of switch(tmp) */
	if (!now){
		arglist[nxtarg + 1] = filename;
		goto ploop;
	}
	else GoToIt(arglist);
	return(1);
} /* end of PrtFile() */

SplFile()
{
	char	prompt[80];
	char	fname[32];

	now = 0;
	strcpy(linebuf,PS);
	if(cur_doc != NULL){
		strcpy(fname, cur_doc);
		dfltext(fname, "MSS");
		sprintf(prompt,
		"Document you whose spelling you wish to check [%s]: ",
		fname);
		strcpy(execstr, fname);
	} else {
		strcpy(execstr,"     ");
		strcpy(prompt,"Document whose spelling you wish to check: ");
	}
	if (!GetArg(prompt, CR,execstr,LINMAX)) return(0);
	strcat(linebuf,execstr);
	nxtarg = GetLineArg();
	if(nxtarg > 2){
		GoToIt(arglist);
		return(1);
	}
	for (cnt = 2; cnt < MAXARGS; ++cnt) {
		arglist[cnt]=0;
		for (tmp = 0; tmp < ARGLEN; ++tmp)
			strargs[cnt][tmp] = '\0';
	}
	filename = arglist[1];
	nxtarg = 0;	/* next available arg -1 */
	nxtstr = 0;	/* next available strarg -1*/
	psdsp();
sloop:
	now = 0;
	dspargs(TMaxRow()-4);
	TCLEOW();
	TDisStr((TMaxRow()-3),0,"Your Choice: ");
	tmp = TGetKb();
	tmp = ToUpper(tmp);
	if ( tmp >= ' ') TPrntChar(tmp);
	TCLEOW();
	switch(tmp){
	case 'Q': 
		return(1);
	case 'G':	
		now = 1;
		arglist[++nxtarg]=filename;
		arglist[++nxtarg]=0;
		break;
	case 'A': 
		if(ArgExists("-a")) break;
		arglist[++nxtarg]=Alph('a');
		break;
	case 'N': 
		if(ArgExists("-n")) break;
		if(ArgChk("-b")) break;
		arglist[++nxtarg]=Alph('n');
		break;
	case 'C': 
		if(ArgExists("-b")) break;
		if(ArgChk("-n")) break;
		arglist[++nxtarg]=Alph('b');
		TDisStr((TMaxRow()-2),0,
		"What is the backup extension? <3 characters>");
		scanf("%s",strargs[++nxtstr]);
		arglist[++nxtarg]=strargs[nxtstr];
		break;
	case 'D': 				/* dictionary other than .. */
		if(ArgExists("-d")) break;
		arglist[++nxtarg]=Alph('d');
		TDisStr((TMaxRow()-2),0,
		"What is the Dictionary name? ");
		scanf("%s",strargs[++nxtstr]);
		arglist[++nxtarg]=strargs[nxtstr];
		break;
	case 'P': 
		if(ArgExists("-x")) break;
		arglist[++nxtarg]=Alph('x');
		TDisStr((TMaxRow()-2),0,
		"What is the Affix table name? ");
		scanf("%s",strargs[++nxtstr]);
		arglist[++nxtarg]=strargs[nxtstr];
		break;
	default:	
		break;
	} /* end of switch(tmp) */
	if (!now){
		arglist[nxtarg + 1] = filename;
		goto sloop;
	}
	else GoToIt(arglist);
	return(1);
} /* end of SplFile() */

Verse()		/* print version number */
{
	TDisStr((TMaxRow()-2),0, "Menu System Version 1.00");
	TGetKb();
	return(0);
} /* end of Verse() */

#ifdef YINYANG
ComStr()
{
	char	tmp;

	strcpy(execstr,"     ");
	TDisStr((TMaxRow()-2),0,
	"Are you positive you want to send DOS a command line? ");
	tmp = TGetKb();
	if (toupper(tmp) != 'Y')
		return(0);
	TDisStr((TMaxRow()-2),0,
	"Your Command line for DOS: ");
	TCLEOW();
	if (!GetArg(">",CR,linebuf,LINMAX)) return(0);
	GetLineArg();
	GoToIt(arglist);
	return(1);
} /* end of ComStr() */
#endif YINYANG

DelFile()
{
	char	tmp;

#ifdef YINYANG
	TDisStr((TMaxRow()-2),0,
	"What is the name of the document you wish to delete:");
	TCLEOW();
#endif YINYANG
	if(!GetArg("What is the name of the document you wish to erase: ",
		CR,linebuf,LINMAX)) return(0);
	TDisStr((TMaxRow()-2),0,
	"Do you really wish to erase '");
	TPrntStr(linebuf);
	TPrntStr("' ? ");
	TCLEOW();
	TForce();
	tmp = TGetKb();
	if (toupper(tmp) != 'Y'){
		TDisStr((TMaxRow()-1),0,"Not Erased.");
		sleep(5);
		return(0);
	}
	if(unlink(linebuf) == -1){
		TBell();
		TDisStr((TMaxRow() - 1), 0, "Couldn't erase `");
		TPrntStr(linebuf);
		TPrntStr("'.");
		TCLEOW();
	} else {
		TDisStr((TMaxRow()-1),0,"Document Erased.");
	}
	sleep(5);
	return(0);
} /* end of DelFile() */

EdtFile(revise)
int	revise;
{
	char	prompt[80];
	char	fname[32];
	char	str[80];
	char	*message;

	strcpy(linebuf,MINCE);
	strcpy(execstr,"     ");
	arglist[nxtarg]=linebuf;
	if(revise){
		if(cur_doc != NULL){
			strcpy(fname, cur_doc);
			dfltext(fname, "MSS");
			sprintf(str, " [%s]", fname);
			strcpy(execstr, fname);
		} else
			str[0] = NULL;

		message = "What document do you wish to revise%s: ";
		sprintf(prompt, message, str);
	} else {
		message = "What do you wish to name your document: ";
		strcpy(prompt, message);
	}
	if (!GetArg(prompt,CR,execstr,LINMAX)) return(0);
	arglist[++nxtarg]=execstr;
	arglist[++nxtarg]=0;
	GoToIt(arglist);
	return(1);
}	/* end of EdtFile() */

Dir()
{
	char	message[80];
	char	c;
	char	def_drive;

	def_drive = bdos(0x19) + 'A';
	sprintf(message, "Which Drive do you desire a directory of [%c]: ",
		def_drive);
	TDisStr((TMaxRow()-2),0, message);
	TCLEOW();
	TForce();
	c=TGetKb();
	switch(toupper(c)){
	case '\n':			/* carriage return */
	case '\r':			/* or newline */
		c = def_drive;		/* default to ``def_drive'' */
		break;

	case '\007':			/* bell */
	case '\008':			/* or backspace */
	case '\177':			/* or delete */
		return(0);		/* force an abort */
		break;
	} /* end of switch(c) */

	return(DoDirect(c));	/* do the bloody directory */
}


Quit()
{
	char	tmp;

	TDisStr((TMaxRow()-2),0,
	"Are you sure you want to exit to DOS? ");
	tmp = TGetKb();
	if (toupper(tmp) == 'Y'){
		TFini();		/* clean up this mess */
		exit();
		return(1);	/* in case exit can't ?? */
	}
	else return(0);
}

Lose()			/* unimplemented choice, BZZZZT! YOU LOSE! */
{
	TDisStr((TMaxRow()-2),0,
"That option is currently unimplemented, let's try one from the list above.");
	TDisStr((TMaxRow()-1),0,
	"<Type anything to continue>");
	TGetKb();
	return(0);
}

/* end of menu.c - the menu program for Perfect Text Mangler */

sleep (seconds)
int	seconds;
{
	int	i;
	int	loop, sec;

	for(i = 0; i < seconds; i++){
		for(loop = 0; loop < 2; loop++){
			for(sec = 0; sec < 16356; sec++)
				;
		}
	}
}

match(s1, s2)				/* case-independent string equality */
char *s1, *s2;
{
	while(TRUE) {
		if(toupper(*s1) != toupper(*s2)) return(FALSE);
		if(!*s1++ || !*s2++) return(TRUE);
	}
}
