/* GLOBALS defined in MAIN module */
extern int Tabsx, Tabsy;
extern int Tlines, Tcols;
extern char Tinstr[LIN];  extern int Tinnul;
extern char Tdeinstr[LDEIN];  extern int Tdeinnul;
extern char Tdcpstr[LDCP];  extern int Tdcpnul;
extern char Tclsstr[LCLS];  extern int Tclsnul;
extern char Teosstr[LEOS];  extern int Teosnul;
extern char Teolstr[LEOL];  extern int Teolnul;
extern char Trvstr[LRV];
extern char Tnvstr[LNV];
extern int prtwidth;
extern char Pinstr[LPIN], Pdeinstr[LPDEIN];
extern char Tbottom[LBOTTOM];
extern int Keys[128];

struct window           /* def'n of a screen window */
{   int active;                 /* flag -- TRUE if window is active */
    int fullscreen;             /* flag -- TRUE if window screen complete */
    int cx, cy;                 /* V: current element */
    int lines, cols;            /* V: # lines & columns showing */
    int homex, homey;           /* V: current upper lefthand position */
    int minx, miny;             /* V: min <x,y> (for fixed titles) */
    int colwidth, decpl, just;  /* V: global column width and dec place */
    int markx, marky;           /* V: mark location */
    int tlines, tcols;          /* T: actual # lines, columns available */
    int tdispx, tdispy;         /* T: displacement on terminal of home 
                                      position corrected for fixed titles */
    int toffx, toffy;           /* T: offset of this window (starts at 1,1) */
    int OK_EOL;                 /* T: OK to use CLEOL on this window */
    int OK_EOS;                 /* T: OK to use CLEOS on this window */
    int curbuf, prevbuf;        /* current & previous buffer indices */
};
extern struct window win[], *w, *w2;
extern int synch;               /* Flag: windows in synch */

struct buffer                   /* definition of a buffer */
{   int bsize;                  /* from the memory manager */
    char bname[9];              /* name of this buffer */
    char bfile[17];             /* filename in this buffer */
    char **bscp;                /* screen pointer -- like **pickbuf */
    int blx, bly, blsy;         /* lastx, lasty, scrny for this buffer */
    char *bdp, *bcolw, *bj;     /* coldp[], indcolw[] for this buffer */
    int bmod;                   /* whether or not buffer has been modified */
    int linked;                 /* other buffer this one is linked to */
    int updx[2], updy[2];       /* update region for buffer */
    /* Following buffer items duplicate window items */
    int bcx, bcy;               /* V: current element */
    int bhomex, bhomey;         /* V: current upper lefthand position */
    int bcolwidth, bdecpl, bjust;/* V: global column width and dec place */
    int bmarkx, bmarky;         /* V: mark location */
};
extern struct buffer *Buff[MAXBUF];     /* pointers to buffer definitions */

extern int curx, cury;
extern char **screen[];
extern int lastx, lasty;
extern int scrny;
extern int keybuf;
extern int gotkey;
extern int updform;
extern int fullscreen;
extern int abort;
extern int modified;
extern int NoCurUpd;

extern char *EntBuf;
extern int initdone;

extern char **pickbuf;
extern int picktype;
extern int pickx[2], picky[2];

extern int cmdarg;
extern int rangex[2], rangey[2];
extern int chrcnt;

extern char *file;
extern FILE *chanfp;
extern char *prfile;
extern int gotfile;

extern char coldp[];
extern char coljust[];
extern char indcolw[];

extern unsigned freespace;
extern char *LastMem;

extern FILE *swpfp;
extern FILE *finfp, *foutfp;
extern int _fmode;
extern int vid_mode;


extern int tracecnt;
