********************************************
*   ASM PART OF SOS OPERATING SYSTEM       *
********************************************
	ORG 0
	DC.W	RTEND	;SIZE OF LINKABLE CODE
	DC.W	30	;ENTRY COUNT
	DC.B	'OSINIT      '
	DC.W	OSINIT
	DC.B	'USER        '
	DC.W	USER
	DC.B	'CLOCKSET    '
	DC.W	CLOCKSET
	DC.B	'EXSET       '
	DC.W	EXSET
	DC.B	'WAIT        '
	DC.W	WAIT	
;-- 5 --- LINKS TO CONSOLE DRIVER
	DC.B	'GETCON      '
	DC.W	GETCON
	DC.B	'PUTCON      '
	DC.W	PUTCON
	DC.B	'INITCON     '
	DC.W	INITCON
	DC.B	'STATCON     '
	DC.W	STATCON
	DC.B	'CNTRLCON    '
	DC.W	CNTRLCON
;-- 5 --- LINKS TO PRINTER
	DC.B	'GETPRN      '
	DC.W	GETPRN
	DC.B	'PUTPRN      '
	DC.W	PUTPRN
	DC.B	'INITPRN     '
	DC.W	INITPRN
	DC.B	'STATPRN     '
	DC.W	STATPRN
	DC.B	'CNTRLPRN    '
	DC.W	CNTRLPRN	
;-- 5 --- LINKS TO DISK 1 DRIVER
	DC.B	'DSKREAD.1   '
	DC.W	DSKREAD1
	DC.B	'DSKWRITE.1  '
	DC.W	DSKWRITE1
	DC.B	'DSKSTAT.1   '
	DC.W	DSKSTAT1
	DC.B	'DSKCNTRL.1  '
	DC.W	DSKCNTRL1
	DC.B	'DSKFLSH.1   '
	DC.W	DSKFLSH1
;-- 5 --- LINKS TO DISK 2 DRIVER
	DC.B	'DSKREAD.2   '
	DC.W	DSKREAD2
	DC.B	'DSKWRITE.2  '
	DC.W	DSKWRITE2
	DC.B	'DSKSTAT.2   '
	DC.W	DSKSTAT2
	DC.B	'DSKCNTRL.2  '
	DC.W	DSKCNTRL2
	DC.B	'DSKFLSH.2   '
	DC.W	DSKFLSH2
;-- 5 --- LINKS TO DISK 3 DRIVER
	DC.B	'DSKREAD.3   '
	DC.W	DSKREAD3
	DC.B	'DSKWRITE.3  '
	DC.W	DSKWRITE3
	DC.B	'DSKSTAT.3   '
	DC.W	DSKSTAT3
	DC.B	'DSKCNTRL.3  '
	DC.W	DSKCNTRL3
	DC.B	'DSKFLSH.3   '
	DC.W	DSKFLSH3
*********************************************
*                 ACTUAL CODE               *
*********************************************
		ORG	0
;---- SETUP A PATCH VARIABLE BASE 256 BELOW RTL
PATCH		EQU	0-100H
;---- INITIALIZE REG SWAP AREA
OSINIT		JMP	PATCH(A3)
;---- RETURN TO A USER PROGRAM
USER		JMP	PATCH+6(A3)
;---- INITIALIZE CLOCK
CLOCKSET	JMP	PATCH+12(A3)
;---- SET AN EXCEPTION VECTOR
EXSET		JMP	PATCH+18(A3)
;---- WAIT TOS MILLISECONDS
WAIT		JMP	PATCH+24(A3)	
;*********  CONSOLE DRIVER LINKS *******************
;---- GET A CHARACTER FROM CONSOLE, RETURN IT ON STACK
GETCON		JMP	PATCH+30(A3)
;---- SEND TOP OF STACK CHAR TO CONSOLE
PUTCON		JMP	PATCH+36(A3)
;---- INITIALIZE CONSOLE
INITCON		JMP	PATCH+42(A3)
;---- GET STATUS OF CONSOLE
STATCON		JMP	PATCH+48(A3)
;---- SEND CONTROL STRING TO CONSOLE
CNTRLCON	JMP	PATCH+54(A3)
;---- VECTORS FOR PRINTER
GETPRN		JMP	PATCH+60(A3)
PUTPRN		JMP	PATCH+66(A3)
INITPRN		JMP	PATCH+72(A3)
STATPRN		JMP	PATCH+78(A3)
CNTRLPRN	JMP	PATCH+84(A3)
;---- READ RECORD FROM DISK 1
DSKREAD1	JMP	PATCH+90(A3)
;---- WRITE RECORD TO DISK 1
DSKWRITE1	JMP	PATCH+96(A3)
;---- STATUS OF DISK 1
DSKSTAT1	JMP	PATCH+102(A3)
;---- SEND CONTROL TO DISK 1
DSKCNTRL1	JMP	PATCH+108(A3)
;---- FLUSH DISK 1
DSKFLSH1	JMP	PATCH+114(A3)
;---- VECTORS FOR DISK 2
DSKREAD2	JMP	PATCH+120(A3)
DSKWRITE2	JMP	PATCH+126(A3)
DSKSTAT2	JMP	PATCH+132(A3)
DSKCNTRL2	JMP	PATCH+138(A3)
DSKFLSH2	JMP	PATCH+144(A3)
;---- VECTORS FOR DISK 3
DSKREAD3	JMP	PATCH+150(A3)
DSKWRITE3	JMP	PATCH+156(A3)
DSKSTAT3	JMP	PATCH+162(A3)
DSKCNTRL3	JMP	PATCH+168(A3)
DSKFLSH3	JMP	PATCH+174(A3)
;-------- SET SIZE OF MODULE AND MAKE IT EVEN
	EVEN
RTEND	EQU	$
	END

   