; THIS MODULE WAS DESIGNED TO BE CALLED FROM MICROSOFT COMPILED QUICK-BASIC
ENTER MACRO
 PUSH BP
 MOV BP,SP
 ADD BP,6
 PUSH SI
 PUSH DI
 CLD
 ENDM
LEAVE MACRO
 POP DI
 POP SI
 POP BP
 RET 8
 ENDM
;
BUFFSIZE EQU 16*1024 ;BUFFER SIZE (MAXIMUM TAPE BLOCK SIZE)
;
BASBUF SEGMENT PARA PUBLIC 'BASBUF'
BASBUF ENDS
;
CONST SEGMENT WORD PUBLIC 'CONST'
;
BUFFER DW 0,BUFFSIZE
TBUF DW 0
;
FUNCTAB LABEL WORD
 DW FUNCT  ;00 RETURN STATUS
 DW WRITE  ;01 WRITE A BLOCK
 DW READ   ;02 READ A BLOCK
 DW WRITE  ;03 WRITE IN EDIT MODE
 DW READ   ;04 READ IN REVERSE EDIT MODE
 DW READ   ;05 READ IN REVERSE MODE
 DW FUNCT  ;06 WRITE TAPE MARK
 DW FUNCT  ;07 FORWARD SPACE FILE
 DW FUNCT  ;08 BACK SPACE FILE
 DW FUNCT  ;09 FORWARD SPACE RECORD
 DW FUNCT  ;10 BACK SPACE RECORD
 DW FUNCT  ;11 REWIND
 DW FUNCT  ;12 REWIND & UNLOAD
 DW FUNCT  ;13 SET 1600 BPI
 DW FUNCT  ;14 SET 3200 BPI
 DW FUNCT  ;15 SET FAST SPEED
 DW FUNCT  ;16 SET SLOW SPEED
 DW FUNCT  ;17 SET LONG GAP
 DW FUNCT  ;18 SET SHORT GAP
 DW FUNCT  ;19 ERASE FIXED
 DW FUNCT  ;20 ERASE TO EOT
 DW FUNCT  ;21 SET THE NUMBER OF RETRYS
 DW FUNCT  ;22 RESET ERROR COUNTS
 DW FUNCT  ;23 RETURN READ ERROR COUNT
 DW FUNCT  ;24 RETURN WRITE ERROR COUNT
 DW FUNCT  ;25 TAPE CARD PRESENT?
 DW FUNCT  ;26 TAPE UNIT ONLINE?
 DW SETADR ;27 SET TAPE ADDRESS 0 - 7
FUNCMAX EQU ($-FUNCTAB)/2
;
TAPEFUNC DW 0
STATADDR DW 0,0
COUNTADR DW 0,0
BUFFADDR DW 0,0
TAPEADDR DW 0020H
;
CONST ENDS
DGROUP GROUP CONST
;
 PUBLIC BASTAPE
CODE SEGMENT BYTE PUBLIC 'CODE'
 ASSUME CS:CODE,DS:DGROUP,ES:DGROUP
BASTAPE PROC FAR
 ENTER
;
 MOV BX,WORD PTR [BP+6]  ;FUNCTION
 MOV AX,WORD PTR [BX]
 CMP AX,FUNCMAX
 MOV TAPEFUNC,AX
 JBE RS01
 MOV DX,0040H            ;SET COMMAND REJECT
 JMP RS02
RS01:
 SHL AX,1
 MOV SI,AX
 MOV CX,FUNCTAB[SI]      ;ADDRESS OF FUNCTION IN CX
;
 MOV AX,WORD PTR [BP+4]  ;GET ADDRESS OF STATUS RETURN WORD
 MOV STATADDR,AX
;
 MOV AX,WORD PTR [BP+2]  ;GET ADDRESS OF COUNT WORD
 MOV COUNTADR,AX
;
 MOV BX,WORD PTR [BP]    ;GET ADDRESS OF BUFFER
 MOV AX,WORD PTR [BX+2]
 MOV BUFFADDR,AX
;
 MOV AX,TAPEFUNC
 XCHG AL,AH
 CALL CX                 ;CALL THE APPROPRIATE ROUTINE
RS02:                    ;COMES BACK W/DX=STATUS
 MOV BX,STATADDR
 MOV WORD PTR [BX],DX
 LEAVE
BASTAPE ENDP
;
WRITE PROC NEAR          ;WRITE A BLOCK TO TAPE
 PUSH AX
 CALL CHKBUF             ;BE SURE BUFFER IS ALLOCATED
 POP AX
 PUSH ES
 MOV BX,COUNTADR
 MOV CX,WORD PTR [BX]
 MOV DI,BUFFER
 MOV BX,TBUF
 MOV ES,BX               ;TARGET = ES:DI IN 'TBUF'
 MOV SI,BUFFADDR
 PUSH CX                 ;SAVE COUNT
 REP MOVSB               ;MOVE DATA TO OUR BUFFER
 POP CX
 MOV BX,BUFFER
 MOV DX,TAPEADDR
 INT 13H                 ;GO TO THE TAPE ROUTINE
 POP ES                  ;RESTORE ES
 RET
WRITE ENDP
;
READ PROC NEAR           ;READ A BLOCK FROM TAPE
 PUSH AX
 CALL CHKBUF             ;BE SURE BUFFER IS ALLOCATED
 POP AX
 PUSH ES
 MOV BX,COUNTADR
 MOV CX,WORD PTR [BX]
 CMP CX,BUFFSIZE
 JBE RD01
 MOV CX,BUFFSIZE
RD01:
 MOV BX,TBUF
 MOV ES,BX
 MOV BX,BUFFER
 MOV DX,TAPEADDR
 INT 13H                 ;GO READ TAPE DATA
 MOV BX,COUNTADR
 MOV WORD PTR [BX],CX    ;RETURN COUNT TO CALLER
 POP ES
 PUSH DS
 MOV SI,BUFFER
 MOV DI,BUFFADDR
 MOV AX,TBUF
 MOV DS,AX               ;SOURCE = DS:SI
 REP MOVSB               ;MOVE DATA BACK TO CALLER
 POP DS
 RET
READ ENDP
;
FUNCT PROC NEAR          ;ALL NON-READ/WRITE FUNCTIONS TO THE TAPE
 MOV BX,COUNTADR
 MOV CX,WORD PTR [BX]    ;PASS COUNT WORD
 MOV DX,TAPEADDR
 INT 13H
 MOV BX,COUNTADR
 MOV WORD PTR [BX],CX    ;RETURN COUNT TO APPLICATION
 RET
FUNCT ENDP
;
SETADR PROC NEAR         ;SET THE ADDRESS USED FOR TAPE CALLS
 MOV BX,COUNTADR
 MOV CX,WORD PTR [BX]
 CMP CX,7
 JA  STA01
 ADD CX,20H
 MOV TAPEADDR,CX
STA01:
 MOV AH,0
 CALL FUNCT
 RET
SETADR ENDP
;
CHKBUF PROC NEAR         ;ALLOCATE A BUFFER THAT IS NOT ACROSS A 64K BOUNDARY
 CMP TBUF,0
 JNE CKB01               ;ONCE IS ENOUGH ...
 MOV AX,BASBUF
 MOV TBUF,AX             ;SAVE THE SEGMENT FOR READ/WRITE ROUTINES
 MOV CX,16
 MUL CX
 ADD AX,BUFFER
 ADC DX,0
 ADD AX,BUFFSIZE
 JZ  CKB01 ;OK
 JNC CKB01 ;OK
 MOV AX,BUFFER
 XCHG BUFFER+2,AX
 MOV BUFFER,AX
CKB01:
 RET
CHKBUF ENDP
;
CODE ENDS
 END
