;*******************************************************************
;*                                                                 *
;*   MODULE:  COBTAPE.ASM                                          *
;*                                                                 *
;*   FUNCTION:  Tape Language Interface for use with MicroSoft     *
;*              COBOL (Ver. 3.0).                                  *
;*                                                                 *
;*   UPDATES:   10-89  d.r.s.                                      *
;*                                                                 *
;*   COMMENTS:  At present, this module is set up to work with     *
;*              COBOL objects generated from source compiled       *
;*              with the default "HUGE" model size.                *
;*              Use "COBOL source, ANIM" to compile and            *
;*                  "LINK source+COBTAPE;" to link.                *
;*                                                                 *
;*              This model pushes the "USING" parameters onto      *
;*              the stack as far pointers (4 bytes) in reverse     *
;*              order, similar to C.                               *
;*                                                                 *
;*              The COBOL syntax for use with this module is:      *
;*                                                                 *
;*              CALL "_COBTAPE" USING function_#, status_array,    *
;*                                    count, dos_record.           *
;*                                                                 *
;*******************************************************************
ENTER MACRO
 PUSH DS
 SUB AX,AX
 PUSH AX
 PUSH BP
 MOV BP,SP
 ADD BP,4
 PUSH SI
 PUSH DI
 ENDM
LEAVE MACRO
 POP DI
 POP SI
 POP BP
 POP AX
 POP DS
 RET
 ENDM
;
BUFFSIZE EQU 16384 ;BUFFER SIZE
TBUF SEGMENT
BUFF1 DB BUFFSIZE DUP(0) ;ALTERNATE BUFFERS TO AVOID DMA ACROSS 64K
BUFF2 DB BUFFSIZE DUP(0)
TBUF ENDS
;
_DATA SEGMENT WORD PUBLIC 'DATA'
DGROUP GROUP _DATA
;
BUFFER DW BUFF1,BUFF2
;
FUNCTAB LABEL WORD
 DW FUNCT  ;00 RETURN STATUS
 DW WRITE  ;01 WRITE A BLOCK
 DW READ   ;02 READ A BLOCK
 DW WRITE  ;03 WRITE IN EDIT MODE
 DW READ   ;04 READ IN REVERSE EDIT MODE
 DW READ   ;05 READ IN REVERSE MODE
 DW FUNCT  ;06 WRITE TAPE MARK
 DW FUNCT  ;07 FORWARD SPACE FILE
 DW FUNCT  ;08 BACK SPACE FILE
 DW FUNCT  ;09 FORWARD SPACE RECORD
 DW FUNCT  ;10 BACK SPACE RECORD
 DW FUNCT  ;11 REWIND
 DW FUNCT  ;12 REWIND & UNLOAD
 DW FUNCT  ;13 SET 1600 BPI
 DW FUNCT  ;14 SET 3200 BPI
 DW FUNCT  ;15 SET FAST SPEED
 DW FUNCT  ;16 SET SLOW SPEED
 DW FUNCT  ;17 SET LONG GAP
 DW FUNCT  ;18 SET SHORT GAP
 DW FUNCT  ;19 ERASE FIXED
 DW FUNCT  ;20 ERASE TO EOT
 DW FUNCT  ;21 SET THE NUMBER OF RETRYS
 DW FUNCT  ;22 RESET ERROR COUNTS
 DW FUNCT  ;23 RETURN READ ERROR COUNT
 DW FUNCT  ;24 RETURN WRITE ERROR COUNT
 DW FUNCT  ;25 TEST FOR TAPE ADAPTER CARD
 DW FUNCT  ;26 TEST FOR UNIT ON LINE
 DW SETADR ;27 SET TAPE ADDRESS 0 - 7
FUNCMAX EQU ($-FUNCTAB)/2
;
TAPEFUNC DW 0
STATADDR DW 0
COUNTADR DW 0
BUFFADDR DW 0
TAPEADDR DW 0020H
;
_DATA ENDS
;
 PUBLIC _COBTAPE
_TEXT SEGMENT BYTE PUBLIC 'CODE'
 ASSUME CS:_TEXT,DS:DGROUP,ES:DGROUP
_COBTAPE PROC FAR
 ENTER
 MOV ES,[BP+8]  ; LOAD WITH COBOL DATA SEGMENT
 MOV SI,[BP+6]
 MOV AX,DGROUP
 MOV DS,AX
 CLD
 PUSH ES
 MOV AX,WORD PTR ES:[SI] ;LOAD FUNCTION # INTO AX
 XCHG AL,AH
 CMP AX,FUNCMAX
 MOV TAPEFUNC,AX              ;COPY FUNCTION # INTO TAPEFUNC
 JBE RS01
 MOV DX,0040H                 ;SET COMMAND REJECT
 JMP RS02
RS01:
 MOV BX,WORD PTR [BP+0AH]     ;OFFSET TO STATUS ARRAY
 MOV STATADDR,BX
 MOV BX,WORD PTR [BP+0EH]     ;OFFSET TO COUNT
 MOV COUNTADR,BX
 MOV BX,WORD PTR [BP+012H]    ;OFFSET TO BUFFER
 MOV BUFFADDR,BX
 SHL AX,1
 MOV BX,AX
 MOV CX,FUNCTAB[BX]           ;GET FUNCTION OFFSET
 MOV AX,TAPEFUNC
 XCHG AL,AH
 CALL CX                      ;CALL APPROPRIATE FUNCTION
; POP ES
; LEAVE
RS02:                         ;COMES BACK W/DX=STATUS
 MOV DI,STATADDR              ;COPY STATUS BITS AS 'T' AND 'F'
 MOV CX,16                    ;  INTO STATUS ARRAY
 OR  DX,DX
RS03:
 MOV AL,'T'
 JS  RS04
 MOV AL,'F'
RS04:
 STOSB
 SHL DX,1
 LOOP RS03
 POP ES
 LEAVE                        ;RETURN TO CALLING COBOL ROUTINE
_COBTAPE ENDP
;
WRITE PROC NEAR
 PUSH AX
 CALL CHKBUF
 POP AX
 PUSH ES
 MOV BX,COUNTADR
 MOV CX,WORD PTR ES:[BX]
 XCHG CL,CH
 MOV SI,BUFFADDR
 MOV DI,BUFFER
; MOV BX,TBUF
; MOV ES,BX
 PUSH CX
 REP MOVSB
 POP CX
 MOV BX,[BUFFADDR]
 MOV DX,TAPEADDR
 INT 13H
 POP ES
 RET
WRITE ENDP
;
READ PROC NEAR
 PUSH AX
 CALL CHKBUF
 POP AX
 MOV BX,COUNTADR
 MOV CX,WORD PTR ES:[BX]
 XCHG CL,CH
 CMP CX,BUFFSIZE
 JBE RD01
 MOV CX,BUFFSIZE
RD01:
 PUSH ES
 MOV BX,TBUF
 MOV ES,BX
 MOV BX,BUFFER
 MOV DX,TAPEADDR
 INT 13H
 MOV BX,COUNTADR
 XCHG CL,CH
 MOV WORD PTR ES:[BX],CX
 XCHG CL,CH
 MOV DI,BUFFADDR
 MOV SI,BUFFER
 POP ES
 PUSH DS
 MOV AX,TBUF
 MOV DS,AX
 REP MOVSB
 POP DS
 RET
READ ENDP
;
FUNCT PROC NEAR
 MOV BX,COUNTADR
 MOV CX,WORD PTR ES:[BX]   ;USE FAR POINTER TO GET COUNT
 XCHG CL,CH
 MOV DX,TAPEADDR           ;COPY TAPEADDR INTO DX
 INT 13H                   ;TAPE DRIVER INTERRUPT
 MOV BX,COUNTADR
 XCHG CL,CH
 MOV WORD PTR ES:[BX],CX
 RET
FUNCT ENDP
;
SETADR PROC NEAR
 MOV BX,COUNTADR
 MOV CX,WORD PTR ES:[BX]
 XCHG CL,CH
 CMP CX,7
 JA  STA01
 ADD CX,20H
 MOV TAPEADDR,CX
STA01:
 MOV AH,0
 CALL FUNCT
 RET
SETADR ENDP
;
CHKBUF PROC NEAR
 MOV AX,TBUF
 MOV CX,16
 MUL CX
 ADD AX,BUFFER
 ADC DX,0
 ADD AX,BUFFSIZE
 JZ  CKB01 ;OK
 JNC CKB01 ;OK
 MOV AX,BUFFER
 XCHG BUFFER+2,AX
 MOV BUFFER,AX
CKB01:
 RET
CHKBUF ENDP
;
_TEXT ENDS
 END
