BUFFSIZE EQU 32768 ;BUFFER SIZE
TBUF SEGMENT
BUFF1 DB BUFFSIZE DUP(0) ;ALTERNATE BUFFERS TO AVOID DMA ACROSS 64K
BUFF2 DB BUFFSIZE-1 DUP(0)
TBUF ENDS
;
DATA SEGMENT PUBLIC 'DATA'
;
BUFFER DW BUFF1,BUFF2
;
FUNCTAB LABEL WORD
 DW FUNCT  ;00 RETURN STATUS
 DW WRITE  ;01 WRITE A BLOCK
 DW READ   ;02 READ A BLOCK
 DW WRITE  ;03 WRITE IN EDIT MODE
 DW READ   ;04 READ IN REVERSE EDIT MODE
 DW READ   ;05 READ IN REVERSE MODE
 DW FUNCT  ;06 WRITE TAPE MARK
 DW FUNCT  ;07 FORWARD SPACE FILE
 DW FUNCT  ;08 BACK SPACE FILE
 DW FUNCT  ;09 FORWARD SPACE RECORD
 DW FUNCT  ;10 BACK SPACE RECORD
 DW FUNCT  ;11 REWIND
 DW FUNCT  ;12 REWIND & UNLOAD
 DW FUNCT  ;13 SET 1600 BPI
 DW FUNCT  ;14 SET 3200 BPI
 DW FUNCT  ;15 SET FAST SPEED
 DW FUNCT  ;16 SET SLOW SPEED
 DW FUNCT  ;17 SET LONG GAP
 DW FUNCT  ;18 SET SHORT GAP
 DW FUNCT  ;19 ERASE FIXED
 DW FUNCT  ;20 ERASE TO EOT
 DW FUNCT  ;21 SET THE NUMBER OF RETRYS
 DW FUNCT  ;22 RESET ERROR COUNTS
 DW FUNCT  ;23 RETURN READ ERROR COUNT
 DW FUNCT  ;24 RETURN WRITE ERROR COUNT
 DW FUNCT  ;25 TEST FOR TAPE ADAPTER CARD
 DW FUNCT  ;26 TEST FOR UNIT ON LINE
 DW SETADR ;27 SET TAPE ADDRESS 0 - 7
FUNCMAX EQU ($-FUNCTAB)/2
;
TAPEFUNC DW 0
STATADDR DW 0,0
COUNTADR DW 0,0
BUFFADDR DW 0,0
TAPEADDR DW 0020H
;
DATA ENDS
DGROUP GROUP DATA
;
 PUBLIC FORTAP
CODE SEGMENT 'CODE'
 ASSUME CS:CODE,DS:DGROUP,SS:DGROUP
FORTAP PROC FAR
 JMP FT00
 DB 'FORTAPE ROUTINE'
FT00:
 PUSH BP
 MOV BP,SP
;
 LES BX,DWORD PTR [BP+18]
 MOV AX,ES:[BX]
 CMP AX,FUNCMAX
 MOV TAPEFUNC,AX
 JBE RS01
 MOV DX,0040H            ;SET COMMAND REJECT
 JMP RS02
RS01:
 SHL AX,1
 MOV SI,AX
 MOV CX,FUNCTAB[SI]       ;ADDRESS OF FUNCTION IN CX
;
 MOV AX,[BP+14]           ;STATUS
 MOV DX,[BP+16]
 MOV STATADDR,AX
 MOV STATADDR+2,DX
;
 MOV AX,[BP+10]           ;COUNT
 MOV DX,[BP+12]
 MOV COUNTADR,AX
 MOV COUNTADR+2,DX
;
 MOV AX,[BP+6]            ;BUFFER
 MOV DX,[BP+8]
 MOV BUFFADDR,AX
 MOV BUFFADDR+2,DX
;
 MOV AX,TAPEFUNC
 XCHG AL,AH
 CALL CX         ;CALL THE APPROPRIATE ROUTINE
RS02:            ;COMES BACK W/DX=STATUS
 LES DI,DWORD PTR STATADDR
 MOV CX,16
 OR  DX,DX
RS03:
 MOV AL,'T'
 JS  RS04
 MOV AL,'F'
RS04:
 STOSB
 SHL DX,1
 LOOP RS03
 POP BP
 RET 16
FORTAP ENDP
;
WRITE PROC NEAR
 PUSH AX
 CALL CHKBUF
 POP AX
 PUSH ES
 LES SI,DWORD PTR COUNTADR
 MOV CX,WORD PTR ES:[SI]  ;GET COUNT INTO CX
 MOV DI,BUFFER
 MOV BX,TBUF
 MOV ES,BX                ;TARGET = ES:DI IN 'TBUF'
 PUSH DS
 LDS SI,DWORD PTR BUFFADDR   ;SOURCE = DS:SI FROM CALLER
 PUSH CX                  ;SAVE COUNT
 REP MOVSB                ;MOVE DATA TO OUR BUFFER
 POP CX
 POP DS
 MOV BX,BUFFER
 MOV DX,TAPEADDR
 INT 13H                  ;GO TO THE TAPE ROUTINE
 POP ES                   ;RESTORE ES
 RET
WRITE ENDP
;
READ PROC NEAR
 PUSH AX
 CALL CHKBUF
 POP AX
 PUSH ES
 LES SI,DWORD PTR COUNTADR
 MOV CX,WORD PTR ES:[SI]
 CMP CX,BUFFSIZE
 JBE RD01
 MOV CX,BUFFSIZE
RD01:
 MOV BX,TBUF
 MOV ES,BX
 MOV BX,BUFFER
 MOV DX,TAPEADDR
 INT 13H                   ;GO READ TAPE DATA
 LES SI,DWORD PTR COUNTADR
 MOV WORD PTR ES:[SI],CX   ;RETURN COUNT TO CALLER
 LES DI,DWORD PTR BUFFADDR ;GET ADDRESS OF CALLER'S BUFFER (ES:DI)
 PUSH DS
 MOV SI,BUFFER
 MOV AX,TBUF
 MOV DS,AX                 ;SOURCE = DS:SI
 REP MOVSB                 ;MOVE DATA BACK TO CALLER
 POP DS
 POP ES
 RET
READ ENDP
;
FUNCT PROC NEAR
 PUSH ES
 LES SI,DWORD PTR COUNTADR
 MOV CX,WORD PTR ES:[SI]
 POP ES
 MOV DX,TAPEADDR
 INT 13H
 PUSH ES
 LES SI,DWORD PTR COUNTADR
 MOV WORD PTR ES:[SI],CX   ;RETURN COUNT TO CALLER
 POP ES
 RET
FUNCT ENDP
;
SETADR PROC NEAR
 PUSH ES
 LES SI,DWORD PTR COUNTADR
 MOV CX,WORD PTR ES:[SI]
 POP ES
 CMP CX,7
 JA  STA01
 ADD CX,20H
 MOV TAPEADDR,CX
STA01:
 MOV AH,0
 CALL FUNCT
 RET
SETADR ENDP
;
CHKBUF PROC NEAR
 MOV AX,TBUF
 MOV CX,16
 MUL CX
 ADD AX,BUFFER
 ADC DX,0
 ADD AX,BUFFSIZE
 JZ  CKB01 ;OK
 JNC CKB01 ;OK
 MOV AX,BUFFER
 XCHG BUFFER+2,AX
 MOV BUFFER,AX
CKB01:
 RET
CHKBUF ENDP
;
CODE ENDS
 END
