		      COBTAPE.ASM UPDATE

    The COBOL portion of Flagstaff Engineering's Tape Language Interface
has been updated for use with MicroSoft's COBOL compiler (Ver. 3.0).  For
proper use, the following guidelines must be followed:

1)  Maximum block size for reading and writing cannot exceed 9,999 bytes
    due to the manner in which the compiler represents numeric variables
    internally.  As a result, the definition of the count parameter
    (i.e. TCOUNT) must be:
           02  TCOUNT PIC S9(4) COMP-0.
    Failure to use this definition will result in the parameters being
    read incorrectly and cause errors.

    In the description of the dos record, the REC-FLD must have a picture
    with the size equal to the block size indicated in the count parameter.
    Example:
    (in the FILE SECTION)
       01  DOSREC.
           02  REC-FLD PIC X(1024).

    (in the PROCEDURE DIVISION)
           MOVE 1024 TO TCOUNT.

2)  COBOL source modules must be compiled using either the default "HUGE"
    memory model or the "LARGE" memory model.  This will treat the parameters
    to the tape routines as far pointers (4 bytes).  Attempting to use the
    smaller memory models will pass near pointers (2 bytes) to the tape
    routines, which will cause errors.

3)  When writing files out to disk, make sure the file size is a multiple
    of the record size.  Failure to do so may result in the last block of
    data from the file to not be written to tape.  Upon completion of
    copying the file to tape, write two tape marks to indicate logical end
    of tape.

4)  Use "COBOL source, ANIM" to compile and "LINK source+COBTAPE;" to link.              

