/* INITBLCK.C -- initializes a block of memory to a chosen character. */

#include <stdio.h>
#include <time.h>

#define SIZE 2048 * 5
#define LIMIT 256

int sample[SIZE];

main(void)
{
	clock_t start, end;
	double t1, t2, t3;
	register int i, j;
	int *arr_addr = sample;

	start = clock();
	for(j = 0; j < LIMIT; j++) for(i = 0; i < SIZE; i++) sample[i] = 12345;
	end = clock();
	t1 = (end - start) / (double)CLK_TCK;
	printf("%d %d\n", sample[0], sample[SIZE - 1]);

	start = clock();
	for(j = 0; j < LIMIT; j++)
		_asm \
		{
			push	di
			push	es
			mov   ax, ds
			mov	es, ax
			mov	di, WORD PTR arr_addr
			mov	ax, 23451
			mov	cx, SIZE
			rep	stosw
			pop	es
			pop	di
		}
	end = clock();
	t2 = (end - start) / (double)CLK_TCK;
	printf("%d %d\n", sample[0], sample[SIZE - 1]);
	printf("C time = %0.2f, Assembly time = %0.2f\n", t1, t2);
}

