#include "johnniac.h"
#include <stdio.h>

byte IR[5] = {0, 0, 0, 0, 0};
byte AC[5] = {0, 0, 0, 0, 0};
byte MQ[5] = {0, 0, 0, 0, 0};
byte NR[5] = {0, 0, 0, 0, 0};
byte TNR[5] = {0, 0, 0, 0, 0};
byte buffer[80];
byte OV, ACC, OVIGN, D1, D2, D3, T1, T2, T3, H1, H2, H3, STOP;
char oc, stop, OfloIgn, d1, d2, d3, h1, h2, h3, t1, t2, t3;
int ch, bl;
int NIA, ST;
long count;
struct rccoord tp;

void main()
{
   long bkcolor;
   short txtcolor, i;

   bkcolor = _getbkcolor();
   _settextrows(50);
   _setbkcolor(2L);
   txtcolor = _gettextcolor();
   _clearscreen(_GCLEARSCREEN);
   _settextcursor(0x0007);
   _settextposition(2, 38);
   _settextcolor(0);
   _outtext("JOHNNIAC");
   _settextcolor(1);
   _settextposition(4, 23);
   sprintf(buffer, "   %c       %c                       %c   ", 0xB1, 0xB1, 0xB1);
   _outtext(buffer);
   _settextcolor(14);
   _settextposition(4, 39);
   sprintf(buffer, "   %c       %c", 0xB0, 0xB0);
   _outtext(buffer);
   _settextposition(5, 23);
   sprintf(buffer, "                  BELL    IAD");
   _settextcolor(0);
   _outtext(buffer);
   _settextposition(7, 5);
   _outtext("A  ");
   _settextposition(9, 5);
   _outtext("IR ");
   _settextposition(11, 5);
   _outtext("NR ");
   _settextposition(13, 5);
   _outtext("MQ ");
   _settextposition(15, 5);
   _outtext("NIA");
   _settextposition(17, 5);
   _outtext("S  ");
   _settextcolor(15);
   _setbkcolor(1L);
   _settextcolor(3);
   _settextposition(7, 35);
   _outtext(" CLR COND KEYS ");
   _settextposition(9, 37);
   _outtext(" O'FLO IGN ");
   _settextposition(11, 35);
   _outtext(" D1 ");
   _settextposition(11, 40);
   _outtext(" D2 ");
   _settextposition(11, 45);
   _outtext(" D3 ");
   _settextposition(13, 35);
   _outtext(" T1 ");
   _settextposition(13, 40);
   _outtext(" T2 ");
   _settextposition(13, 45);
   _outtext(" T3 ");
   _settextposition(15, 35);
   _outtext(" H1 ");
   _settextposition(15, 40);
   _outtext(" H2 ");
   _settextposition(15, 45);
   _outtext(" H3 ");
   _settextposition(17, 34);
   _setbkcolor(4L);
   _settextcolor(15);
   _outtext("      STOP      ");
   _setbkcolor(5L);
   _settextcolor(14);
   _settextposition(7, 60);
   _outtext("  FETCH  ");
   _settextposition(9, 55);
   _outtext(" L INSTR ");
   _settextposition(9, 65);
   _outtext(" R INSTR ");
   _settextposition(11, 59);
   _outtext(" ONE INSTR ");
   _setbkcolor(3L);
   _settextcolor(10);
   _settextposition(13, 61);
   _outtext("  LOAD  ");
   _settextposition(15, 61);
   _outtext("   GO   ");
   _settextposition(17, 60);
   _outtext(" GO TO S ");
   _setbkcolor(6L);
   _settextcolor(9);
   _settextposition(20, 12);
   _outtext(" 0 ");
   _settextposition(20, 16);
   _outtext(" 1 ");
   _settextposition(20, 20);
   _outtext(" 2 ");
   _settextposition(20, 24);
   _outtext(" 3 ");
   _settextposition(20, 28);
   _outtext(" 4 ");
   _settextposition(20, 32);
   _outtext(" 5 ");
   _settextposition(20, 36);
   _outtext(" 6 ");
   _settextposition(20, 40);
   _outtext(" 7 ");
   _settextposition(20, 44);
   _outtext("104");
   _settextposition(20, 48);
   _outtext("105");
   _settextposition(20, 52);
   _outtext(" 11");
   _settextposition(20, 56);
   _outtext(" 12");
   _settextposition(20, 60);
   _outtext(" 13");
   _settextposition(20, 64);
   _outtext(" 14");
   _settextposition(20, 68);
   _settextcolor(15);
   _outtext("MGA");
   _setbkcolor(2L);
   _settextcolor(0);
   _settextposition(21, 36);
   _outtext("HOOT SELECTOR");
edisplay:
   _setbkcolor(7L);
   _settextcolor(15);
   _settextposition(7, 10);   /* Accumulator */
   HexToOct(&AC[0]);
   _settextposition(13,10);   /* MQ */
   HexToOct(&MQ[0]);
   _settextposition(11, 10);  /* Number Register    */
   HexToOct(&NR[0]);
   _settextposition(9, 10);   /* Instruction Register */
   HexToOct(&IR[0]);
   _settextposition(15, 10);
   sprintf(buffer, "    %04o         ", NIA);
   _outtext(buffer);
   _settextposition(17, 10);
   sprintf(buffer, "    %04o         ", ST);
   _outtext(buffer);
   _settextcolor(0);
   _settextposition(7, 10);
   bl = 0;
   while(1)
   {
      while(!kbhit);
      ch = getch();
      if(ch == 0) ch = getch() + 0x100;
      if(ch == 0x0D) goto edisplay;
      tp =_gettextposition();
      if(tp.col == 10) oc = '1';
      else oc = '7';
      if((ch >= '0') && (ch <= oc) && (bl == 0))
      {
         _settextcolor(0);
         sprintf(buffer, "%o", ch & 0x07);
         _outtext(buffer);
         tp =_gettextposition();
         tp.col -= 1;
         _settextposition(tp.row, tp.col);
         _settextcolor(15);
         ch = ' ';
      }
      if((ch == ' ') && (bl > 0))
      {
         tp = _gettextposition();
         switch(bl)
         {
            case 1:
               switch(tp.row)
               {
                  case 17:
                     _settextposition(17, 34);
                     _setbkcolor(4L);
                     _settextcolor(15);
                     _outtext("      STOP      ");
                     stop = 1;
                     _settextposition(17, 42);
                     break;
                  case 7:
                     _setbkcolor(1L);
                     _settextcolor(15);
                     _settextposition(7, 35);
                     _outtext(" CLR COND KEYS ");
                     count = 1600000L;
                     while(count > 0) --count;
                     _settextcolor(3);
                     _settextposition(7, 35);
                     _outtext(" CLR COND KEYS ");
                     _settextposition(7, 42);
                     break;
                  case 9:
                     _setbkcolor(1L);
                     if(OfloIgn == 0)
                     {
                        _settextcolor(15);
                        OfloIgn = 1;
                        _settextposition(9, 37);
                        _outtext(" O'FLO IGN ");
                        _settextposition(9, 42);
                        break;
                     }
                     else
                     {
                        _settextcolor(3);
                        OfloIgn = 0;
                        _settextposition(9, 37);
                        _outtext(" O'FLO IGN ");
                        _settextposition(9, 42);
                        break;
                     }
                  case 11:
                     break;
                  case 13:
                     break;
                  case 15:
                     break;
               }
               break;
            case 2:
               break;
         }
      }
      switch(ch)
      {
         case 0x09:  /* Tab   */
            switch(bl)
            {
               case 0:
                  _settextposition(17, 42);
                  bl = 1;
                  break;
               case 1:
                  _settextposition(15, 64);
                  bl = 2;
                  break;
               case 2:
                  _settextposition(7, 10);
                  bl = 0;
                  break;
            }
            break;
         case 0x148: /* Up Arrow */
            tp =_gettextposition();
            if(tp.row < 8) break;
            switch(bl)
            {
               case 0:
                  if(tp.row < 16) tp.col = 10;
                  else tp.col = 14;
                  _settextposition(tp.row - 2, tp.col);
                  break;
               case 1:
                  _settextposition(tp.row - 2, tp.col);
                  break;
               case 2:
                  _settextposition(tp.row - 2, tp.col);
                  break;
            }
            break;
         case 0x150: /* Down Arrow  */
            tp = _gettextposition();
            if(tp.row > 16) break;
            switch(bl)
            {
               case 0:
                  if(tp.row < 12) tp.col = 10;
                  else tp.col = 14;
                  _settextposition(tp.row + 2, tp.col);
                  break;
               case 1:
                  _settextposition(tp.row + 2, tp.col);
                  break;
               case 2:
                  _settextposition(tp.row + 2, tp.col);
                  break;
            }
            break;
         case 0x14B: /* Left Arrow  */
         case 0x008: /* Backspace   */
            switch(bl)
            {
               case 0:
                  tp = _gettextposition();
                  if(tp.col < 11) break;
                  if(tp.row < 14)
                  {
                     if((tp.col == 14) || (tp.col == 19) || (tp.col == 23)) --tp.col;
                     _settextposition(tp.row, tp.col -1);
                     break;
                  }
                  else
                  {
                     if((tp.row > 14) && (tp.col > 14)) _settextposition(tp.row, tp.col - 1);
                  }
                  break;
               case 1:
                  break;
               case 2:
                  break;
            }
            break;
         case 0x14D: /* Right arrow */
         case ' ':   /* Space */
            switch(bl)
            {
               case 0:
                  tp = _gettextposition();
                  if(tp.col > 25) break;
                  if(tp.row < 14)
                  {
                     if((tp.col == 12) || (tp.col == 17) || (tp.col == 21)) ++tp.col;
                     _settextposition(tp.row, tp.col + 1);
                     break;
                  }
                  else if(tp.col < 17)
                  {
                     _settextposition(tp.row, tp.col + 1);
                     break;
                  }
                  else break;
               case 1:
                  break;
               case 2:
                  break;
            }
            break;
         case 0x147: /* Home  */
            tp = _gettextposition();
            switch(bl)
            {
               case 0:
                  if(tp.row < 14) tp.col = 10;
                  else tp.col = 14;
                  _settextposition(tp.row, tp.col);
                  break;
               case 1:
                  break;
               case 2:
                  break;
            }
         break;
         case 0x14F: /* End   */
            tp = _gettextposition();
            switch(bl)
            {
               case 0:
                  if(tp.row < 14) tp.col = 26;
                  else tp.col = 17;
                  _settextposition(tp.row, tp.col);
                  break;
               case 1:
                  break;
               case 2:
                  break;
            }
            break;
         case 'Q':
         case 'q':
            _settextcolor(txtcolor);
            _setbkcolor(bkcolor);
            _clearscreen(_GCLEARSCREEN);
            exit(0);
         default:
            break;
      }
   }
}

void LoadRegister(int r, int c, byte *R)
{
   int lop, lad, rop, rad, l1;

   _settextposition(r, c);
   _settextcolor(12);
   l1 = octin(1, '1');
   lop = (l1 << 6) + octin(2, '7');
   _outtext(" ");
   lad = octin(4, '7');
   _outtext(" ");
   rop = octin(3, '7');
   _outtext(" ");
   rad = octin(4, '7');
   R[0] = (char)((lop << 1) + (lad >> 11));
   R[1] = (char)((lad >> 3) & 0x00FF);
   R[2] = (char)((lad << 5) + (rop >> 4));
   R[3] = (char)((rop << 4) + (rad >> 8));
   R[4] = (char)(rad & 0x00FF);
}

int octin(int n, char ulch)
{
   char ch;
   int res, i;

   res = i = 0;
   while(i < n)
   {
oi:   while(!kbhit());
      ch = getch();
      if((ch == 0x08) && (i > 0))
      {
         tp = _gettextposition();
         _settextposition(tp.row, tp.col - 1);
         --i;
         goto oi;
      }
      if((ch < 0x30) || (ch > ulch))
      {
         goto oi;
      }
      sprintf(buffer, "%c", ch);
      _outtext(buffer);
      res = (res << 3) + (int)(ch & 0x07);
      ++i;
   }
   return(res);
}

void DoInstr(void)
{
   Multiply();
   _settextcolor(4);
   _settextposition(9, 14);
   HexToOct(&AC[0]);
   _settextposition(9, 33);
   HexToOct(&MQ[0]);
   _settextposition(9, 52);
   HexToOct(&NR[0]);
   getch();
   Divide();
   return;
}

void HexToOct(byte *R)
{
   int lop, lad, rop, rad;

   lop = (int)(R[0] >> 1);
   lad = (int)(((((R[0] << 8) + R[1]) << 3) + (R[2] >> 5)) & 0x0FFF);
   rop = (int)(((R[2] << 4) + (R[3] >> 4)) & 0x01FF);
   rad = (int)(((R[3] << 8) + R[4]) & 0x0FFF);
   sprintf(buffer, "%03o %04o %03o %04o", lop, lad, rop, rad);
   _outtext(buffer);
}

void ShortRightArithmeticShift(void)
{
   int l;

   for(l = 4; l > 0; l--) AC[l] = (AC[l] >> 1) + (AC[l - 1] << 7);
   AC[0] = (AC[0] & 0x80) | (AC[0] >> 1);
}

void ClearMQ(void)
{
   int l;

   for(l = 0; l < 5; l++) MQ[l] = 0;
}

void ShortRightLogicalShift(void)
{
   int l;

   for(l = 4; l > 0; l--) AC[l] = (AC[l] >> 1) + (AC[l - 1] << 7);
   AC[0] >>= 1;
}

void LongLeftCircularShift(void)
{
   byte highbit;
   int l;

   highbit = AC[0] >> 7;
   for(l = 0; l < 4; l++) AC[l] = (AC[l] << 1) + (AC[l + 1] >> 7);
   AC[4] = (AC[4] << 1) + (MQ[0] >> 7);
   for(l = 0; l < 4; l++) MQ[l] = (MQ[l] << 1) + (MQ[l + 1] >> 7);
   MQ[4] = (MQ[4] << 1) + highbit;
}

void LongRightArithmeticShift(void)
{
   int l;

   for(l = 4; l > 0; l--) MQ[l] = (MQ[l] >> 1) + (MQ[l - 1] << 7);
   MQ[0] = ((MQ[0] & 0x7F) >> 1) + ((AC[4] & 0x01) << 6) + (AC[0] & 0x80);
   for(l = 4; l > 0; l--) AC[l] = (AC[l] >> 1) + (AC[l - 1] << 7);
   AC[0] = (AC[0] & 0x80) | (AC[0] >> 1);
}

void LongLeftArithmeticShift(void)
{
   int l;

   for(l = 0; l < 4; l++) AC[l] = (AC[l] << 1) + (AC[l + 1] >> 7);
   AC[4] = (AC[4] << 1) + ((MQ[0] & 0x40) >> 6);
   MQ[0] = (MQ[0] &0x80) + ((MQ[0] << 1) & 0x7F) + (MQ[1] >> 7);
   for(l = 1; l < 4; l++) MQ[l] = (MQ[l] << 1) + (MQ[l + 1] >> 7);
   MQ[4] = MQ[4] << 1;
}

void OnesComplement(byte *R)
{
   int l;

   for(l = 0; l < 5; l++) R[l] ^= 0xFF;
}

void Multiply(void)
{
   int l, cflag = 0;
   byte MQsign;

   MQsign = MQ[0] >> 7;
   for(l = 0; l < 39; l++)
   {
      OV = ACC = 0;
      if((MQ[4] & 0x01) == 1) AddNRtoAC();
      LongRightArithmeticShift();
      if(OV == 1) AC[0] = (AC[0] & 0x7F) + (ACC << 7);
   }
   if(MQsign == 1)
   {
      ComplementNRtoTNR();
      AddTNRtoAC();
   }
   MQ[0] &= 0x7F;
}

void AddNRtoAC(void)
{
   int l, carry, ACsign, NRsign, temp;

   carry = 0;
   ACsign = AC[0] >> 7;
   NRsign = NR[0] >> 7;
   for(l = 4; l >= 0; l--)
   {
      temp = AC[l] + NR[l] + carry;
      AC[l] = (byte)(temp & 0x00FF);
      if((temp >> 8) > 0) carry = 1;
      else carry = 0;
   }
   ACC = carry;
   if((ACsign == NRsign) && (ACsign != (AC[0] >> 7))) OV = 1;
   else OV = 0;
}

void Complement(byte *R)
{
   int l, carry, temp;

   carry = 1;
   for(l = 4; l >= 0; l--)
   {
      temp = (int)((R[l] ^ 0xFF) + carry);
      R[l] = (byte)(temp & 0x00FF);
      if((temp >> 8) > 0) carry = 1;
      else carry = 0;
   }
}

void Divide(void)
{
   int l, f;

   ComplementNRtoTNR();
   if((NR[0] >> 7) != (AC[0] >> 7))
   {
      MQ[0] |= 0x80;
      AddNRtoAC();
   }
   else MQ[0] &= 0x7F;
   LongLeftArithmeticShift();
   for(l = 0; l < 39; l++)
   {
      AddTNRtoAC();
      if((AC[0] >> 7) == (NR[0] >> 7)) f = 1;
      else
      {
         f = 0;
         AddNRtoAC();
      }
      LongLeftArithmeticShift();
      MQ[4] += f;
   }
   ShortRightArithmeticShift();
}

void ComplementNRtoTNR(void)
{
   int l, carry, temp;

   carry = 1;
   for(l = 4; l >= 0; l--)
   {
      temp = (int)((NR[l] ^ 0xFF) + carry);
      TNR[l] = (byte)(temp & 0x00FF);
      if((temp >> 8) > 0) carry = 1;
      else carry = 0;
   }
}

void AddTNRtoAC(void)
{
   int l, carry, ACsign, TNRsign, temp;

   carry = 0;
   ACsign = AC[0] >> 7;
   TNRsign = NR[0] >> 7;
   for(l = 4; l >= 0; l--)
   {
      temp = (int)(AC[l] + TNR[l] + carry);
      AC[l] = (byte)(temp & 0x00FF);
      if((temp >> 8) > 0) carry = 1;
      else carry = 0;
   }
   ACC = carry;
   if((ACsign == TNRsign) && (ACsign != (AC[0] >> 7))) OV = 1;
   else OV = 0;
}

void ClearAC(void)
{
   int l;

   for(l = 0; l < 5; l++) AC[l] = 0;
}
