/* "@(#)ioctl.h	5.2	7/2/86" */
/* THIS HEADER FILE CONTAINS RIDGE SPECIFIC INFORMATION */

/*
 * Ioctl definitions
 */

#include <sys/ttychars.h>
#include <sys/ttydev.h>

#ifndef	_IOCTL_
#define	_IOCTL_

/*
 * tty ioctl commands
 */

#define	TIOCGETD	BSD_TIOCGETD	/* get line discipline */
#define	TIOCSETD	BSD_TIOCSETD	/* set line discipline */
#define	TIOCHPCL	BSD_TIOCHPCL	/* hang up on last close */
#define	TIOCMODG	BSD_TIOCMODG	/* get modem control state */
#define	TIOCMODS	BSD_TIOCMODS	/* set modem control state */
#define		TIOCM_LE	BSD_TIOCM_LE	/* line enable */
#define		TIOCM_DTR	BSD_TIOCM_DTR	/* data terminal ready */
#define		TIOCM_RTS	BSD_TIOCM_RTS	/* request to send */
#define		TIOCM_ST	BSD_TIOCM_ST	/* secondary transmit */
#define		TIOCM_SR	BSD_TIOCM_SR	/* secondary receive */
#define		TIOCM_CTS	BSD_TIOCM_CTS	/* clear to send */
#define		TIOCM_CAR	BSD_TIOCM_CAR	/* carrier detect */
#define		TIOCM_CD	BSD_TIOCM_CD	
#define		TIOCM_RNG	BSD_TIOCM_RNG	/* ring */
#define		TIOCM_RI	BSD_TIOCM_RI	
#define		TIOCM_DSR	BSD_TIOCM_DSR	/* data set ready */
#define	TIOCGETP	BSD_TIOCGETP	/* get parameters -- gtty */
#define	TIOCSETP	BSD_TIOCSETP	/* set parameters -- stty */
#define	TIOCSETN	BSD_TIOCSETN	/* as above, but no flushtty */
#define	TIOCEXCL	BSD_TIOCEXCL	/* set exclusive use of tty */
#define	TIOCNXCL	BSD_TIOCNXCL	/* reset exclusive use of tty */
#define	TIOCFLUSH	BSD_TIOCFLUSH	/* flush buffers */
#define	TIOCSETC	BSD_TIOCSETC	/* set special characters */
#define	TIOCGETC	BSD_TIOCGETC	/* get special characters */
#define		TANDEM		BSD_TANDEM		/* send stopc on out q full */
#define		CBREAK		BSD_CBREAK		/* half-cooked mode */
#define		LCASE		BSD_LCASE		/* simulate lower case */
#define		ECHO		BSD_ECHO		/* echo input */
#define		CRMOD		BSD_CRMOD		/* map \r to \r\n on output */
#define		RAW		BSD_RAW		/* no i/o processing */
#define		ODDP		BSD_ODDP		/* get/send odd parity */
#define		EVENP		BSD_EVENP		/* get/send even parity */
#define		ANYP		BSD_ANYP		/* get any parity/send none */
#define		NLDELAY		BSD_NLDELAY		/* \n delay */
#define			NL0	BSD_NL0	
#define			NL1	BSD_NL1	/* tty 37 */
#define			NL2	BSD_NL2	/* vt05 */
#define			NL3	BSD_NL3	
#define		TBDELAY		BSD_TBDELAY		/* horizontal tab delay */
#define			TAB0	BSD_TAB0	
#define			TAB1	BSD_TAB1	/* tty 37 */
#define			TAB2	BSD_TAB2	
#define		XTABS		BSD_XTABS		/* expand tabs on output */
#define		CRDELAY		BSD_CRDELAY		/* \r delay */
#define			CR0	BSD_CR0	
#define			CR1	BSD_CR1	/* tn 300 */
#define			CR2	BSD_CR2	/* tty 37 */
#define			CR3	BSD_CR3	/* concept 100 */
#define		VTDELAY		BSD_VTDELAY		/* vertical tab delay */
#define			FF0	BSD_FF0	
#define			FF1	BSD_FF1	/* tty 37 */
#define		BSDELAY		BSD_BSDELAY		/* \b delay */
#define			BS0	BSD_BS0	
#define			BS1	BSD_BS1	
#define 	ALLDELAY	BSD_ALLDELAY	
#define		CRTBS		BSD_CRTBS		/* do backspacing for crt */
#define		PRTERA		BSD_PRTERA		/* \ ... / erase */
#define		CRTERA		BSD_CRTERA		/* " \b " to wipe out char */
#define		TILDE		BSD_TILDE		/* hazeltine tilde kludge */
#define		MDMBUF		BSD_MDMBUF		/* start/stop output on carrier intr */
#define		LITOUT		BSD_LITOUT		/* literal output */
#define		TOSTOP		BSD_TOSTOP		/* SIGSTOP on background output */
#define		FLUSHO		BSD_FLUSHO		/* flush output to terminal */
#define		NOHANG		BSD_NOHANG		/* no SIGHUP on carrier drop */
#define		L001000		BSD_L001000		
#define		CRTKIL		BSD_CRTKIL		/* kill line with " \b " */
#define		L004000		BSD_L004000		
#define		CTLECH		BSD_CTLECH		/* echo control chars as ^X */
#define		PENDIN		BSD_PENDIN		/* tp->t_rawq needs reread */
#define		DECCTQ		BSD_DECCTQ		/* only ^Q starts after ^S */
#define		NOFLSH		BSD_NOFLSH		/* no output flush on signal */
/* locals, from 127 down */
#define	TIOCLBIS	BSD_TIOCLBIS	/* bis local mode bits */
#define	TIOCLBIC	BSD_TIOCLBIC	/* bic local mode bits */
#define	TIOCLSET	BSD_TIOCLSET	/* set entire local mode word */
#define	TIOCLGET	BSD_TIOCLGET	/* get local modes */
#define		LCRTBS		BSD_LCRTBS		
#define		LPRTERA		BSD_LPRTERA		
#define		LCRTERA		BSD_LCRTERA		
#define		LTILDE		BSD_LTILDE		
#define		LMDMBUF		BSD_LMDMBUF		
#define		LLITOUT		BSD_LLITOUT		
#define		LTOSTOP		BSD_LTOSTOP		
#define		LFLUSHO		BSD_LFLUSHO		
#define		LNOHANG		BSD_LNOHANG		
#define		LCRTKIL		BSD_LCRTKIL		
#define		LCTLECH		BSD_LCTLECH		
#define		LPENDIN		BSD_LPENDIN		
#define		LDECCTQ		BSD_LDECCTQ		
#define		LNOFLSH		BSD_LNOFLSH		
#define	TIOCSBRK	BSD_TIOCSBRK	/* set break bit */
#define	TIOCCBRK	BSD_TIOCCBRK	/* clear break bit */
#define	TIOCSDTR	BSD_TIOCSDTR	/* set data terminal ready */
#define	TIOCCDTR	BSD_TIOCCDTR	/* clear data terminal ready */
#define	TIOCGPGRP	BSD_TIOCGPGRP	/* get pgrp of tty */
#define	TIOCSPGRP	BSD_TIOCSPGRP	/* set pgrp of tty */
#define	TIOCSLTC	BSD_TIOCSLTC	/* set local special chars */
#define	TIOCGLTC	BSD_TIOCGLTC	/* get local special chars */
#define	TIOCOUTQ	BSD_TIOCOUTQ	/* output queue size */
#define	TIOCSTI		BSD_TIOCSTI		/* simulate terminal input */
#define	TIOCNOTTY	BSD_TIOCNOTTY	/* void tty association */
#define	TIOCPKT		BSD_TIOCPKT		/* pty: set/clear packet mode */
#define		TIOCPKT_DATA		BSD_TIOCPKT_DATA		/* data packet */
#define		TIOCPKT_FLUSHREAD	BSD_TIOCPKT_FLUSHREAD	/* flush packet */
#define		TIOCPKT_FLUSHWRITE	BSD_TIOCPKT_FLUSHWRITE	/* flush packet */
#define		TIOCPKT_STOP		BSD_TIOCPKT_STOP		/* stop output */
#define		TIOCPKT_START		BSD_TIOCPKT_START		/* start output */
#define		TIOCPKT_NOSTOP		BSD_TIOCPKT_NOSTOP		/* no more ^S, ^Q */
#define		TIOCPKT_DOSTOP		BSD_TIOCPKT_DOSTOP		/* now do ^S ^Q */
#define	TIOCSTOP	BSD_TIOCSTOP	/* stop output, like ^S */
#define	TIOCSTART	BSD_TIOCSTART	/* start output, like ^Q */
#define	TIOCMSET	BSD_TIOCMSET	/* set all modem bits */
#define	TIOCMBIS	BSD_TIOCMBIS	/* bis modem bits */
#define	TIOCMBIC	BSD_TIOCMBIC	/* bic modem bits */
#define	TIOCMGET	BSD_TIOCMGET	/* get all modem bits */
#define	TIOCREMOTE	BSD_TIOCREMOTE	/* remote input editing */

#define	OTTYDISC	BSD_OTTYDISC	/* old, v7 std tty driver */
#define	NETLDISC	BSD_NETLDISC	/* line discip for berk net */
#define	NTTYDISC	BSD_NTTYDISC	/* new tty discipline */
#define	TABLDISC	BSD_TABLDISC	/* hitachi tablet discipline */
#define	NTABLDISC	BSD_NTABLDISC	/* gtco tablet discipline */

#define	FIOCLEX		BSD_FIOCLEX	/* set close on exec */
#define	FIONCLEX	BSD_FIONCLEX	/* reset close on exec */
/* another local */
#define	FIONREAD	BSD_FIONREAD	/* get # bytes to read */
#define	FIONBIO		BSD_FIONBIO	/* set/clear non-blocking i/o */
#define	FIOASYNC	BSD_FIOASYNC	/* set/clear async i/o */
#define	FIOSETOWN	BSD_FIOSETOWN	/* set owner */
#define	FIOGETOWN	BSD_FIOGETOWN	/* get owner */

/* socket i/o controls */
#define	SIOCSHIWAT	BSD_SIOCSHIWAT	/* set high watermark */
#define	SIOCGHIWAT	BSD_SIOCGHIWAT	/* get high watermark */
#define	SIOCSLOWAT	BSD_SIOCSLOWAT	/* set low watermark */
#define	SIOCGLOWAT	BSD_SIOCGLOWAT	/* get low watermark */
#define	SIOCATMARK	BSD_SIOCATMARK	/* at oob mark? */
#define	SIOCSPGRP	BSD_SIOCSPGRP	/* set process group */
#define	SIOCGPGRP	BSD_SIOCGPGRP	/* get process group */

#define	SIOCADDRT	BSD_SIOCADDRT	/* add route */
#define	SIOCDELRT	BSD_SIOCDELRT	/* delete route */
#define	SIOCGNETTAB	ROS_SIOCGNETTAB	/* get network tables */

#define	SIOCSIFADDR	BSD_SIOCSIFADDR	/* set ifnet address */
#define	SIOCGIFADDR	BSD_SIOCGIFADDR	/* get ifnet address */
#define	SIOCSIFDSTADDR	BSD_SIOCSIFDSTADDR	/* set p-p address */
#define	SIOCGIFDSTADDR	BSD_SIOCGIFDSTADDR	/* get p-p address */
#define	SIOCSIFFLAGS	BSD_SIOCSIFFLAGS	/* set ifnet flags */
#define	SIOCGIFFLAGS	BSD_SIOCGIFFLAGS	/* get ifnet flags */
#define	SIOCGIFCONF	BSD_SIOCGIFCONF	/* get ifnet list */
#endif
