/*"@(#)cpu_data.h	5.2	6/18/86"*/

/*
 * Definition of structure returned by GetPerfData.  GetPerfData requires
 * that the block be aligned on a page boundary.
 */
#define MaxKCalls 256
typedef struct CDB {
  int KCalls [MaxKCalls];
  int Align;
  int IllInstr;
  int FetchParity;
  int ExeParity;
  int PageFault;
  int KernVio;
  int CheckTrap;
  int TrapTrap;
  int ExtInterrupt;
  int Switch0;
  int PowerFail;
  int PowerOK;
  int Timer1;
  int Timer2;
  int MaxProcs;
  int NumProcs;
  int MemPages;
  int VRTHash;
  int ContextSwitch;
  int Uptime;
  int IdleTime;
  int VMMMsgs;
  int SharingTries;
  int SharingWins;
  double LoadAverages[3];
  int VRTMax;
  int VRTMin;
  int VRTAvg;
  int MachineId;
  int HardwareFeatures;
  int MicroCodeVersion;
} CDB;

/*
 * Bit masks for things in the HardwareFeatures word
 */
#define HdwFtMCopyOnWrite 0x001
#define HdwFtMEFltPt      0x002
#define HdwFtMNewVRT      0x004
#define HdwFtMHeadwall    0x008
