/* "@(#)driverconf.h	5.1	6/10/86" */

/* values for the Access field in File Descriptor, from <fcntl.h> */
#define AcRead        	0x00000000
#define AcWrite       	0x00000001
#define AcReadWrite   	0x00000002
#define AcRWMask   	0x00000003
#define AcNoDelay     	0x00000004   /* Return immediately if there are */
				     /* no bytes in input. It is valid only  */
			             /* on terminal reads */
#define AcAppend      	0x00000008   /* Set file pointer to the end of file */
				     /* prior to each write or after each open*/
#define AcAsync	    	0x00000010   /* SIGIO */
#define AcCreat	    	0x00000100   /* Create file */
#define AcTrunc	  	0x00000200   /* Open with truncation */
#define AcExcl	  	0x00000400   /* Exclusive open  mode */

#define AcCntlTty	0x00010000   /* New client to be the tty "controller"*/
#define AcSetCntl	0x20000000   /* Set control group for the device */
#define IsCons	  	0x40000000   /* New client is for console device */
#define AcForceCreate	0x80000000   /* Ignore all Ac modes on file access */

/* Request type values - order is important */
#define OPEN	0
#define CLOSE	1
#define SELECT  2
#define READ 	3
#define WRITE 	4
#define IOCTL   5
#define LSEEK   6
#define UNLINK  7
#define INIT    8
#define NUMREQS 9	/* number of request types */

/* Special Key events */
#define DELETE		0
#define QUIT		1
#define SUSP  		2
#define DSUSP 		3
#define SIGIO 		4
#define WINDKILL   	5
#define WINDCHG   	6
#define HANGUP    	7
#define CARRIER   	8
#define PSEUDO   	9

/* Interrupt IDs */
#define HARDWARE_INTR	0
#define TIMER_INTR	1

/* domains */
#define ROS 0
#define ATT 1
#define BSD 2

#define FREAD 1			/* select flag for READ */
#define FWRITE 2		/* select flag for WRITE */

/* values for the cap field in the u_dev structure */
#define D_MANAGE_NAMES 	1 	/* driver manages object names */
#define D_REQUIRE_NAMES	2
#define D_SLOW_DEVICE	4	/* I/O can be interrupted */
#define D_IS_TTY	8	/* this is a tty driver */

#define BytesPerPage  4096 /* page size */

#define ErDelayed 0x00010000	/* typically OR'd with other errors */

typedef union ros_page
{
    double  Alignment [BytesPerPage/sizeof(double)];
    Byte    B [BytesPerPage];
    union ros_page  *Link;
} Page, *PPage;

typedef struct
    {
	Byte 	major;
	Byte	subUnits;
	Byte	cap;
	Byte 	*minors;
    } u_dev;

typedef struct file_descriptor
{
    int Unit;			     /* device major/minor */
    int Access;			     /* access modes as specified in open */
    int FileCursor;		     /* read/write start from here */
    char *driverpool;		     /* driver allocated buffer */
    struct file_descriptor *FList;   /* file descriptor list */
} FileDescriptor, *PFileDescriptor;

/* ioctl command format from <sys/driverMsgs.h> and <ros/ioctl.h> */
typedef struct 
{
    unsigned cmd_in     :1;	     /* 1 = input data by ref */
    unsigned cmd_out    :1;    	     /* 1 = output data by ref */
    unsigned cmd_format :1;    	     /* 1 = new ioctl format   */
    unsigned cmd_page   :1;    	     /* 1 = page sized argument*/
    unsigned cmd_free   :5;    	     /* unused, set to 0       */
    unsigned cmd_size   :7;    	     /* size of argument < 128 */
    unsigned cmd_char   :8;  	     /* char code for cmd type */
    unsigned cmd_num    :8;    	     /* command number         */
} ioctl_command;

typedef struct
{
	int	(*l_testq)();
	int	(*l_wakeup)();
	int	(*l_signal)();
	int	(*l_getdata)();
	int	(*l_fixpage)();
	int	(*l_freepage)();
	int	(*l_realaddr)();
	int	(*l_settimer)();
	int	(*l_resettimer)();
	int	(*l_trace)();
} Libsw;

typedef struct
{
	u_dev 	*units;
	int 	num_intrp;
	int	(*d_init)();
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_select)();
	int	(*d_read)();
	int	(*d_write)();
	int	(*d_ioctl)();
	int	(*d_hintrp)();
	int	(*d_lseek)();
	int	(*d_unlink)();
} Devsw;
