/* "@(#)mtio.h	5.1	6/10/86" */

#ifndef _ROS_MTIO_
#define _ROS_MTIO_

/* structure for MTIOCTOP - mag tape op command */
struct	mtop	{
#ifdef ridge
	int	mt_op;		/* operations defined below */
#else
	short	mt_op;		/* operations defined below */
#endif
	daddr_t	mt_count;	/* how many of them */
};

/* structure for MTIOCGET - mag tape get status command */

struct	mtget	{
#ifdef ridge
	short	mt_type;	/* type of magtape device */
/* the following two registers are grossly device dependent */
	int	mt_dsreg;	/* ``drive status'' register */
	int	mt_erreg;	/* ``error'' register */
/* end device-dependent registers */
	int	mt_resid;	/* residual count */
#else
	short	mt_type;	/* type of magtape device */
/* the following two registers are grossly device dependent */
	short	mt_dsreg;	/* ``drive status'' register */
	short	mt_erreg;	/* ``error'' register */
/* end device-dependent registers */
	short	mt_resid;	/* residual count */
#endif
/* the following two are not yet implemented */
	daddr_t	mt_fileno;	/* file number of current position */
	daddr_t	mt_blkno;	/* block number of current position */
/* end not yet implemented */
};

#endif

#ifndef _ROS_MT_CONSTS_
#define _ROS_MT_CONSTS_

/*
 * Constants for mt_op
 */

#define BSD_MTWEOF	0	/* write an end-of-file record */
#define BSD_MTFSF	1	/* forward space file */
#define BSD_MTBSF	2	/* backward space file */
#define BSD_MTFSR	3	/* forward space record */
#define BSD_MTBSR	4	/* backward space record */
#define BSD_MTREW	5	/* rewind */
#define BSD_MTOFFL	6	/* rewind and put the drive offline */
#define BSD_MTNOP	7	/* no operation, sets status only */
#ifdef ridge
#define BSD_MTHSPD	8	/* set high speed */
#define BSD_MTLSPD	9	/* set low speed */
#endif

/*
 * Constants for mt_type byte
 */

#define	BSD_MT_ISTS	0x01		
#define	BSD_MT_ISHT	0x02		
#define	BSD_MT_ISTM	0x03		
#define	BSD_MT_ISMT	0x04		
#define	BSD_MT_ISUT	0x05		
#define	BSD_MT_ISCPC	0x06	
#define	BSD_MT_ISAR	0x07		
#ifdef ridge
#define BSD_MT_ISCY	0x08
#endif

#define	BSD_DEFTAPE	"/dev/rmt12"

#endif
