/* "@(#)scsi.data.h	5.1	6/10/86" */
/*
** Some commands return information.  Structures for this information
** are defined below.
*/

/*
** 'read capacity' command response
*/
typedef struct
    {
    Byte	LBAHi;		/* 4 bytes of Last Logical Block Address */
    Byte	LBAHiMid;
    Byte	LBALowMid;
    Byte	LBALow;
    Byte	LBLHi;		/* 4 bytes of Block Length */
    Byte	LBLHiMid;
    Byte	LBLLowMid;
    Byte	LBLLow;
    }  tReadCapData;


/*
** 'inquiry' command response
*/
typedef struct
    {
    Byte	PeriphDevType;	/* See below for enumeration */
    unsigned	RMB  : 1;	/* Removable Medium Bit */
    unsigned	TypeQual  : 7;	/* Device Type Qualifier */
    unsigned	Resvd1  : 2;
    unsigned	ECMA  : 3;	/* European Computer Manufacturing Version */
    unsigned	ANSI  : 3;	/* ANSI Version */
    Byte	Resvd2;
    Byte	AddLength;	/* # bytes of additional vendor unique data */
    Byte	VendorUnique;	/* The vendor unique bytes live here */
    }  tInquiryData;
/*
  Definitions for the PeriphDevType field
*/
#define PDTDirect	0x00
#define PDTSequential	0x01
#define PDTPrinter	0x02
#define PDTProcessor	0x03
#define PDTWrite1ReadN	0x04
#define PDTReadOnly	0x05
#define PDTLUNAbsent	0x7f


