/* "@(#)socket.h	5.1	6/10/86" */

#ifndef _ROS_SOCKET_
#define _ROS_SOCKET_

/*
 * Address families.
 */
#ifdef ridge
#define	BSD_AF_UNSPEC	0		/* unspecified */
#define	BSD_AF_UNIX	1		/* local to host (pipes, portals) */
#define	BSD_AF_INET	2		/* internetwork: UDP, TCP, etc. */
#define	BSD_AF_IMPLINK	3		/* arpanet imp addresses */
#define	BSD_AF_PUP	4		/* pup protocols: e.g. BSP */
#define	BSD_AF_CHAOS	5		/* mit CHAOS protocols */
#define	BSD_AF_NS	6		/* XEROX NS protocols */
#define	BSD_AF_NBS	7		/* nbs protocols */
#define	BSD_AF_ECMA	8		/* european computer manufacturers */
#define	BSD_AF_DATAKIT	9		/* datakit protocols */
#define	BSD_AF_CCITT	10		/* CCITT protocols, X.25 etc */
#define	BSD_AF_SNA	11		/* IBM SNA */

#define	BSD_AF_MAX	12
#else
#define	AF_UNSPEC	0		/* unspecified */
#define	AF_UNIX		1		/* local to host (pipes, portals) */
#define	AF_INET		2		/* internetwork: UDP, TCP, etc. */
#define	AF_IMPLINK	3		/* arpanet imp addresses */
#define	AF_PUP		4		/* pup protocols: e.g. BSP */
#define	AF_CHAOS	5		/* mit CHAOS protocols */
#define	AF_NS		6		/* XEROX NS protocols */
#define	AF_NBS		7		/* nbs protocols */
#define	AF_ECMA		8		/* european computer manufacturers */
#define	AF_DATAKIT	9		/* datakit protocols */
#define	AF_CCITT	10		/* CCITT protocols, X.25 etc */
#define	AF_SNA		11		/* IBM SNA */

#define	AF_MAX		12
#endif

/*
 * Structure used by kernel to store most
 * addresses.
 */
struct sockaddr {
#ifdef ridge
	ushort	sa_family;		/* address family */
#else
	u_short	sa_family;		/* address family */
#endif
	char	sa_data[14];		/* up to 14 bytes of direct address */
};

#endif
