/* "@(#)termio.h	5.1	6/10/86" */

#ifndef _TERMIO_
#define _TERMIO_

#define	ATT_NCC	8

/* control characters */
#define	ATT_VINTR	0
#define	ATT_VQUIT	1
#define	ATT_VERASE	2
#define	ATT_VKILL	3
#define	ATT_VEOF	4
#define	ATT_VEOL	5
#define	ATT_VEOL2	6
#define ATT_VSWTCH      7
#define	ATT_VMIN	4
#define	ATT_VTIME	5

#ifdef ridge
#define	ATT_VSTART	0
#define	ATT_VSTOP	1
#define	ATT_VSUSPC	2
#define	ATT_VDSUSPC	3	
#define	ATT_VRPRNTC	4
#define	ATT_VWERASC	5
#define	ATT_VFLUSHO	6
#define	ATT_VLNEXTC	7
#endif

#define	ATT_CNUL	0
#define	ATT_CDEL	0377
/* default control chars */
#define	ATT_CESC	'\\'
#define	ATT_CINTR	0177	/* DEL */
#define	ATT_CQUIT	034	/* FS, cntl | */
#ifdef ridge
#define	ATT_CERASE	'\b'	/* control-H */
#define	ATT_CKILL	030	/* control-X */
#else
#define	ATT_CERASE	'#'
#define	ATT_CKILL	'@'
#endif
#define	ATT_CEOF	04	/* cntl	d */
#define	ATT_CSTART	021	/* cntl	q */
#define	ATT_CSTOP	023	/* cntl	s */
#define ATT_CSWTCH	032	/* cntl z */
#define ATT_CNSWTCH	0


/* input modes */
#define	ATT_IGNBRK	0000001
#define	ATT_BRKINT	0000002
#define	ATT_IGNPAR	0000004
#define	ATT_PARMRK	0000010
#define	ATT_INPCK	0000020
#define	ATT_ISTRIP	0000040
#define	ATT_INLCR	0000100
#define	ATT_IGNCR	0000200
#define	ATT_ICRNL	0000400
#define	ATT_IUCLC	0001000
#define	ATT_IXON	0002000
#define	ATT_IXANY	0004000
#define	ATT_IXOFF	0010000

/* output modes	*/
#define	ATT_OPOST	0000001
#define	ATT_OLCUC	0000002
#define	ATT_ONLCR	0000004
#define	ATT_OCRNL	0000010
#define	ATT_ONOCR	0000020
#define	ATT_ONLRET	0000040
#define	ATT_OFILL	0000100
#define	ATT_OFDEL	0000200
#define	ATT_NLDLY	0000400
#define	ATT_NL0		0
#define	ATT_NL1		0000400
#define	ATT_CRDLY	0003000
#define	ATT_CR0		0
#define	ATT_CR1		0001000
#define	ATT_CR2		0002000
#define	ATT_CR3		0003000
#define	ATT_TABDLY	0014000
#define	ATT_TAB0	0
#define	ATT_TAB1	0004000
#define	ATT_TAB2	0010000
#define	ATT_TAB3	0014000
#define	ATT_BSDLY	0020000
#define	ATT_BS0		0
#define	ATT_BS1		0020000
#define	ATT_VTDLY	0040000
#define	ATT_VT0		0
#define	ATT_VT1		0040000
#define	ATT_FFDLY	0100000
#define	ATT_FF0		0
#define	ATT_FF1		0100000
#ifdef ridge
#define	ATT_OCRCRNL	0200000
#endif

/* control modes */
#ifdef ridge
#define	ATT_CBAUD	0000037
#else
#define	ATT_CBAUD	0000017
#endif
#define	ATT_B0		0
#define	ATT_B50		0000001
#define	ATT_B75		0000002
#define	ATT_B110	0000003
#define	ATT_B134	0000004
#define	ATT_B150	0000005
#define	ATT_B200	0000006
#define	ATT_B300	0000007
#define	ATT_B600	0000010
#define	ATT_B1200	0000011
#define	ATT_B1800	0000012
#define	ATT_B2400	0000013
#define	ATT_B4800	0000014
#define	ATT_B9600	0000015
#define	ATT_EXTA	0000016
#define	ATT_EXTB	0000017
#ifdef ridge
#define	ATT_B19200	0000020
#define	ATT_CSIZE	0000140
#define	ATT_CS5		0
#define	ATT_CS6		0000040
#define	ATT_CS7		0000100
#define	ATT_CS8		0000140
#define	ATT_CSTOPB	0000200
#define	ATT_CREAD	0000400
#define	ATT_PARENB	0001000
#define	ATT_PARODD	0002000
#define	ATT_HUPCL	0004000
#define	ATT_CLOCAL	0010000
#define	ATT_CAUTO	0020000		/* Auto	flow control */
#else
#define	ATT_CSIZE	0000060
#define	ATT_CS5		0
#define	ATT_CS6		0000020
#define	ATT_CS7		0000040
#define	ATT_CS8		0000060
#define	ATT_CSTOPB	0000100
#define	ATT_CREAD	0000200
#define	ATT_PARENB	0000400
#define	ATT_PARODD	0001000
#define	ATT_HUPCL	0002000
#define	ATT_CLOCAL	0004000
#define	ATT_LOBLK	0010000
#endif

/* line	discipline 0 modes */
#define	ATT_ISIG	0000001
#define	ATT_ICANON	0000002
#define	ATT_XCASE	0000004
#define	ATT_ECHO	0000010
#define	ATT_ECHOE	0000020
#define	ATT_ECHOK	0000040
#define	ATT_ECHONL	0000100
#define	ATT_NOFLSH	0000200
#ifdef ridge
#define	ATT_LINTRUP	0000400
#define	ATT_ECHOI	0001000
#define	ATT_OFLUSH	0002000
#define	ATT_XCLUDE 	0004000
#define	ATT_CBREAK 	0010000
#define	ATT_RAW 	0020000
#define	ATT_XCTRLECH	0040000
#define	ATT_XCRTBS 	0100000

#define	ATT_SSPEED	ATT_B9600	/* default speed */
#else
#define	ATT_SSPEED	ATT_B300	/* default speed */
#endif

/*
 * Ioctl control packet
 */
struct termio {
	int		c_version;	/* termio structure version */
	int		c_iflag;	/* input modes */
	int		c_oflag;	/* output modes	*/
	int		c_cflag;	/* control modes */
	int		c_lflag;	/* line	discipline modes */
	int		c_line;		/* line	discipline */
	int		c_numchr;	/* number of control chars following */
	unsigned char	c_cc[ATT_NCC];	/* control chars */
};

typedef  char bsdchars[ATT_NCC];

/*
 * Terminal types
 */
#define	ATT_TERM_NONE	0	/* tty */
#define	ATT_TERM_TEC	1	/* TEC Scope */
#define	ATT_TERM_V61	2	/* DEC VT61 */
#define	ATT_TERM_V10	3	/* DEC VT100 */
#define	ATT_TERM_TEX	4	/* Tektronix 4023 */
#define	ATT_TERM_D40	5	/* TTY Mod 40/1	*/
#define	ATT_TERM_H45	6	/* Hewlitt-Packard 45 */
#define	ATT_TERM_D42	7	/* TTY Mod 40/2B */

/*
 * Terminal flags
 */
#define	ATT_TM_NONE		0000	/* use default flags */
#define	ATT_TM_SNL		0001	/* special newline flag	*/
#define	ATT_TM_ANL		0002	/* auto	newline	on column 80 */
#define	ATT_TM_LCF		0004	/* last	col of last row	special	*/
#define	ATT_TM_CECHO	0010	/* echo	terminal cursor	control	*/
#define	ATT_TM_CINVIS	0020	/* do not send esc seq to user */
#define	ATT_TM_SET		0200	/* must	be on to set/res flags */

/*
 * structure of	ioctl arg for LDGETT and LDSETT
 */
struct	termcb	{
	char	st_flgs;	/* term	flags */
	char	st_termt;	/* term	type */
	char	st_crow;	/* gtty	only - current row */
	char	st_ccol;	/* gtty	only - current col */
	char	st_vrow;	/* variable row	*/
	char	st_lrow;	/* last	row */
};

#endif
