/* "@(#)driverMsgs.h	5.1	6/9/86" */
/* driverMsgs.h */
/* Message definitions for Drivers ROS 3.4 release */

/* Requests from user monitor to driver */
#define MFDriverOpen  0 
#define MRDriverOpen  1   
#define MFDriverClose 2  
#define MRDriverClose 3    

/* #define MFDriverSpecKey 4 - obsolete */
/* #define MRDriverSpecKey 5 - obsolete */

#define MFDriverDelete  6
#define MRDriverDelete  7
#define MFInterruptIO   8
#define MRInterruptIO   9

/* #define MFCtrlWindow    10 - obsolete */
/* #define MRCtrlWindow    11 - obsolete */

#define MFDriverGetMode 12
#define MRDriverGetMode 13
#define MFDriverSetMode 14
#define MRDriverSetMode 15
#define MFControlGroup  18
#define MRControlGroup  19
#define MFControlTTYFlag	20	/* only for TTY drivers */
#define MRControlTTYFlag	21
#define MFSetNoRW		28 
#define MRSetNoRW		29 
#define MFSetClientGroup	32
#define MRSetClientGroup	33
#define MFBackgroundUMReply	38
#define MFDriverDup  		164
#define MRDriverDup  		165
#define MFSelect        	204
#define MRSelect        	205


/* From Driver to User Monitor */
/* These do not always have responses */
#define MFDriverKill		16
#define MFDriverBackground	22
#define MFDriverCarrier		24
#define MFDriverSpecEvent	26
#define MFDriverKillGroup	30 
#define MFNotifyDeath		34

/* from user process to driver */
#define MFReadBlock   72
#define MRReadBlock   73 
#define MFWriteBlock  74
#define MRWriteBlock  75
#define MFReadChar    76
#define MRReadChar    77
#define MFWriteChar   78
#define MRWriteChar   79
#define MFIOControl   80  
#define MRIOControl   81
#define MFResynch    142
#define MRResynch    143
#define MFLseek	     240
#define MRLseek	     241

/* timer codes */
#define MFSetTime     150
#define MRSetTime     151
#define MFCancelTime  152
#define MRCancelTime  153
#define MFSetInterval 154
#define MRSetInterval 155
#define MFResetTime   156
#define MRResetTime   157

/* Directory Codes */
#define MFAddDevice   4
#define MRAddDevice   5
#define MFRemDevice   6
#define MRRemDevice   7
#define MFFindDevice  8
#define MRFindDevice  9

/* Startup Codes */
#define MFInit        112

/* from kernel */
#define MIOInterrupt	10

/* Standard IOControl Functions and replies */
#define WhoAreYou     0
#define IAmFileMgr    -2147483648

/* OS Types */
#define ROS 	0
#define ATT 	1
#define BSD	2

/* device type definition */
typedef struct
{
    Halfword res;
    Byte major;
    Byte minor;
} DevType;


/* Message Formats  */
typedef struct
  {                            /* Message Header                   */
    unsigned int RequestId :8;
    unsigned int OSType :3;
    unsigned int FormatVersion :5;
    unsigned int Funct :16;
  } MsgHdrType;

typedef struct  		/* Bad Message Format */
{
  MsgHdrType Header;
  int        handle;
  Error      status;
} BadReqType;

typedef struct  
{
  MsgHdrType Header;
  int        handle;
  Error      status;
} BadRepType;

typedef struct			/* default Message Format */
{
    MsgHdrType Header;
    int	i[MessageSize-1];
} Hdr;

typedef struct                  /* Open message */
  {
    MsgHdrType Header;
    DevType    deviceCode;   
    Halfword   flags;   
    Halfword   access;   
    Queue      interruptQ;     
    ProcessId  clientPId;  
    Queue      clientQ;  
    Queue      replyQ;  
    int        group_size; /* initial file size or client group */
  } OpenReqType;

typedef struct 
  {
    MsgHdrType Header;
    Error      status;  
    int        handle;  
    Link       clientLink;  
    int        mode; 
    int        group_allocSize; /* either control group or allocated file size */
    int        WindowNumber;  
  } OpenRepType;

typedef struct                  /* Close */
  {
    MsgHdrType Header;
    int        handle; 
    int        closeAbort;   
  } CloseReqType;

typedef struct    
  {
    MsgHdrType Header;
    Error      status;
  } CloseRepType;

typedef struct                  /* Delete */
  {
    MsgHdrType Header;
    DevType    deviceCode;   
    int        replyQ;   
    int        intQ;   
  } DeleteReqType;

typedef struct    
  {
    MsgHdrType Header;
    Error      status;
  } DeleteRepType;

typedef struct                  /* InterruptIO */
  {
    MsgHdrType Header;
    int        handle; 
  } InterruptReqType;

typedef struct    
  {
    MsgHdrType Header;
    Error      status;
  } InterruptRepType;

typedef struct                  /* GetMode */
  {
    MsgHdrType Header;
    int        handle; 
  } GetModeReqType;

typedef struct    
  {
    MsgHdrType Header;
    Error      status;
    int        flags;
  } GetModeRepType;

typedef struct                  /* SetMode */
  {
    MsgHdrType Header;
    int        handle; 
    int        flags;
  } SetModeReqType;

typedef struct    
  {
    MsgHdrType Header;
    Error      status;
    int        handle; 
  } SetModeRepType;

typedef struct		/* ControlGroup */
  {
    MsgHdrType Header;
    DevType    deviceCode;   
    int        window;
    int        flag;  /* 0 - get, 1- set */
    int        value; /* positive - group id, negative - process id */
  } ControlGroupReqType; 

typedef struct
  {
    MsgHdrType Header;
    int        status;
    int        value; /* same as above */
  } ControlGroupRepType;

typedef struct		/* Control TTY */
  {
    MsgHdrType Header;
    ProcessId  clientId;
    DevType    deviceCode;   
    int        windowId;	
    int        flag;
  } ControlTTYReqType;

typedef struct
  {
    MsgHdrType Header;
    int        status;
  } ControlTTYRepType;

typedef struct		/* Set No Read/Write */
  {
    MsgHdrType Header;
    DevType    deviceCode;   
    int        windowId;	
  } SetNoRWReqType;

typedef struct
  {
    MsgHdrType Header;
    int        status;
  } SetNoRWRepType;

typedef struct		/* Set Client Group */
  {
    MsgHdrType Header;
    ProcessId  clientId;
    DevType    deviceCode;   
    int        windowId;
    int        groupId;
  } SetGroupReqType;

typedef struct
  {
    MsgHdrType Header;
    int        status;
  } SetGroupRepType;

typedef struct		/* Driver Backround Response - no reply */
{
  MsgHdrType 	Header;
  int handle;
  int action; /* 0 - try again, 1 - continue or return error */
  int err;
} DriverBackRespType;

typedef struct 		/* Dup */
  {
    MsgHdrType  Header;
    Queue	dupClientQ;
    ProcessId	dupClientPId;
    Queue	dupUMRespQ;
    Queue	dupUMIntQ;
    int		dupHandle;
  } DriverDupReqType;

typedef struct
  {
    MsgHdrType	Header;
    Error	status;
    int		newHandle;
    Link	dupClientLink;
  } DriverDupRepType;

typedef struct		/* Select */
  {
    MsgHdrType 	Header;
    int 	handle;
    Halfword 	asynch;
    Halfword 	modeMask;
    int 	replyQ; /* Q to send response on - NOT same as replyQ in Open */
  } SelectReqType;

typedef struct
  {
    MsgHdrType 	Header;
    Error 	status;
    int 	replyMask;
    int 	handle;
    int 	clientPId;
  } SelectRepType;


/* Messages from Driver To User Monitor */
/* These messages do NOT have responses */

typedef struct		/* Driver Kill */
  {
    MsgHdrType Header;
    ProcessId  clientPId;  
    int        signalNum; /* ROS signal # */
    int        code;
  } DriverKillType;

typedef struct		/* Driver Kill Process Group */
  {
    MsgHdrType Header;
    ProcessId  clientPId;  
    int        signalNum; /* ROS signal # */
    int        code;
  } DriverKillGroupType;
    
typedef struct		/* Driver Backround */
  {
    MsgHdrType Header;
    int        event; /* 0-read, 1-write, 2-ioctl */
    int        groupId;
    int        code;
    ProcessId  clientId;
    int        UMHandle; /* same as in open reply */
  } DriverBackgroundType;

typedef struct		/* Driver Carrier */
  {
    MsgHdrType Header;
    DevType    deviceCode;   
  } DriverCarrierType;

typedef struct
  {
    MsgHdrType Header;
    int        event;
    int        ControlGroupId;
    int        code;
    DevType    deviceCode;
    int        windowId;
  } SpecialEventType;

/* special event codes are as follows: */
/* 0-interrupt, 1-quit, 2-suspend, 3-delayed suspend, */
/* 4-input available, 5-window kill, 6-window changed */
/* 7-carrier dropped. */


/* Messages from User Processes to Drivers */

typedef struct                  /* Read */
  {
    MsgHdrType Header;
    int        handle;
    int        fileCursor;
    int        length;
    int        pending;
    int	       offset;	/* not in message protocol! used internally by DI */
  } ReadReqType;

typedef struct  
  {
    MsgHdrType Header;
    int        handle;
    Error      status;
    int        actual;
    int        pending;
  } ReadRepType;

typedef struct                  /* Write */
  {
    MsgHdrType Header;
    int        handle;
    int        fileCursor;
    int        length;
    int        pending;
    int	       offset;	/* not in message protocol! used internally by DI */
  } WriteReqType;

typedef struct  
  {
    MsgHdrType Header;
    int        handle;
    Error      status;
    int        actual;
  } WriteRepType;

/* ioctl command format */
typedef struct 
  {
    int cmd_in 	:1;	/* 1 = input data by ref */
    int cmd_out	:1;     /* 1 = output data by ref */
    int cmd_format :1;  /* 1 = new ioctl format   */
    int cmd_page   :1;  /* 1 = page sized argument*/
    int cmd_free   :5;  /* unused, set to 0       */
    int cmd_size   :7;	/* size of argument < 128 */
    int cmd_char   :8;	/* char code for cmd type */
    int cmd_num	:8;     /* command number         */
  } ioctl_command;

typedef struct 
  {
    MsgHdrType Header;
    int        handle;
    ioctl_command IOCommand;
    int         value;
  }IOControlReqType;

typedef struct                 
  {
    MsgHdrType Header;
    int        handle;
    Error      status;    
    int        response;
  } IOControlRepType;

typedef struct
  {
    MsgHdrType Header;
    int        handle;
  } ResynchReqType;

typedef struct
  {
    MsgHdrType Header;
    int        handle;
    Error      status;
  } ResynchRepType;

typedef struct
  {
    MsgHdrType  Header;
    int		handle;
    int		offset;
    int		whence;
  } LseekReqType;

typedef struct
  {
    MsgHdrType  Header;
    int		handle;
    Error	status;
    int		pointer;
  } LseekRepType;


/* Timer Messages */

typedef struct                    /* Set Timer */
  {
    MsgHdrType Header;
    int        timeVal;
    int        timeId1;
    int        timeId2;
    Queue      replyQ;
  } SetTimeReqType;

typedef struct
  {
    MsgHdrType Header;
    Error      status;
    int        timeId1;
    int        timeId2;
  } SetTimeRepType;

typedef struct                    /* SetInterval */
  {
    MsgHdrType Header;
    int        timeVal;
    int        timeId1;
    int        timeId2;
    Queue      replyQ;
  } SetIntReqType;

typedef struct
  {
    MsgHdrType Header;
    Error      status;
    int        timeId1;
    int        timeId2;
  } SetIntRepType;

typedef struct                     /* Cancel Timer */
  {
    MsgHdrType Header;
    Queue      replyQ;
    int        timeId1;
    int        timeId2;
  } CancelReqType;

typedef struct
  {
    MsgHdrType Header;
    Error      status;
    int        timeVal;
  } CancelRepType;


/* DirMgr messages */
typedef struct                      /* Add Device */
  {
    MsgHdrType Header;
    DevType   deviceCode;
    ProcessId procId;
    Queue     devQ;
    Queue     devConQ;
    int       capabilities;
  } AddDeviceReqType;

typedef struct
  {
    MsgHdrType Header;
    Error      status;
  } AddDeviceRepType;

typedef struct                      /* Remove Device */
  {
    MsgHdrType Header;
    DevType   deviceCode;
    ProcessId procId;
    Queue     devQ;
  } RemDeviceReqType;

typedef struct
  {
    MsgHdrType Header;
    Error      status;
  } RemDeviceRepType;

typedef struct                      /* FindDevice */
  {
    MsgHdrType Header;
    DevType   deviceCode;
    ProcessId procId;
    Queue     devQ;
  } FindDeviceReqType;

typedef struct
  {
    MsgHdrType Header;
    Error      status;
    ProcessId  findDev;
  } FindDeviceRepType;


/* Kernel Intrrupt Message Format */

typedef struct
  {
      MsgHdrType Header;
      unsigned int   IOIntDevice;
      unsigned int   IOIR;
  } KernelReqType;
 
/* Init message from driver to Startup */

typedef struct                      /* Init Message */
  {
    MsgHdrType Header;
    int        status;
  } InitReqType;


/* One Big union of all messages */
typedef union Msg
{
    int    		m[MessageSize];
    double 		d[MessageSize/2];
    Hdr    		hdr;

	/* User Monitor to Driver */
    OpenReqType 	OpenRequest;
    OpenRepType 	OpenReply;
    CloseReqType 	CloseRequest;
    CloseRepType 	CloseReply;
    DeleteReqType 	DeleteRequest;
    DeleteRepType 	DeleteReply;
    InterruptReqType 	InterruptRequest;
    InterruptRepType 	InterruptReply;
    GetModeReqType 	GetModeRequest;
    GetModeRepType 	GetModeReply;
    SetModeReqType 	SetModeRequest;
    SetModeRepType 	SetModeReply;
    ControlGroupReqType ControlGroupRequest;
    ControlGroupRepType ControlGroupReply;
    ControlTTYReqType   ControlTTYRequest;
    ControlTTYRepType   ControlTTYReply;
    SetNoRWReqType      SetNoRWRequest;
    SetNoRWRepType      SetNoRWReply;
    SetGroupReqType     SetGroupRequest;
    SetGroupRepType     SetGroupReply;
    DriverBackRespType  DriverBackRequest;
    DriverDupReqType 	DriverDupRequest;
    DriverDupRepType 	DriverDupReply;
    SelectReqType 	SelectRequest;
    SelectRepType 	SelectReply;

	/* Driver to User Monitor */
    DriverCarrierType	DriverCarrierMsg;
    SpecialEventType	SpecEventMsg;
    DriverBackgroundType BackgroundMsg;
    DriverKillType      DriverKillMsg;
    DriverKillGroupType DriverKillGroupMsg;

	/* User Process to Driver */
    ReadReqType 	ReadRequest;
    ReadRepType 	ReadReply;
    WriteReqType 	WriteRequest;
    WriteRepType 	WriteReply;
    IOControlReqType 	IoctlRequest;
    IOControlRepType 	IoctlReply;
    ResynchReqType 	ResynchRequest;
    ResynchRepType 	ResynchReply;
    LseekReqType 	LseekRequest;
    LseekRepType 	LseekReply;

	/* Directory Manager Messages */
    AddDeviceReqType 	AddDeviceRequest;
    AddDeviceRepType 	AddDeviceReply;
    RemDeviceReqType 	RemDeviceRequest;
    RemDeviceRepType 	RemDeviceReply;
    FindDeviceReqType 	FindDeviceRequest;
    FindDeviceRepType 	FindDeviceReply;

	/* startup, kernel messages */
    InitReqType 	InitRequest;
    KernelReqType	KernelRequest;

	/* timer messages */
    SetTimeReqType	SetTimerRequest;
    SetTimeRepType	SetTimerReply;
    SetIntReqType	SetIntervalRequest;
    SetIntRepType	SetIntervalReply;
    CancelReqType	CancelRequest;
    CancelRepType	CancelReply;
} Msg;
