/* "@(#)errors.h	5.1	6/9/86" */

/* errors.h */
/* ROS error codes */

/* Errors */
#define ErOK            0
#define ErQueueFull     1
#define ErRcvrDead      2
#define ErInvLink       3
#define ErNotPageBound  4
#define ErNoPageRoom    5
#define ErNotPriv       6
#define ErPageSent      7
#define ErNoPageSent    8
#define ErQueueEmpty    9
#define ErEOF           14
#define ErTooManyLinks  19
#define ErTooManyQueues 20
#define ErTooManyPages  21
#define ErTooManyMessages 22
#define ErInvProc       23
#define ErInvQueue      24
#define ErNoProcBlock   25
#define ErNoFreeSegments  26
#define ErNoFreeQueues  27
#define ErNoFreeLinks   28
#define ErInvDevice     29
#define ErDeviceInUse   30
#define ErBadPCBPointer 31
#define ErBadSpecialPID 32
#define ErPageNotreserved 33
#define ErSpecialPIDInUse 34
#define ErInvSeg        35
#define ErMoreData      38

#define ErNoFreePages   102

/* Volume Manager Errors */
#define ErBadFileId     201
#define ErTooManyExts   202
#define ErInUse         204
#define ErNoExtBlk      205
#define ErVolumeIndexFull 206
#define ErBadAddress    207
#define ErVolumeFull    208
#define ErPageRequired  210
#define ErMultipleAllocation 211
#define ErFileBootable  212

/* Directory errors */
#define ErModDir        301
#define ErNoRoom        302
#define ErBadFileName   303
#define ErBadFileType   304
#define ErDupEntry      305
#define ErFileNotFound  306
#define ErDelimExpected 307
#define ErNotDirectory  308
#define ErBadRequest    309
#define ErBadString     310
#define ErPastRoot      311
#define ErTooManyLevels 312
#define ErDirNotEmpty   313
#define ErNoDeleteRoot  314
#define ErAlreadyConnected 315
#define ErConnectFull   316
#define ErCantOpenLink  317
#define ErCantCloseLink 318
#define ErNotConnected  319
#define ErNoDevice      320    /* no device manager found     */
#define ErDevice        321    /* device entry found in parse */
#define ErDevPresent    322    /* device already present in table */
#define ErTblFull       323    /* no more room for device entries */
#define ErLink          324
#define ErFoundMountedVol 332

/* User Monitor errors */
#define ErBadPID        401
#define ErOpenMode      402
#define ErBadLink       403
#define ErNoEquate      404
#define ErCantStart     405
#define ErAccess        406
#define ErCantModifyDir 407
#define ErBadFileSpace  408
#define ErNotOwner      409
#define ErNotReadable   410
#define ErNotWriteable  411
#define ErBadFileCursor 412
#define ErBadBlockLength  413
#define ErCantExtend    414
#define ErNotDataFault  415
#define ErBadPipeOperation 417
#define ErBadDataSpace  418
#define ErNoReaders     419
#define ErNoWriters     421
#define ErDriverFault   422
#define ErShortBlock    423
#define ErWouldBlock    424
#define ErFileIsLock    425
#define ErNotImplemented  499

/* IO errors */
#define ErNotOpen       500
#define ErFileStatus    501
#define ErNotAligned    502

/* driver errors */
#define ErNoUserMonitor      600
#define ErConflictingQueues  601
#define ErTooManyConnections 602
#define ErBadDevice          603
#define	ErDevInUse	     604
#define ErOutstandingOperation  605
#define ErIOcomplete         606
#define ErNotImpl            607
#define ErBadFunction        608
#define ErDeviceError	     609
#define ErNoSingleDens	     610
#define ErNoInterlace	     611
#define ErDirectoryFull      612
#define ErNameRequired       613
#define ErPageNeeded	     615
#define ErBadVersion	     616
#define ErNoClient	     617
#define ErIOIncomplete       619
#define ErBadResponse        699

/* filemgr errors */
#define ErBlockedIO          701
#define GETOK                702
#define ErManNDelSLoc        703	/* Mandatory set,O_NDELAY set and blocking lock */	
#define ErEnolck             704	/* full record locking tables */
#define ErEdeadlk            705	/* avoided deadlock situation */
