(* "@(#)kim.ext.h	5.2	2/16/87" *)
(* External Definitions *)

function AcquireDevice (
	Device	: IDeviceNumber;
	IntQ	: Queue
	) : Error; EXTERNAL;
function Activate(
	Who	: ProcessId
	) : Error; EXTERNAL;
function Arm(
	Q	: Queue
	) : Error; EXTERNAL;
function BlockLink (
	L	: Link
	) : Error; EXTERNAL;
function ChangeFile (
	pID	: ProcessID;
	seg	: SegmentSelector;
	fID	: FileID
	) : Error; EXTERNAL;
function CloseLink(
	Who	: ProcessId;
	L	: Link
	) : Error; EXTERNAL;
function CloseQueue(
	Who	: ProcessId;
	Q	: Queue
	) : Error; EXTERNAL;
function CopyFrom(
	Target	: ProcessId;
	Where	: VirtualAddress;
	MaxLen	: Integer;
    var Actual	: Integer
	) : Error; EXTERNAL;
function CopyTo(
	Target	: ProcessId;
	Where	: VirtualAddress;
	Maxlen	: Integer
	) : Error; EXTERNAL;
function CreateProcess(
	Code	: FileId;
	Data	: FileId;
	Queue	: FileId;
	PC	: ProgramCounter;
	Pri	: Priority;
	TBits	: TrapsBits;
    var	NewPId	: ProcessId
	) : Error; EXTERNAL;
function DeleteMessage(
	Q	: Queue
	) : Error; EXTERNAL;
function Disarm(
	Q	: Queue
	) : Error; EXTERNAL;
function Fix(
	Who	: ProcessId;
	Seg	: SegmentSelector;
	VAddr	: VirtualAddress;
	RealAddr: RealAddress
	) : Error; EXTERNAL;
function Flush(
	Seg	: SegmentSelector;
	LoAddr	: VirtualAddress;
	HiAddr	: VirtualAddress
	) : Error; EXTERNAL;
function Free(
	Who	: ProcessId;
	Seg	: SegmentSelector;
	VAddr	: VirtualAddress
	) : Error; EXTERNAL;
function GetPerfData(
	DataArea : PPerfDataBlock
	) : Error; EXTERNAL;
function GetSpecialPId(
	SpIndex	: SpecialPIdIndex;
    var CurProc	: ProcessId
	) : Error; EXTERNAL;
function HWClockCommand(	(* headwall only: clock board command *)
	Code	: HWClockCode;
	Arg	: integer;	(* right justified bits going out *)
	ArgLen	: integer;	(* number of bits in arg *)
	var RetArg : integer	(* bits returned by clock board *)
	) : Error; EXTERNAL;
function InitQSeg(
	Who	: ProcessId;
	NumLinks: Integer;
	NumQueues : Integer;
	NumMessages : Integer;
	NumPages : Integer
	) : Error; EXTERNAL;
function Kill(
	Who	: ProcessId
	) : Error; EXTERNAL;
function MyID
	 : ProcessId; EXTERNAL;
function NextProcessId (
	Proc	: ProcessId;
    var NextProc: ProcessId
	) : Error; external;
function OpenLink(
	Sender	: ProcessId;
	Rcvr	: ProcessId;
	RcvrQueue : Queue;
    var NewLink	: Link		(* ... in Sender process *)
	) : Error; EXTERNAL;
function OpenQueue(
	Rcvr	: ProcessId;
	NumMsgs	: Integer;
    var	NewQ	: Queue
	) : Error; EXTERNAL;
function ReadProcessState(
	Who	: ProcessId;
    var	ProcBlok: ProcessControlBlock
	) : Error; EXTERNAL;
function ReadVirtualByte(
	who	: ProcessID;
	seg	: SegmentSelector;
	loc	: Integer;
    var data	: char
	) : Error; EXTERNAL;
function Receive(
	Q	: Queue;
    var	M	: Message;
    var	Sender	: ProcessId
	) : Error; EXTERNAL;
function ReceiveAny(
    var Q	: Queue;
    var M	: Message;
    var Sender	: ProcessId
	) : Error; EXTERNAL;
function ReceiveData(
	Q	: Queue
    var M	: Message;
	Where	: VirtualAddress;	(* in data seg *)
	MaxLen	: Integer;
    var Actual	: Integer;
    var Sender	: ProcessId
	) : Error; EXTERNAL;
function ReceivePage(
	Q	: Queue;
    var M	: Message;
	Where	: VirtualAddress;	(* .. page aligned *)
    var Sender	: ProcessId
	) : Error; EXTERNAL;
procedure RefWritePage (
	Page	: VirtualAddress
	); EXTERNAL;
function ReleaseDevice(
	Dev	: IDeviceNumber
	) : Error; EXTERNAL;
function Reply(
	Target	: ProcessId;
    var M	: Message;
	Where	: VirtualAddress;
	Len	: Integer
	) : Error; EXTERNAL;
function RunTime
	 : msTime; EXTERNAL;
function Send(
	L	: Link;
    var M	: Message
	) : Error; EXTERNAL;
function SendData(
	L	: Link;
    var M	: Message;
	Where	: VirtualAddress;
	Len	: Integer
	) : Error; EXTERNAL;
function SendDataToQ(
	Q	: Queue;
    var M	: Message;
	Where	: VirtualAddress;
	MaxLen	: Integer;
	Target	: ProcessId
	) : Error; EXTERNAL;
function SendPage(
	L	: Link;
    var M	: Message;
	Where	: VirtualAddress	(* .. page aligned *)
	) : Error; EXTERNAL;
function SendToQ(
	Q	: Queue;
    var M	: Message;
	Target	: ProcessId
	) : Error; EXTERNAL;
function SetQSegBase (
	Who	: ProcessId;
	VBase	: VirtualAddress
	) : Error; EXTERNAL;
function SetSpecialPId(
	SpIndex	: SpecialPIdIndex;
	CurProc	: ProcessId
	) : Error; EXTERNAL;
function SetSyncQ(
	L	: Link;
	Q	: Queue
	) : Error; EXTERNAL;
function SetTimeOfDay(
	NewTime	: TimeStamp;
	KWClock	: HeadwallDate
	) : Error; EXTERNAL;
function Suspend(
	Who	: ProcessId
	) : Error; EXTERNAL;
function SyncSend(
	L	: Link;
    var M	: Message;
	Where	: VirtualAddress;
	ToLen	: Integer;
	FromLen	: Integer;
    var Actual	: Integer
	) : Error; EXTERNAL;
procedure Terminate(
	Reason	: Error
	); EXTERNAL;
function Test(
	Q	: Queue
	) : Error; EXTERNAL;
function TimeOfDay
	 : TimeStamp; EXTERNAL;
function Trans(
	VAddr	: VirtualAddress;	(* .. in data seg *)
	Dirty	: Boolean;
    var RealAddr: RealAddress
	) : Error; EXTERNAL;
function UnBlockLink (
	L	: Link
	) : Error; EXTERNAL;
function Wait
	: Queue; EXTERNAL;
function WriteProcessState(
	Who	: ProcessId;
    var PCB	: ProcessControlBlock
	) : Error; EXTERNAL;
function WriteVirtualByte(
	who	: ProcessID;
	seg	: Integer;
	loc	: Integer;
	data	: char
	) : Error; EXTERNAL;
function ReadPCBWord(
        who     : ProcessID;
        whordloc: Integer;
    var PCBWord : Integer
        ) : Error; EXTERNAL;
function WritePCBWord(
        who     : ProcessID;
        whordloc: Integer;
        PCBWord : Integer
        ) : Error; EXTERNAL;
