/* "@(#)kim.h	5.2	2/13/87" */

/* kim.h:                                                         */
/* This file includes all the kernel interface declarations and   */
/* associated data structures.                                    */

#include <sys/procstate.h>

/* External Definitions */
extern Error  AcquireDevice();
extern Error  Activate();
extern Error  ActivateFamily();
extern Error  Arm();
extern Error  BlockLink();
extern Error  CloseLink();
extern Error  CloseQueue();
extern Error  CopyFrom();
extern Error  CopyTo();
extern Error  CreateFamily();
extern Error  CreateProcess();
extern Error  DCSendData();
extern Error  DeleteMessage();
extern Error  DeActivateFamily();
extern Error  Disarm();
extern Error  Fix();
extern Error  Flush();
extern Error  FlushOnInterrupt();
extern Error  Free();
extern Error  GetSpecialPId();
extern Error  HWClockCommand();
extern Error  InitQSeg();
extern Error  Kill();
extern ProcessId MyID();
extern Error  OpenLink();
extern Error  OpenQueue();
extern Error  ReadProcessState();
extern Error  Receive();
extern Error  ReceiveAny();
extern Error  ReceiveData();
extern Error  ReceivePage();
extern Error  ReleaseDevice();
extern Error  Reply();
extern Error  RunTime();
extern Error  Send();
extern Error  SendData();
extern Error  SendDataToQ();
extern Error  SendPage();
extern Error  SendToQ();
extern Error  SetQSegBase();
extern Error  SetSpecialPId();
extern Error  SetSyncQ();
extern Error  SetTimeOfDay();
extern Error  Suspend();
extern Error  SyncSend();
extern Error  Terminate();
extern Error  Test();
extern Error  TeleDiag();
extern Error  TimeOfDay();
extern Error  TouchVirtualWord();
extern Error  TouchPCBWord();
extern Error  Trans();
extern Error  UnBlockLink();
extern Error  Wait();
extern Error  WriteProcessState();

/* extra c routines */
extern int    brk();
extern char   *malloc();
extern char   *sbrk();
