(* "@(#)kim.pasc.h	5.2	6/16/86" *)
(* kim.p.h:
  This file includes all the kernel interface declarations and
  associated data structures.
*)
type
  doubleword	= set of 0..63;
  Error		= Integer;
  Queue		= Integer;
  Link		= Integer;
  FileId	= doubleword;
  TrapsBits	= set of (DebugBit,T1 ,T2 ,T3 ,T4 ,T5 ,T6 ,T7 ,
		    T8 ,T9 ,T10,T11,T12,T13,T14,T15,
		    TIntOvflow,TIntDiv0,TRealOvflow,
		    TRealUflow,TRealDiv0,T21,T22,T23,T24,
		    T25,T26,T27,T28,T29,TSticky,TPriv);
  Priority	= Integer;
  ProcessId	= Integer;
  VirtualAddress= Integer;
  ProgramCounter= VirtualAddress;	(* .. in code seg *)
  RealAddress	= Integer;
  msTime	= Integer;      (*in millisecs*)
  TimeStamp	= doubleword;	(* time stamp, 64 bits *)

type
  DeviceNumber  = 0..257;	(* 8 bits, plus Timer1 and Timer2 *)
  IDeviceNumber  = Integer;	(* Same as above, but in a word *)
const
  TimerDeviceNumber = 256;	(* 'device number' of timer(1) *)
  Timer2DeviceNumber = 257;	(* 'device number' of timer(2) *)

type
  SegmentSelector = Integer;    (*See below for enumeration*)
const
(*Enumeration of SegmentSelector*)
  CodeSeg       = 0;
  DataSeg       = 1;
  QueueSeg      = 2;

type
  ProcessState  = Integer;      (*See below for enumeration*)
const
(*Enumeration of ProcessState*)
  PStDead       = 0;
  PStActive     = 1;
  PStSusp       = 2;
  PStFault      = 3;            (*Faulted, but runnable*)
  PStFSusp      = 4;            (*Faulted, then suspended*)
  PStFDead      = 5;            (*Faulted, then killed*)

(* definition of process state record *)
type
  ProcessControlBlock = record
    Registers	: array [0..15] of Integer;
    PC		: Integer;
    Parent	: ProcessId;
    Traps	: TrapsBits;	(* double word *)
    ProcRunTime	: msTime;
    State	: ProcessState;
    Pri		: Priority;
    MsgWait	: Integer;
    NumFaults	: Integer;
    PCBUnUnused	: Integer;	(* spare *)
    codeFile	: FileID; 
    dataFile	: FileID;
    queueFile	: FileID;
    ttyd        : Integer;
    window      : Integer;
    uid         : Integer;
    gid         : Integer;
    pgrp        : Integer;
    PCBpad	: Array [1..27] of Integer;
  end;

type
  SpecialPIdIndex = Integer;
const
  SPPVMM	= 0;
  SPPVolMgr	= 1;
  SPPDirMgr	= 2;
  SPPForwarder	= 3;
  SPPFDLP	= 4;
  SPPStartup	= 5;

type
  SkeletalMessage	= array [0..3] of doubleword;
(* for external function and procedure definitions, see kim.e.h *)

(* FSeg Table -- file state values exported by the GetFilePriority KCall *)
const
  FSInteractive	= 1;

type
  FileState	= Integer;	(* halfword in kernel, exported as int *)

(* Get Perf Data block *)
type
  PerfDataBlock = record
  KCalls : array [0..255] of integer;
  Align,
  IllInstr,
  FetchParity,
  ExeParity,
  PageFault,
  KernVio,
  CheckTrap,
  TrapTrap,
  ExtInterrupt,
  Switch0,
  PowerFail,
  PowerOK,
  Timer1,
  Timer2,
  MaxProcs,
  NumProcs,
  MemPages,
  VRTHash,
  ContextSwitch,
  Uptime,
  IdleTime,
  VMMMsgs,
  SharingTries,
  SharingWins : integer;
  LoadAverages : array [1..3] of dreal;
  VRTMax,
  VRTMin,
  VRTAvg,
  MachineId,
  HardwareFeatures : integer;
  end; (* PerfDataBlock *)
  PPerfDataBlock	= ^PerfDataBlock;
/*
 * Bit masks for things in the  HardwareFeatures word
 */
#define HdwFtMCopyOnWrite 16#001
#define HdwFtMEFltPt      16#002
#define HdwFtMExtVRT	  16#004
#define HdwFtMHeadwall	  16#008

type
  HeadwallDate	= record case integer of
  0 : (Alignment	: doubleword);
  1 : (
    d1 : char;
    d2 : char;
    y, mo, d, h, mi, s : char
    );
  end; (* HeadwallDate *)

(* Headwall clock commands *)
type
  HWClockCode	= integer;
