/* "@(#)mtio.h	5.1	6/9/86" */
/* This include file contains Ridge specific data. */

/*****************************************************************************
/* 
/* tape io include file: sys/mtio.h
/*
/*****************************************************************************

/*
 * structures and definitions for mag tape io control commands
 */

#include <ros/mtio.h>


/*
 *	Ioctl values for mag tape
 */

#include <ros/ioctl.h>

#define MTIOCTOP	BSD_MTIOCTOP
#define MTIOCGET	BSD_MTIOCGET


/*
 *	Command values for MTIOCTOP
 */

#define	MTWEOF		BSD_MTWEOF	/* write an end of file record */
#define	MTFSF		BSD_MTFSF	/* forward space file */
#define	MTBSF		BSD_MTBSF	/* backward space file */
#define	MTFSR		BSD_MTFSR	/* forward space record */
#define	MTBSR		BSD_MTBSR	/* backward space record */
#define	MTREW		BSD_MTREW	/* rewind */
#define	MTOFFL		BSD_MTOFFL	/* rewind and put the drive offline */
#define	MTNOP		BSD_MTNOP	/* no operation, sets status only */
#define	MTHSPD		BSD_MTHSPD	/* set high speed */
#define	MTLSPD		BSD_MTLSPD	/* set low speed */


/*
 *	Constants for mt_type byte in MTIOCGET ioctl
 */

#define MT_ISTS		BSD_MT_ISTS		
#define MT_ISHT		BSD_MT_ISHT		
#define MT_ISTM		BSD_MT_ISTM		
#define MT_ISMT		BSD_MT_ISMT		
#define MT_ISUT		BSD_MT_ISUT		
#define MT_ISCPC	BSD_MT_ISCPC	
#define MT_ISAR		BSD_MT_ISAR		
#define MT_ISCY		BSD_MT_ISCY	/* added for ridge tape drive */
					/* may need to change later */


