;
; Test program to see if the the sector we ask for is the sector we got.
;

	ORG	100H
	PUT	100H
START:
	MOV	AH,9
	MOV	DX,HEADER
	INT	33
GETDRIVE:
	MOV	AH,9
	MOV	DX,WHICHDRIVE
	INT	33
	MOV	AH,10
	MOV	DX,INBUF
	INT	33
	MOV	AH,2
	MOV	DL,10
	INT	33
	CMP	B,[INBUF+1],1
	JAE	NORET
	INT	32		; Return to COMMAND.
NORET:
	MOV	BL,[INBUF+2]
	SUB	BL,'A'
	JB	GETDRIVE
	MOV	AH,14		; Check for nonexistant drives.
	MOV	DL,-1
	INT	33
	CMP	BL,AL
	JAE	GETDRIVE
	MOV	SI,BX		; Save drive number.
	MOV	AH,9		; Ask if we should write.
	MOV	DX,ASKWRITE
	INT	33
	MOV	AH,10
	MOV	DX,INBUF
	INT	33
	MOV	AH,2
	MOV	DL,10
	INT	33
	CMP	B,[INBUF+1],1
	JB	READ
	CMP	B,[INBUF+2],'Y'
	JNE	READ
WRITE:
	MOV	AL,0		; Fill background.
	MOV	CX,0A00H
	MOV	DI,DSKBUF
	UP
	REP
	STOB
	MOV	DI,0		; Start with track zero.
WTRACKLOOP:
	MOV	BX,DSKBUF	; Stuff the logical sector numbers.
	MOV	CX,10
STUFFLOOP:
	MOV	AX,10
	SUB	AX,CX
	ADD	AX,DI
	MOV	[BX],AX
	ADD	BX,100H
	LOOP	STUFFLOOP
	MOV	AX,SI		; AL = drive number.
	MOV	BX,DSKBUF	; DS:BX = disk buffer address.
	MOV	CX,10		; CX = number of sectors to write.
	MOV	DX,DI		; DX = logical sector number.
	PUSH	SI
	PUSH	DI
	INT	38
	POP	AX		; Pop flags off the stack.
	POP	DI
	POP	SI
	JNC	WRITEOK		; Error check.
	MOV	AH,9
	MOV	DX,WRITEP
	INT	33
	JP	JGETDRIVE
WRITEOK:
	ADD	DI,10
	CMP	DI,350
	JB	WTRACKLOOP
READ:
	MOV	DI,0
RTRACKLOOP:
	MOV	AX,SI		; AL = drive number.
	MOV	BX,DSKBUF	; DS:BX = disk buffer address.
	MOV	CX,10		; CX = number of sectors to write.
	MOV	DX,DI		; DX = logical sector number.
	PUSH	SI
	PUSH	DI
	INT	37
	POP	AX		; Pop flags off the stack.
	POP	DI
	POP	SI
	JNC	READOK
	MOV	AH,9
	MOV	DX,HARDERR
	INT	33
JGETDRIVE:
	JMP	GETDRIVE
READOK:
	MOV	BX,DSKBUF
	MOV	CX,10
CHKLOOP:
	MOV	AX,10
	SUB	AX,CX
	ADD	AX,DI
	CMP	AX,[BX]
	JE	CHKOK
	MOV	AH,9
	MOV	DX,WRONGSECT
	INT	33
	JP	JGETDRIVE
CHKOK:
	ADD	BX,100H
	LOOP	CHKLOOP
	ADD	DI,10
	CMP	DI,350
	JB	RTRACKLOOP
	MOV	AH,6
	MOV	DL,0FFH
	INT	33
	AND	AL,AL
	JZ	READ
	CMP	AL,03H
	JNE	JGETDRIVE
	INT	32

HEADER:
	DB	13,10,10,'North Star disk test program.',13,10,'$'
WHICHDRIVE:
	DB	'Test which drive? $'
ASKWRITE:
	DB	'Write sector numbers on disk first (Y/N)? $'
WRITEP:
	DB	'Disk is write protected.',13,10,'$'
HARDERR:
	DB	'Hard disk error.',13,10,'$'
WRONGSECT:
	DB	'Wrong sector read.',13,10,'$'
INBUF:
	DB	2,0,0,0
DSKBUF:
	DS	0A00H
	END
