	ORG	014DH
	PUT	014DH
CLRSCRN	MOV	AL,0CH		; Clear screen.
	JMP	OUTCHR

	ORG	0157H
	PUT	0157H
TCURSOR	PUSH	DS		; Position cursor.
	PUSH	AX
	PUSH	BX
	MOV	AX,0FE00H	; Screen segment.
	MOV	DS,AX
	MOV	BX,[07D0H]	; Get cursor position.
	AND	B,[BX],7FH	; Turn off cursor.
	POP	BX		; Get new cursor position.
	MOV	AL,80		; 80 characters/line.
	MUL	AL,BL		; Multiply line number by 80.
	PUSH	BX		; Save again.
	MOV	BL,BH		; BX = column number.
	JP	CONT		; Out of space - continue below.

	ORG	0170H
	PUT	0170H
PBEGMEM	DW	324FH		; Address of scratch RAM.
HITE:	DB	24		; Terminal hight.
WID:	DB	80		; Terminal width.
EREOL:	DB	0BH		; Erase to end-of-line character.
	DB	0
NOVIO:	DB	0FFH		; No IMSAI VIO board.
	DB	0
	DB	0
	DB	0
DELCLR:	DB	0		; Clear screen delay.
DELCUS:	DB	0		; Position cursor delay.
DELERE:	DB	0		; Erase-to-End-Of-Line delay.

CONT:	XOR	BH,BH		; Continue cursor poitioning here.
	ADD	BX,AX		; Add in column number to find address.
	OR	B,[BX],80H	; Turn on new cursor.
	MOV	[07D0H],BX	; Save new cursor position.
	POP	BX		; POP registers.
	POP	AX
	POP	DS
	RET

	ORG	01A8H		; OUTCHR address.
OUTCHR:
	END
