         REHASHING A DIRECTORY

This disk contains the pieces necessary to install the Fast Hashing logic
on Cheiftan-based SDOS 1.1 systems.

Fast Hashing ensures (with high probability) that "RENAME ...", "CREATE
xxxx", and DELETE <nonexistent file> operations take only about
.5 each, regardless of the size of the Winchester drive.  Without this
enhancement, these operations take about 2 seconds each on a directory
with 1000 directory slots, and the time increases in proportion to
the directory size.  On systems running Screen or Touch editors,
the time to do one of these operations is dedicated solely to one
user, i.e., no timesharing occurs during the operation, so
this enhancement should be easily noticed by users.

Two steps are required to install the enhancement: Rehashing the directory,
and installing a patch to SDOS. These steps may be performed in any order.

Whether the patch is installed or not, rehashing the disk will
significantly decrease "OPEN" and "DELETE <existingfile>" operations on
disks whose directory has filled completely at some time in the past.

The Rehashing process is accomplished automatically by a program named
REHASHDIRECTORY, found on this disk. The program will ask the name of the
disk drive to rehash, and will then display some statistics about the
current organization of the directory on the drive.  One should write down
the statistics values before proceeding (the program will print enough
output while re-organizing the directory so these statistics will roll off
the screen) so they can be compared with the statistics produced when the
process is completed. Only two of the statistics are really useful: the
number of free slots, and the average lookup time (i.e., how long it takes
SDOS to OPEN/CREATE/RENAME/... a file).  The larger the number of free
slots in a directory, the lower the average lookup time AFTER the directory
has been rehashed. At this point, the program will offer to reorganize the
directory. If the statistics are satisfactory, the user may simply quit. If
unsatisfactory, the user can request the program to actually reorganize the
directory. If he asks to reorganize the directory, the program will offer
an opportunity to change the size of the directory, and will then recompute
the statistics.  This is primarily important when checking that there are
enough free slots; changing the the directory size generally makes the
lookup time go to hell, but reorganizing the directory AFTER it has been
extended will neatly solve this problem. If the user does not want the
directory size changed, he simply lets the program proceed to the
reorganization pass.  On a Winchester with 1000 file slots and "enough"
free slots, this takes about 2 minutes; larger directories will take
correspondingly longer. When the process is complete, the directory
statistics are re-computed so any improvement can be seen.

DO NOT ^C^C OR TYPE <ESCAPE> DURING THIS PROCESS AS YOU COULD LOSE ONE OR
MORE FILES; THERE IS ALSO A CHANCE OF LOSING THE DIRECTORY ENTIRELY.

The program has been thouroghly tested, but only on one Winchester so far.
Tests on expanding DIRECTORY.SYS have always succeeded; shrinking
DIRECTORY.SYS also works but there is less experience with it. In no case
have any files been lost. To convince yourself that it is safe and to get
some experience running it before trying it out on a live system, we
suggest you build a few floppy disks (that you don't care about) full of
stuff and run the program on them first.  While it should not be necessary,
one should back up everything off the Winchester first (the program has NOT
ever lost any files or data).

After SDOSDISKINIT'ing a Winchester, the REHASHDIR procedure must be
run if one desires ensure efficient lookups.

PATCHING SDOS:

The following patches are required to a 60K SDOS 1.1 to speed up
RENAME and CREATE:

     DB5B/ 2417

     DB6F/ 1212BDEF66BDEF5D

     EF5D/ 9E06AE8827BFC2B539
     EF66/ BEC2B7A6842B01397EDBBC

     CC03/ 8F

END OF PATCHES
