	TITLE	SDOS SIMULATOR CONFIGURATION PROGRAM
	TABS	16,24,42,50

**************************************************
*				*
*	SD BASIC V1.4		*
*	CONFIGURATION PROGRAM		*
*	FOR S6 RECORDS ONLY		*
*				*
*	    VERSION 1.1a		*
*	EDIT DATE 12-20-82, DWP		*
**************************************************
* THIS MODULE CAN BE USED FOR CONFIGURING SOFTWARE DYNAMICS BASIC V1.4
* COMPILER OR RUN-TIME PACKAGE.  FOR THE COMPILER NO INLINE PARAMETER
* IS NEEDED.  FOR THE RUN-TIME PACKAGE THE INLINE PARAMETER IS EXPECTED
* TO BE A FILE SPECIFICATION OF A COMPILED BASIC PROGRAM TO RUN.  AN
* OPTIONAL SWITCH STRING MAY BE SPECIFIED WITH THE FOLLOWING MEANINGS:
*
*	SWITCH	MEANING
*
*	B:nn	Set number of buffers to nn.
*	S:nn	Set buffer size to nn pages.
*	E:nn	Set file extension size to nn blocks.
*	M	Print maximum memory size.
*	V	Print a version number.
*
* DEFAULT VALUES FOR THE COMPILER ARE TWO BUFFERS OF FOUR PAGES AND
* A 64 BLOCK FILE EXTENSION SIZE.
* DEFAULT VALUES FOR THE RUN-TIME PACKAGE ARE FOUR BUFFERS OF TWO
* PAGES AND A ONE BLOCK FILE EXTENSION SIZE.
*
START	EQU	$4700	END COMPILER, START OF LOADER
COMP.STARTUP	EQU	$0AB9	BASIC COMPILER STARTUP ADDRESS
RTP.STARTUP	EQU	$03E4	RUN TIME PACKAGE STARTUP ADDRESS
IOPKGSIZE	EQU	13	13 PAGE SIMULATOR
VECTADRS	EQU	$101	ADDRESS OF VECTOR
COMP.BUFSIZ	EQU	4	FOUR PAGE BUFFERS FOR COMPILER
RTP.BUFSIZ	EQU	2	TWO PAGE BUFFERS FOR RTP
COMP.NUMBUF	EQU	2	TWO BUFFERS	 FOR COMPILER
RTP.NUMBUF	EQU	4	FOUR BUFFERS FOR RTP
COMP.EXTENT	EQU	64	64 BLOCK FILE EXTENSIONS
RTP.EXTENT	EQU	1	ONE BLOCK FILE EXTENSIONS FOR RTP
MAXBUFS	EQU	12	MAX BUFFERS IN SIMULATOR
OBUFSIZ	EQU	40	SHOULD BE ENOUGH FOR INLINE PARAM


* STANDARD EQUATES

SWI:ACCEPT	EQU	$3F00
SWI:TYPE	EQU	$3F01
SWI:OPEN	EQU	$3F07
SWI:CLOSE	EQU	$3F08
SWI:CSTAT	EQU	$3F0A
SWI:EXIT	EQU	$3F11
SWI:USRTOP	EQU	$3F13
	PAGE

* SIMULATOR PACKAGE VARIABLES TEMPLATE

	ABS
	ORG	0
	RMB	3	LOCATION OF JUMP INSTRUCTION
IOSIZE	RMB	2	SIZE OF SIMULATOR
IOPKGBASE	RMB	2
EXBLK	RMB	3	LOCATION OF FILE EXTENSION SIZE
BUFSIZ	RMB	1	SIZE OF I/O BUFFERS
BUFTBL	RMB	MAXBUFS	BUFFER TABLE

	ABS
	ORG	0	PAGE ZERO DATA

TEMP	RMB	2
RELC	RMB	2	(RELOCATION CONSTANT)
BUFPTR	RMB	2	BUFFER POINTER.
ADR	RMB	2	MEMORY LOAD ADDRESS
RELPND	RMB	1	"RELOCATION PENDING" FLAG
CHKSUM	RMB	1	CHECKSUM
RCB	RMB	1	RELOCATION CONTROL BYTE (RCB)
RCBMASK	RMB	1	BIT MASK FOR RCB
BYTCNT	RMB	1	BYTE COUNT
BUFTBLPTR	RMB	2
BUFCNT	RMB	1
SIZBUF	RMB	1	SIZE OF BUFFERS
PARAMFLG	RMB	1	INLINE PARAMETER FLAG
EXTSIZ	RMB	1	FILE EXTENSION SIZE
PMEM	RMB	1	PRINT MEMORY SIZE
* SD SYSTEM CALL BLOCK.
SC:OPCODE	RMB	1
SC:WLEN	RMB	1
SC:CHAN	RMB	1
	RMB	1
SC:WRBUF	RMB	2
SC:WRLEN	RMB	2
SC:RPLEN	RMB	2
SC:RDBUF	RMB	2
SC:RDLEN	RMB	2
ILPBUF	RMB	OBUFSIZ+1
	PAGE

	ORG	VECTADRS	PUT OUR ENTRY VECTOR INTO COMPILER
	FDB	CONFIG	SET CONFIGURATION VECTOR
	REL		MAKE EVERYTHING ELSE RELOCATABLE



CONFIG	BSR	PSHPC	PUSH PC ON STACK
PSHPC	STAA	PARAMFLG	SAVE INLINE PARAMETER FLAG
	SWI:USRTOP	WHERE IS THE END OF MEM?
	INX
	STX	RELC
	LDAA	RELC	SET STARTING LOAD ADDRESS FOR I/O PACK
	SUBA	#IOPKGSIZE
	STAA	RELC	SET OUR START TO $XXFF+1
	CLRB
	STAB	RELPND	CLEAR "RELOCATION PENDING" FLAG.
	STAB	BYTCNT	INITIALIZE BYTE COUNT
	STAB	CHKSUM	INITIALIZE CHECKSUM
	stab	$f0	clear sdos line flags
	JSR	LOAD	'LOAD' THE I/O PACKAGE
	TSX		CK IF WE ARE RUNNING THE COMPILER
	LDX	0,X	GET PUSHED PC
	CPX	#START+2
	BNE	SETRTP	B/ NOT COMPILER, SET UP RUNTIME
	LDX	#COMP.STARTUP	RESTORE COMPILER JUMP VECTOR
	STX	VECTADRS
	LDAA	#COMP.NUMBUF	SET COMPILER BUFFERS
	STAA	BUFCNT
	LDAA	#COMP.BUFSIZ	SET COMPILER BUFFER SIZE
	STAA	SIZBUF
	LDAA	#COMP.EXTENT	SET COMPILER FILE EXTENSION
	STAA	EXTSIZ
	CLRA
	STAA	PMEM
	JSR	SETOPTS	SET OPTIONS IN SIMULATOR
	LDX	$FC	SET STACK POINTER
	TXS		JUST BELOW SIMULATOR
	JMP	COMP.STARTUP	START COMPILER

SETRTP	LDAA	PARAMFLG	CK PARAMETER FLAG
	BNE	PARSOPT	B/ PARSE INLINE PARAMETER
	LDX	#SYNTAX	TELL USER WHAT SYNTAX IS
EREXIT.1	SWI:TYPE
	SWI:EXIT
PARSOPT	LDX	#ILPBUF	READ PARAMETER INTO INLINE BUFFER
	LDAA	#-1	COMMAND LINE MODE
	LDAB	#OBUFSIZ
	SWI:ACCEPT
	LDX	#OPNBLK	OPEN FILE & PARSE SWITCHES
	LDAA	#2	OPEN ON CHANNEL 2.
	SWI:OPEN
	BEQ	PARSOPT.0	B/ FILE EXISTS
	CMPB	#5	FILE NOT FOUND?
	BNE	EREXIT.1	B/ NO, PRINT MESSAGE AND SPLIT
	LDX	#NOPROGM	TELL USER BASIC PROGRAM NOT FOUND
	BRA	EREXIT.1
PARSOPT.0	LDAA	#2	CK IF CHANNEL SPEC IS A FILE
	SWI:CSTAT
	BNE	EREXIT.1	B/ ERROR?
	PSHA		SAVE CHANNEL STATUS BYTE
	LDAA	#2	CLOSE THE CHANNEL
	SWI:CLOSE
	PULA		RESTORE CHANNEL STATUS BYTE
	BNE	EREXIT.1	B/ HOW?  WE JUST OPENED IT.
	BITA	#$40	MUST BE FILE STRUCTURED
	BNE	PARSOPT.1	B/ OK
	LDX	#BADSPEC	TELL USER
	BRA	EREXIT.1
PARSOPT.1	CLR	PMEM	SET PRINT MEMORY FLAG
	LDX	#RTP.STARTUP	RESTORE RTP STARTUP VECTOR
	STX	VECTADRS
	LDAA	#RTP.BUFSIZ	SET DEFAULTS FOR RTP
	STAA	SIZBUF
	LDAA	#RTP.NUMBUF	SET NUMBER OF BUFFERS FOR RTP
	STAA	BUFCNT
	LDAA	#RTP.EXTENT	SET FILE EXTENSION FOR RTP
	STAA	EXTSIZ
	LDX	OPNBLK+2	GET ADDRESS OF SWITCH STRING
PARSOPT.2	LDAA	0,X	GET A SWITCH PARAMETER
	BEQ	PARSDONE	B/ NO MORE SWITCHES
	CMPA	#'B!$80	BUFFER OPTION?
	BNE	PARSOPT.3	B/ NO
	LDAA	1,X	GET NUMERIC PARAMETER
	STAA	BUFCNT	SET BUFFERS COUNT
	BRA	PARSNXT	GET NEXT
PARSOPT.3	CMPA	#'S!$80	SIZE OPTION?
	BNE	PARSOPT.4	B/ NO
	LDAA	1,X	GET BUFFER SIZE
	STAA	SIZBUF	AND SET IT
	BRA	PARSNXT	GET NEXT SWITCH
PARSOPT.4	CMPA	#'E!$80	EXTENT OPTION?
	BNE	PARSOPT.5	B/ NO
	LDAA	1,X	GET EXTENT SIZE
	STAA	EXTSIZ	AND SAVE
	BRA	PARSNXT	GET NEXT SWITCH
PARSOPT.5	CMPA	#'V	PRINT VERSION NUMBER?
	BNE	PARSOPT.6	B/ NO
	STX	TEMP	SAVE SWITCH POINTER
	LDX	#VERSION
	SWI:TYPE
	LDX	TEMP
	BRA	PARSNXT.1
PARSOPT.6	CMPA	#'M	PRINT MEMORY SIZE?
	BNE	PARSOPT.7
	STAA	PMEM	SET FLAG
	BRA	PARSNXT.1
PARSOPT.7	LDX	#BADSWITCH
	JMP	EREXIT.1
PARSNXT	INX		ADVANCE PAST 2 SWITCH BYTES
PARSNXT.1	INX
	BRA	PARSOPT.2	BACK TO TOP
PARSDONE	EQU	*
	BSR	SETOPTS	SET OPTIONS
	LDAA	#6	SDOS CHAIN OPCODE
	STAA	SC:OPCODE
	LDAA	#14	14 BYTE I/O BLOCK
	STAA	SC:WLEN
	LDX	#ILPBUF	POINT TO FILE SPEC
	STX	SC:WRBUF
	CLRB		COUNT BYTES IN FILE SPEC
LOOP	SET	*
	INCB		COUNT A BYTE
	LDAA	0,X
	BEQ	CHAIN.1	B/ FOUND NULL AT END
	INX		ADVANCE POINTER
	CMPA	#'/	SWITCH DELIMITER?
	BNE	LOOP	B/ NO, KEEP LOOKING
	DECB		DON'T COUNT SWITCH
CHAIN.1	STAB	SC:WRLEN+1	SET LENGTH
	CLR	SC:WRLEN
	CLR	SC:CHAN	SET CHANNEL # = 0
	LDX	$FC	SET STACK POINTER
	TXS		JUST BELOW SIMULATOR
	LDX	#SC:OPCODE
	JSR	$FB	EXECUTE CHAIN
	LDX	#LOADERROR
	SWI:TYPE
	SWI:EXIT
EXCSIZ	LDX	#EXCSPC	EXCESS BUFFER SIZE SPECIFIED
EREXIT.2	SWI:TYPE
	SWI:EXIT

SETOPTS	LDX	RELC	GET BASE OF SIMULATOR CODE
	STX	BUFTBLPTR	SAVE BUFFER TABLE POINTER
	LDAA	#MAXBUFS
	CMPA	BUFCNT	USER SPECIFY TOO MANY BUFFERS?
	BCC	CLRBTBL	B/ NO
	LDX	#EXCBUFS	TELL USER
	SWI:TYPE
	SWI:EXIT
CLRBTBL	CLR	BUFTBL,X	ZERO OUT BUFFER TABLE
	INX
	DECA
	BNE	CLRBTBL
	LDX	RELC
	LDAA	SIZBUF	SET BUFFER SIZE
	BNE	SETBUF.0	B/ SIZE OK
	LDX	#BUFSIZER	COMPLAIN TO USER
	BRA	EREXIT.2
SETBUF.0	STAA	BUFSIZ,X
	LDAA	RELC
	LDAB	RELC+1
	STAA	IOPKGBASE,X
	STAB	IOPKGBASE+1,X
	TST	BUFCNT	ANY BUFFERS SPECIFIED?
	BEQ	TYPEADR	B/ NO, JUST LIST BASE ADDRESS
SETBUFS	LDX	RELC
	SUBA	BUFSIZ,X
	STAA	IOPKGBASE,X
	BCS	EXCSIZ	B/ EXCESS BUFFER SIZE ERROR
	LDX	BUFTBLPTR	SET BUFFER ADDRESS IN BUFFER TABLE
	STAA	BUFTBL,X
	INX		BUMP POINTER TO NEXT TABLE SLOT
	STX	BUFTBLPTR
	DEC	BUFCNT	SEE IF ANY MORE BUFFERS TO SET
	BNE	SETBUFS	B/ YES, DO THEM
TYPEADR	LDX	RELC
	CLR	EXBLK,X	SET DEFAULT FILE EXTENSION
	CLR	EXBLK+1,X
	LDAA	EXTSIZ
	STAA	EXBLK+2,X
	DEC	IOPKGBASE,X	SUBTRACT 1 FROM BASE FOR JUMP VECTOR
	LDAB	IOPKGBASE,X	GET BASE PAGE
	LDX	IOPKGBASE,X	GET POINTER TO THE PAGE
	STX	$FC	SET IT AS SDOS JUMP VECTOR
	LDAA	#$7E	INSTALL JUMP INSTRUCTION
	STAA	$FB	AT SDOS ENTRY POINT
	STAA	0,X	SET A JUMP VECTOR INTO SIMULATOR
	LDAA	RELC	GET SIMULATOR ENTRY POINT
	STAA	1,X	SET VECTOR TO SIMULATOR
	LDAA	RELC+1
	STAA	2,X
	LDX	#IOBUFFER	MAKE SURE WE DID NOT UNDERFLOW
	STX	TEMP
	SUBB	TEMP
	BCS	EXCSIZ
	LDAA	PMEM	PRINT MEMORY SIZE?
	BEQ	SETRTS	B/ NO, EXIT SUBROUTINE
	LDX	RELC
	LDAA	IOPKGBASE,X	GET BOTTOM PAGE OF SIMULATOR
	DECA		USER SPACE IS nnFF HEX
	TAB		SAVE COPY
	BSR	CNVASCI
	STAA	USRTOP+1
	TBA		GET COPY BACK
	LSRA
	LSRA
	LSRA
	LSRA
	BSR	CNVASCI
	STAA	USRTOP
	LDX	#MEMSIZMSG
	SWI:TYPE
SETRTS	RTS

CNVASCI	ANDA	#$F
	ADDA	#$90
	DAA
	ADCA	#$40
	DAA
	RTS

LOAD	LDX	#IOBUFFER	INITIALIZE BUFFER POINTER
	STX	BUFPTR
LOAD5	BSR	GETL	GET A CHAR FROM THE LOAD BUFFER.
	CMPA	#'S	1ST CHAR MUST BE "S".
	BNE	LOAD5
	BSR	GETL	GET 2CD CHAR.
	CMPA	#'6	S6 RECORD?
	BEQ	LOAD7	B/ YES
	CMPA	#'9
	BNE	LOAD5
	RTS		RETURN, LOAD DONE.

LOAD7	BSR	BYTE	READ IN BYTE COUNT (2 FRAMES),
	STAA	BYTCNT	AND SET BYTE COUNT.
	BSR	BYTE	GET MSB ADDRESS.
	PSHA
	BSR	BYTE	LSB ADDRESS.
	PSHA		SAVE MEMORY LOAD ADDRESS ON STACK,
	BSR	BYTE	READ IN ADDRESS RELOCATION FLAG.
	TSTA		IS IT ZERO?
	PULA
	PULB
	BEQ	LOAD9	B/ YES, ABSOLUTE LOAD ADDRESS.
	ADDA	RELC+1	NO: RELOCATABLE ADDRESS -- ADD
	ADCB	RELC	RELOCATION CONSTANT.

LOAD9	STAA	ADR+1	SET MEMORY LOAD ADDRESS IN X-REG.
	STAB	ADR

INZMSK	LDAA	#$80	INIZ RELOCATION CONTROL BYTE MASK.
	STAA	RCBMASK
	BSR	BYTE	READ IN THE RELOCATION CONTROL BYTE (RCB),
	STAA	RCB	AND SAVE RCB.

INDATA	BSR	BYTE	READ IN A DATA BYTE,
	LDX	ADR
	STAA	X	STORE DATA IN MEMORY ADDRESS,
	INX		BUMP MEMORY POINTER,
	STX	ADR
	LDAA	RCB	IS CONTROL BIT (CORRESPONDING TO DATA BYTE WE JUST
	ANDA	RCBMASK	READ IN) IN RCB SET?
	BEQ	RCBCLR	B/ NO.
	LDAB	RELPND	YES...WAS PREVIOUS BIT ALSO SET?
	BNE	LOADERR	SORRY...LINKER NOT IMPLEMENTED YET!
	STAA	RELPND	YES: SET "RELOCATION PENDING" FLAG AND
	BRA	NXTBYT	GET NEXT BYTE.



GETL	LDX	BUFPTR
	LDAA	0,X
	INX
	STX	BUFPTR
	RTS

RCBCLR	TST	RELPND	CONTROL BIT WAS CLEAR.  WAS PREVIOUS RCB SET?
	BEQ	NXTBYT	B/ NO, GET NEXT BYTE.
	CLR	RELPND	YES: CLEAR THE PENDING FLAG,
	LDX	ADR
	DEX		BACKUP MEMORY POINTER,
	DEX
	LDAA	1,X	ADD THE RELOCATION CONSTANT TO THE MEMORY BYTES,
	LDAB	X
	ADDA	RELC+1
	ADCB	RELC
	STAA	1,X
	STAB	X
NXTBYT	LSR	RCBMASK	ADVANCE MASK TO NEXT POSITION -- IS RCB EXHAUSTED?
	BCC	INDATA	B/ NO, READ IN ANOTHER DATA BYTE.
	BRA	INZMSK	B/ YES, GET NEXT RCB.

* INPUT BYTE (2 FRAMES):

BYTE	BSR	GETL	READ A CHAR.
	TAB
	ADDB	CHKSUM	ADJUST CHECKSUM.
	STAB	CHKSUM
	DEC	BYTCNT	RECORD EXHAUSTED?
	BNE	BYTE1	B/ NO
	INS		POP CALLERS RET ADDRS
	INS
	INC	CHKSUM	TEST CHECKSUM
	BNE	LOADERR
	JMP	LOAD5	GO TO TOP FOR NEXT RECORD
BYTE1	RTS

LOADERR	BSR	TYPERR	PRINT ERROR
	FCC	/INTERNAL CHECKSUM ERROR/
	FCB	$D,0
TYPERR	TSX		GET PTR TO MSG
	LDX	0,X
	SWI:TYPE
	SWI:EXIT
*
EXCBUFS	FCC	/TOO MANY BUFFERS SPECIFIED, MAXIMUM SWITCH VALUE IS B:12/
	FCB	$D,0
EXCSPC	FCC	/NOT ENOUGH MEMORY FOR NUMBER OF BUFFERS AND SIZE SPECIFIED/
	FCB	$D,0
SYNTAX	FCC	/To use this program, enter; RUN program name/
	FCB	$D,0
NOPROGM	FCC	/BASIC PROGRAM NOT FOUND/
	FCB	$D,0
VERSION	FCC	/Version 1.1a/
	FCB	$D,0
MEMSIZMSG	FCC	/Top of user memory is /
USRTOP	FCB	00,00,'F,'F,$D,0
BADSWITCH	FCC	/ONLY SWITCHES RECOGNIZED ARE B:nnS:nnE:nnVM/
	FCB	$D,0
BADSPEC	FCC	/PARAMETER MUST SPECIFY A BASIC PROGRAM NAME/
	FCB	$D,0
BUFSIZER	FCC	/BUFFER SIZE OF ZERO IS NOT VALID/
	FCB	$D,0
LOADERROR	FCC	/ERROR IN LOADING BASIC PROGRAM/
	FCB	$D,0
OPNBLK	FDB	ILPBUF	@ OF COMMAND LINE BUFFER
	FDB	SWCBUF	@ OF SWITCH LIST BUFFER
	FCB	1	1 CHANNEL, SWITCHES ALLOWED
	FDB	('O-$40)*40*40+('B-$40)*40+('J-$40)
SWCBUF	RMB	17	SWITCH LIST BUFFER
IOBUFFER	EQU	*	I/O PACKAGE LOAD RECORDS
	end
