!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                                                                             !
!       MACRO EXPANDER 1.0 12/12/79 CJM                                       !
!                                                                             !
!       This program will expand macros in assembly language programs.        !
!       No forward references are allowed to macros, since this is a one      !
!       pass program.  Also, macro definitions ignore conditional assembly,   !
!       that is, you can not conditionally define a macro, though conditional !
!       assembly is permited within a macro.                                  !
!                                                                             !
!       MACRO DEFINITION                                                      !
!                                                                             !
!       To define a macro, the input stream must contain a line with the      !
!       word 'MACRO' in the label field followed by the name of the           !
!       macro in the command field.  The argument field and the coment        !
!       field are ignored.  The text of the macro follows, and finally        !
!       the word 'MEND' must appear in the op field after the last            !
!       line of the macro.                                                    !
!                                                                             !
!       Arguments are named ?n, where n varies from 0 to 9, corresponding     !
!       to the first through last argument.  Should an argument not be        !
!       supplied, the value of ?n is '0'.                                     !
!                                                                             !
!       Local labels can be generated by use of ?a, where 'a' is a letter.    !
!                                                                             !
!       EXAMPLE MACRO                                                         !
!                                                                             !
!       MACRO   PRINT   This macro prints a message on the terminal (chan 0)  !
!       *               The args are as follows: string,error routine         !
!       *               if the error routine isn't supplied (=0), an          !
!       *               error exit is performed on an error                   !
!               LDX     #?A                                                   !
!               JSR     $FB                                                   !
!               BCC     ?B                                                    !
!               IF      0=?1    IS THERE NO ERROR ROUTINE?                    !
!               STX     ?C                                                    !
!               LDX     #?D                                                   !
!               JMP     $FB     BYE-BYE!                                      !
!               ELSE                                                          !
!               JMP     ?1      GO TO HIS ERROR RECOVERY ROUTINE              !
!               FIN                                                           !
!       ?A      FCB     SYSCALL:WRITEA                                        !
!               FCB     WRITEA:SCLEN                                          !
!               FCB     0,IGNORED                                             !
!               FDB     ?E      STRING ADDRESS                                !
!               FDB     ?F      STRING LENGTH                                 !
!                                                                             !
!       ?E      FCC     ?0                                                    !
!       ?F      EQU     *-?E                                                  !
!                                                                             !
!       ?D      FCB     SYSCALL:ERROREXIT                                     !
!               FCB     ERROREXIT:SCLEN                                       !
!               FDB     CHANGED                                               !
!                                                                             !
!       ?B      EQU     *                                                     !
!               MEND                                                          !
!                                                                             !
!                                                                             !
!       SPECIAL COMMAND LINE PARSING                                          !
!                                                                             !
!       In order for macros to replace normal instructions, special parsing   !
!       is provided.  In particular, the following flags are SET to 1 iff     !
!       the following conditions are met:                                     !
!                                                                             !
!       FLAG            CONDITION                                             !
!       ----            ---------                                             !
!       IMMEDIATE        A number sign (#) appeared before the arg list       !
!       INDIRECT        The arg list was surrounded by brackets ('[]')        !
!       INDEXOFFX       A indexed address mode of X was specified             !
!       INDEXOFFS       A indexed address mode off S was given                !
!       POSTINCREMENT   Post inc indexing                                     !
!       PREDECREMENT    Pre-dec indexing                                      !
!       DOUBLEINCDEC    Either double Post-inc or Pre-dec                     !
!       INDEXED         Indexed addressing                                    !
!       DIRECT          not(INDEXED or IMMEDIATE)                             !
!                                                                             !
!       Note: in the indexing (which might be ',++X', etc.) DOES NOT get      !
!       passed as an argument to the macro....                                !
!                                                                             !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	DIM	MACROS$[2048]/""/
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         ! Macro expansion variable                                 !
         ! ! :FF ! name of macro ! :FE ! channel # ! File position !!
         !    1         n           1        1           3          !
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!	other variables for macro expansion:
	DIM	MACRO$[20], MLINE$[100], MACROLINE$[100], FF$/:FF/
	DIM	FE$/:FE/, T$[4], ARGS$[80], BYTES4$/0,0,0,0/

!	macro processor state variable
	DIM	MACROSTATE/1/

!	various parsing variables
	DIM	IMMEDIATE/0/, POSTINC/0/, PREDEC/0/, DOUBLE/0/
	DIM	INDEXED/0/, INDEXOFFS/0/, INDEXOFFX/0/, INDIRECT/0/
	DIM	DIRECT/0/

!	Flag values
	DIM	IMMEDIATEFLAG/:01/
	DIM	POSTINCFLAG/:02/, PREDECFLAG/:04/
	DIM	DOUBLEFLAG/:08/, INDEXEDFLAG/:10/
	DIM	INDEXOFFXFLAG/:20/, INDEXOFFSFLAG/:40/
	DIM	INDIRECTFLAG/:80/, DIRECTFLAG/:100/
	DIM	OLDFLAGS/:1FF/, NEWFLAGS/:000/

!	argument binding variables
	DIM	ARGSP(10), ARGSL(10), NARGS/0/

!	position in macros$ of current macro
	DIM	MACROPOS

!	VARIABLES FOR PREPARSING

!	various fields in line
	DIM	LABEL$[32], CF$[32], AF$[80], REST$[100]

!	input line and scratch
	DIM	LINE$[100], TEMP$[100]

!	GET LINE VARIABLES
	DIM	CURCHAN/1/, OUTPUT/1/, FILE$[30]

!	SYSCALL VARIABLE(S)
	DIM	GETCURPOS$/:F,:E,0,0/, CHANNEL/3/

!	local label variables
	DIM	LABELBASE/0/,NLABELSUSED/0/

                              !!!!!!!!!!!!!!!!!!!
                              ! PROGRAM STARTUP !
                              !!!!!!!!!!!!!!!!!!!

	PRINT	"MACRO EXPANSION PROCESSOR 7/31/80 1.0H"
	INPUT	"Output file= " FILE$
	CREATE	#OUTPUT, FILE$
	GOSUB	GENFLAGS
	GOTO	GETNEXTFILE

                           !!!!!!!!!!!!!!!!!!!!!!!!
                           ! GET LINE FROM SOURCE !
                           !!!!!!!!!!!!!!!!!!!!!!!!
GETLINE:	INPUT	#CURCHAN, LINE$
	IF	EOF(CURCHAN) THEN UNEXPECTEDEOF

	GOSUB	PREPARSE
	IF	CF$<>"END" THEN MACROEXPANDER

GETNEXTFILE:	INPUT	"Next file= " FILE$
	IF	FILE$="" THEN WRAPTHINGSUP

	CURCHAN	=CURCHAN+1
	OPEN	#CURCHAN, FILE$
	GOTO	GETLINE

WRAPTHINGSUP:	PRINT	#OUTPUT, LINE$
	EXIT
UNEXPECTEDEOF:	LINE$="	END	;UNEXPECTED EOF"
	PRINT	"No END in file!"
	GOTO	GETNEXTFILE


                             !!!!!!!!!!!!!!!!!!!!!
                             ! PRE PARSE ROUTINE !
                             !!!!!!!!!!!!!!!!!!!!!
PREPARSE:	LABEL$	=""
	CF$	=""
	AF$	=""
	REST$	=""

!	a few quick tests...

	IF	LEN(LINE$)=0 THEN RETURN
	IF	LINE$(1)="*" OR LINE$(1)=";" THEN
		REST$=LINE$
		RETURN
	FI

	TEMP$	=UPPERCASE$(LINE$)

PREPARSEFORLABEL:	IF	TEMP$(1,1)=' ' OR TEMP$(1,1)='	'
	THEN
		GOSUB	EATSPACES
		IF	FIND(TEMP$,';')=1 THEN
			REST$=LINE$
			RETURN
		FI
		GOTO	PREPARSEFORCF
	FI

	I	=FIND(TEMP$,'	')
	J	=FIND(TEMP$,' ')

	IF	I=0 THEN I=J
	IF	J=0 THEN J=I
	IF	I<J THEN
		LABEL$	=TEMP$(1,I-1)
		TEMP$	=RIGHT$(TEMP$,I+1)
	ELSE
		IF J=0 THEN
			LABEL$=TEMP$
			RETURN
		FI
		LABEL$	=TEMP$(1,J-1)
		TEMP$	=RIGHT$(TEMP$,J+1)
	FI

	GOSUB	EATSPACES

PREPARSEFORCF:	IF	TEMP$=""
	THEN
		LABEL$=""
		REST$=LINE$
		RETURN
	FI

	I	=FIND(TEMP$,'	')
	J	=FIND(TEMP$,' ')
	IF	I=0 THEN I=J
	IF	J=0 THEN J=I

	IF	I<J THEN
		CF$	=TEMP$(1,I-1)
		TEMP$	=RIGHT$(TEMP$,I+1)
	ELSE
		IF J=0 THEN
			CF$=TEMP$
			RETURN
		FI
		CF$	=TEMP$(1,J-1)
		TEMP$	=RIGHT$(TEMP$,J+1)
	FI

	GOSUB	EATSPACES

PREPARSEFORAF:	IF TEMP$="" THEN RETURN

	IF	FIND(TEMP$,";")=1 THEN PREPARSEREST

	I	=FIND(TEMP$,"	")
	J	=FIND(TEMP$," ")

	IF	I=0  THEN I=J
	IF	J=0 THEN J=I
	IF	I<J
	THEN
		AF$	=TEMP$(1,I-1)
		TEMP$	=RIGHT$(TEMP$,I+1)
	ELSE
		IF J=0 THEN
			AF$=TEMP$
			RETURN
		FI
		AF$	=TEMP$(1,J-1)
		TEMP$	=RIGHT$(TEMP$,J+1)
	FI

	GOSUB	EATSPACES

PREPARSEREST:	REST$	=TEMP$
	RETURN

                  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                  ! EAT SPACES AND TABS FROM FRONT OF TEMP$ !
                  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

EATSPACES:	IF FIND(TEMP$,' ')=1 OR FIND(TEMP$,'	')=1 THEN
			TEMP$=RIGHT$(TEMP$,2)
			GOTO EATSPACES
		FI
	RETURN






                        !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                        ! ACTUAL MACRO EXPANSION CODE !
                        !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!	Macro states:
!		1-not defining nor expanding a macro
!		2-expanding a macro (included for completeness)
!		3-defining a macro

MACROEXPANDER:	MLINE$	=LINE$
	ON MACROSTATE GOTO MACROSTART, EXPANDLOOP, ENDMACDEF
	PRINT	"Freak out at macroexpander:"

!	state 1: look for either starting to define the macro
!	         or a macro call.  If neither, just pass line
!	         to the output routine.

MACROSTART:	IF	LABEL$="MACRO" THEN STARTMACDEF

!	now, look to see if name is in macro table...

	TEMP$	=FF$ CAT CF$ CAT FE$
	MACROPOS	=FIND(MACROS$,TEMP$)

	IF	NOT(MACROPOS) THEN
		GOSUB MACROOUTPUT
		GOTO  GETLINE
	FI

	NEWFLAGS=0
!	Since we're here, we have found a macro which matches CF$

!	Now, parse the arguments... (iQUE DOLOR!)

!	LIST MACRO CALL WITH ";" FOLLOWING LABEL FIELD-SEPARATOR

	I=FIND(MLINE$,CF$)
	MLINE$=LEFT$(MLINE$,I-1) CAT ";" CAT RIGHT$(MLINE$,I)
	GOSUB MACROOUTPUT

!
!	first, determine if we're using either immediate or
!	indirect addressing, and set or reset flags accordingly
!
	IF	FIND(AF$,'[') THEN
		IF	AF$(LEN(AF$),1)=']' THEN
			AF$	=RIGHT$(AF$,2)
			AF$	=AF$(1,LEN(AF$)-1)
		ELSE
			PRINT	"Bad indirect syntax: "
			PRINT	LINE$
			AF$	=RIGHT$(AF$,2)
		FI
		NEWFLAGS=NEWFLAGS!INDIRECTFLAG
	ELSE
		IF	FIND(AF$,'#')=1 THEN
			AF$	=RIGHT$(AF$,2)
			NEWFLAGS=NEWFLAGS!IMMEDIATEFLAG
			GOTO	BINDARGS
		ELSE
		FI
	FI

!	Now, determine indexing, and set or reset the various flags

	T$	=",--X"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPREDEC
		GOSUB	SETDOUBLE
		GOSUB	SETINDEXOFFX
		GOTO	BINDARGS
	FI

	T$	=",-X"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPREDEC
		GOSUB	SETSINGLE
		GOSUB	SETINDEXOFFX
		GOTO	BINDARGS
	FI

	T$	=",X++"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPOSTINC
		GOSUB	SETDOUBLE
		GOSUB	SETINDEXOFFX
		GOTO	BINDARGS
	FI

	T$	=",X+"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPOSTINC
		GOSUB	SETSINGLE
		GOSUB	SETINDEXOFFX
		GOTO	BINDARGS
	FI

	T$	=",X"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETNOINCDEC
		GOSUB	SETINDEXOFFX
		GOTO	BINDARGS
	FI
	T$	=",--S"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPREDEC
		GOSUB	SETDOUBLE
		GOSUB	SETINDEXOFFS
		GOTO	BINDARGS
	FI

	T$	=",-S"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPREDEC
		GOSUB	SETSINGLE
		GOSUB	SETINDEXOFFS
		GOTO	BINDARGS
	FI

	T$	=",S++"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPOSTINC
		GOSUB	SETDOUBLE
		GOSUB	SETINDEXOFFS
		GOTO	BINDARGS
	FI

	T$	=",S+"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPOSTINC
		GOSUB	SETSINGLE
		GOSUB	SETINDEXOFFS
		GOTO	BINDARGS
	FI

	T$	=",S"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETNOINCDEC
		GOSUB	SETINDEXOFFS
		GOTO	BINDARGS
	FI
	NEWFLAGS=NEWFLAGS!DIRECTFLAG


!	now that we have determined any addressing modes, bind
!	the arguments for the expansion phase

BINDARGS:	NARGS	=0
	ARGS$	=""
	GOSUB	GENFLAGS

BINDLOOP:	I	=FIND(AF$,",")
	IF	NOT(I) THEN LASTARG
	NARGS	=NARGS+1

	ARGSP(NARGS)	=LEN(ARGS$)+1
	ARGSL(NARGS)	=I-1
	LEN(ARGS$)	=LEN(ARGS$)+I-1
	ARGS$(ARGSP(NARGS),ARGSL(NARGS))=AF$(1,I-1)

	AF$	=RIGHT$(AF$,I+1)
	GOTO	BINDLOOP

LASTARG:	IF	AF$="" THEN EXPAND

	NARGS	=NARGS+1
	ARGSP(NARGS)	=LEN(ARGS$)+1
	ARGSL(NARGS)	=LEN(AF$)
	LEN(ARGS$)	=LEN(ARGS$)+LEN(AF$)
	ARGS$(ARGSP(NARGS),ARGSL(NARGS))=AF$

!	now start the expansion of the macro

	MLINE$	="NARGS	SET	" CAT NUM$(NARGS)
	GOSUB	MACROOUTPUT
EXPAND:	GOSUB	MACROFETCHINIT

EXPANDLOOP:	GOSUB	MACROFETCH

	IF	MACROLINE$="MEND" THEN GETLINE
	I	=0

SUBSARGSLOOP:	J=I+FIND(RIGHT$(MACROLINE$,I+1),"?")
	IF	J=I THEN DONETHISLINE
	IF	J=LEN(MACROLINE$) THEN DONETHISLINE

	I	=J
	IF	MACROLINE$(I+1)>='0' AND MACROLINE$(I+1)<='9'
	THEN
		J	=VAL(MACROLINE$(I+1,1))+1
		IF	J>NARGS THEN
		MACROLINE$=MACROLINE$(1,I-1) CAT '0' CAT ...
&			RIGHT$(MACROLINE$,I+2)
		GOTO	SUBSARGSLOOP
		FI
		MACROLINE$=MACROLINE$(1,I-1) CAT ...
&			ARGS$(ARGSP(J),ARGSL(J)) CAT ...
&			RIGHT$(MACROLINE$,I+2)
		GOTO	SUBSARGSLOOP
	FI

!	maybe it's a local label...

	IF	MACROLINE$(I+1)>='A' AND MACROLINE$(I+1)<='Z'
	THEN
		J	=MACROLINE$(I+1)-'A'+1
		IF	J>NLABELSUSED
		THEN	NLABELSUSED	=J
		MACROLINE$=MACROLINE$(1,I-1) CAT ...
&			"MACRO" CAT HEX$(J+LABELBASE) CAT ...
&			RIGHT$(MACROLINE$,I+2)
	FI
	GOTO	SUBSARGSLOOP

DONETHISLINE:	MLINE$	=MACROLINE$
	GOSUB	MACROOUTPUT
	LABELBASE	=LABELBASE+NLABELSUSED
	NLABELSUSED=0
	GOTO	EXPANDLOOP


!	Macro definition loop

STARTMACDEF:	IF	CF$="" THEN
		PRINT	"NULL MACRO NAME ENCOUNTERED!"
		GOTO	ENDMACDEF
	FI

	GETCURPOS$(CHANNEL)	=CURCHAN
	SYSCALL	(GETCURPOS$,'',BYTES4$)

	BYTES4$(1)=CURCHAN

	MACRO$	=FF$ CAT CF$ CAT FE$ CAT BYTES4$

	LEN(MACROS$)=LEN(MACROS$)+LEN(MACRO$)
	MACROS$(LEN(MACROS$)+1-LEN(MACRO$),LEN(MACRO$))= MACRO$
	MACROSTATE	=3
	GOTO	GETLINE

ENDMACDEF:	IF	CF$<>"MEND" THEN GETLINE
	MACROSTATE=1
	GOTO	GETLINE




                           !!!!!!!!!!!!!!!!!!!!!!!!!
                           ! EXPANSION SUBROUTINES !
                           !!!!!!!!!!!!!!!!!!!!!!!!!



!	removeit...removes the indexing and sets various flags

REMOVEIT:	AF$	=AF$(1,YES-1) CAT RIGHT$(AF$,YES+LEN(T$))

	NEWFLAGS=NEWFLAGS!INDEXEDFLAG
	RETURN

!	findit...finds t$ (real tough)

FINDIT:	YES	=FIND(AF$,T$)
	RETURN

SETPOSTINC:	NEWFLAGS=NEWFLAGS!POSTINCFLAG
	RETURN


SETPREDEC:	NEWFLAGS=NEWFLAGS!PREDECFLAG
	RETURN
SETSINGLE:	RETURN

SETDOUBLE:	NEWFLAGS=NEWFLAGS!DOUBLEFLAG
	RETURN

SETINDEXOFFX:	NEWFLAGS=NEWFLAGS!INDEXOFFXFLAG
	RETURN

SETINDEXOFFS:	NEWFLAGS=NEWFLAGS!INDEXOFFSFLAG
	RETURN

SETNOINCDEC:	RETURN

!	macro fetch init... prepare for fetching macros

MACROFETCHINIT:	I	=FIND(RIGHT$(MACROS$,MACROPOS),FE$)
	MACRO$	=MACROS$(MACROPOS,I+4)

	GETCURPOS$(CHANNEL)=MACRO$(I+1)
	SYSCALL	(GETCURPOS$,'',BYTES4$)

	POSITION	#MACRO$(I+1), ...
&		MACRO$(I+2)*65536+MACRO$(I+3)*256+MACRO$(I+4)


	RETURN

!	macro fetch...must watch for end of macro

MACROFETCH:	INPUT	#MACRO$(LEN(MACRO$)-3), MLINE$
	IF	EOF(MACRO$(LEN(MACRO$)-3)) THEN
		PRINT	"End encountered before MEND"
		MLINE$	="	MEND"
	FI
	LINE$	=MLINE$
	GOSUB	PREPARSE
	IF	CF$="MEND" THEN
		POSITION	#MACRO$(LEN(MACRO$)-3), ...
&		BYTES4$(2)*65536+BYTES4$(3)*256+BYTES4$(4)
		MLINE$	="MEND"
	FI

	MACROLINE$	=MLINE$
	RETURN


                      !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                      ! MACRO OUTPUT ROUTINE...FOR NOW !
                      !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


MACROOUTPUT:	PRINT	#OUTPUT, MLINE$
	RETURN

GENFLAGS:	TEMP	=OLDFLAGS&(:FFFF XOR  NEWFLAGS)
	IF	TEMP&IMMEDIATEFLAG THEN
	MLINE$	="IMMEDIATE	SET	0"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&INDIRECTFLAG THEN
	MLINE$	="INDIRECT	SET	0"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&DIRECTFLAG THEN
	MLINE$	="DIRECT	SET	0"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&INDEXOFFXFLAG THEN
	MLINE$	="INDEXOFFX	SET	0"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&INDEXOFFSFLAG THEN
	MLINE$	="INDEXOFFS	SET	0"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&POSTINCFLAG THEN
	MLINE$	="POSTINCREMENT	SET	0"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&PREDECFLAG THEN
	MLINE$	="PREDECREMENT	SET	0"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&DOUBLEFLAG THEN
	MLINE$	="DOUBLEINCDEC	SET	0"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&INDEXEDFLAG THEN
	MLINE$	="INDEXED	SET	0"
	GOSUB	MACROOUTPUT
	FI

	TEMP	=NEWFLAGS&(OLDFLAGS XOR :FFFF)

	IF	TEMP&IMMEDIATEFLAG THEN
	MLINE$	="IMMEDIATE	SET	1"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&INDIRECTFLAG THEN
	MLINE$	="INDIRECT	SET	1"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&DIRECTFLAG THEN
	MLINE$	="DIRECT	SET	1"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&INDEXOFFXFLAG THEN
	MLINE$	="INDEXOFFX	SET	1"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&INDEXOFFSFLAG THEN
	MLINE$	="INDEXOFFS	SET	1"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&POSTINCFLAG THEN
	MLINE$	="POSTINCREMENT	SET	1"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&PREDECFLAG THEN
	MLINE$	="PREDECREMENT	SET	1"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&DOUBLEFLAG THEN
	MLINE$	="DOUBLEINCDEC	SET	1"
	GOSUB	MACROOUTPUT
	FI

	IF	TEMP&INDEXEDFLAG THEN
	MLINE$	="INDEXED	SET	1"
	GOSUB	MACROOUTPUT
	FI

	OLDFLAGS=NEWFLAGS
	RETURN
	END
