!   MAKEINTEL -- PROGRAM TO MANUFACTURE INTEL HEX RECORDS...
!                 FROM SDOS LOAD RECORD FILES
!
!   REVISION HISTORY:
!       MAKEMIKBUGV1.0B 2/2/81
!                 RELEASED WITH BASIC14H
!       MAKEMIKBUGV1.1A 4/25/82
!                 CLEANED UP OPERATOR INTERFACE
!                 PRINTS CPU TYPE ('00, '01 OR '09) WHEN MAKING RECORDS
!                 RELEASED WITH SDOS/09
!
!       MAKEINTELV1.0A 5/5/83
!                 GENERATED TO ALLOW SDOS BINARY FILES TO BE SENT TO CP/M
!
!
!       Format of INTEL HEX records:
!          :ccaaaa00dddd...ddss<CR>
!       where : is a colon
!       cc is the ascii hex count of data bytes
!       aaaa is the ascii hex address
!       00 is ascii "00"
!       dd is ascii hex for a byte value
!       and ss is the ascii hex for the checksum byte
!           The checksum value is : :FF xor LSB(SUM(all bytes except cksum))
!       Last INTEL HEX record must be:
!         :00010010

        DIM VERSION$/"Make INTEL HEX format v1.0a"/
        DIM BYTE$(1), ADDRESS$(2), COUNT$(2)
        DIM SDOSFILE$(100), MIKBUGFILE$(100), LINE$(200)
        DIM I, IN/1/, OUT/2/, RECORDTYPE, COUNT
        DIM ADDRESS,CHECKSUM

DEF HEX2$(X1)=HEX$(X1)[4,2]

DEF HEX4$(X2)=HEX$(X2)[2,4]

        IF COL(0)>1
        THEN
            ! Smart user, file name is on command line
            INPUT '' LINE$
            PRINT Version$
            LET LINE$=UPPERCASE$(LINE$)
            LET I=FIND(LINE$," TO ")
            IF I=0 THEN ERROR 102 \ ! BAD COMMAND FORMAT
            LET SDOSFILE$=LINE$[1,I-1]
            LET MIKBUGFILE$=RIGHT$(LINE$,I+4)
        ELSE
            PRINT Version$
            INPUT 'SDOS object file to convert to INTEL HEX: ' SDOSFILE$
            INPUT 'INTEL HEX output file: ' MIKBUGFILE$
            PRINT "Next time, you can type:"
            PRINT "     .makeintelhex ";SDOSFILE$;" to ";MIKBUGFILE$
        FI
        OPEN #IN, SDOSFILE$
        CREATE #OUT, MIKBUGFILE$

        ! PROCESS THE START RECORD
        READ #IN,BYTE$,ADDRESS$
        IF BYTE$[1]=1 THEN PRINT "6800 Object file"
        ELSEIF BYTE$[1]=2 THEN PRINT "6809 Object file"
        ELSEIF BYTE$[1]=3 THEN PRINT "6801 Object file"
        ELSE ERROR 1028 \ ! Not load record format file
        PRINT   "Record type= START  ";
        PRINT "address= ";HEX$(ADDRESS$(1)**8+ADDRESS$(2))
        READ #IN, ADDRESS$

100     READ #IN, BYTE$ \ ! SEE WHAT KIND OF RECORD IT IS
        RECORDTYPE = BYTE$(1)
        ON RECORDTYPE + 1 GOTO 1000, 2000, 3000, 4000
2000    PRINT "Illegal record type encountered (:";hex$(RECORDTYPE)[4,2];")"
        ERROR 1036 \ ! SDOS LOAD RECORD FORMAT ERROR

1000    ! THIS IS A SKIP RECORD
        READ #IN, COUNT$
        COUNT = COUNT$(1)*256 + COUNT$(2)
        PRINT   'Record type= SKIP   count= ' ; HEX$(COUNT)
        IF COUNT = 0 THEN 100
        FOR I = 1 TO COUNT DO READ #IN, BYTE$
        GOTO 100

4000    ! THIS IS A TERMINAL LOAD RECORD
        PRINT   "Record type= GO     ";
        GOTO 3001
3000    ! THIS IS A LOAD RECORD
        PRINT   "Record type= LOAD   ";
3001    READ #IN, ADDRESS$, COUNT$
        ADDRESS = ADDRESS$(1)*256 + ADDRESS$(2)
        PRINT "address= ";HEX$(ADDRESS);"  ";
        COUNT = COUNT$(1)*256+COUNT$(2)
        PRINT "count= ";HEX$(COUNT)
5000    REM OUTPUT A MIKBUG RECORD
        IF COUNT <16 THEN 5100
        PRINT #OUT,":10";
        LET CHECKSUM=(:10+(ADDRESS**-8)+(ADDRESS&:FF))&:FF
        PRINT #OUT,HEX4$(ADDRESS);"00";
        FOR I=1 TO 16
5010            READ #IN,BYTE$
                LET COUNT=COUNT-1
                LET ADDRESS=ADDRESS+1
                PRINT #OUT,HEX2$(BYTE$(1));
                LET CHECKSUM=(CHECKSUM+BYTE$(1))&:FF
        NEXT I
5020    PRINT #OUT,HEX2$( :100-CHECKSUM )
        GOTO 5000

5100    IF COUNT <= 0 THEN 5130
        PRINT #OUT,":";HEX2$(COUNT);
        PRINT #OUT,HEX4$(ADDRESS);"00";
        LET CHECKSUM=(COUNT+(ADDRESS**-8)+(ADDRESS&:FF))&:FF
        FOR I=1 TO COUNT
                READ #IN,BYTE$
                COUNT=COUNT-1
                ADDRESS=ADDRESS+1
                PRINT #OUT,HEX2$(BYTE$(1));
                LET CHECKSUM=(CHECKSUM+BYTE$(1))&:FF
        NEXT I
5120    PRINT #OUT,HEX2$( :100-CHECKSUM )
5130    IF RECORDTYPE <> 3 THEN 100
        PRINT #OUT, ':00010010'
        PRINT 'All done'
        EXIT

END
